/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection.dialog;

import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeRegister;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.SelectionPolicies;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.selection.dialog.SourceSelectionComboBox;
import com.mathworks.comparisons.selection.dialog.SourceSelectionErrorReporter;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJComboBox;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;

public final class DetermineComparisonTypes
implements ActionListener {
    private final ComparisonSelection mCurrentSelection;
    private final ComparisonTypeRegister mComparisonTypeRegister;
    private final SelectionPoliciesRegister mSelectionPoliciesRegister;
    private final MJComboBox mComparisonTypesCombo;
    private final SourceSelectionErrorReporter mErrorReporter;
    private final SourceSelectionComboBox[] mSelectionComboBoxes = new SourceSelectionComboBox[]{null, null};

    public DetermineComparisonTypes(ComparisonSelection comparisonSelection, ComparisonTypeRegister comparisonTypeRegister, SelectionPoliciesRegister selectionPoliciesRegister, SourceSelectionComboBox sourceSelectionComboBox, SourceSelectionComboBox sourceSelectionComboBox2, MJComboBox mJComboBox, SourceSelectionErrorReporter sourceSelectionErrorReporter) {
        this.mCurrentSelection = comparisonSelection;
        this.mComparisonTypeRegister = comparisonTypeRegister;
        this.mSelectionPoliciesRegister = selectionPoliciesRegister;
        this.mSelectionComboBoxes[0] = sourceSelectionComboBox;
        this.mSelectionComboBoxes[1] = sourceSelectionComboBox2;
        this.mComparisonTypesCombo = mJComboBox;
        this.mErrorReporter = sourceSelectionErrorReporter;
        String string = this.updateStateFromCurrentSelection();
        this.mErrorReporter.showError(string);
    }

    @Override
    public synchronized void actionPerformed(ActionEvent actionEvent) {
        ComparisonSelection.Index index;
        assert (actionEvent.getSource() instanceof SourceSelectionComboBox);
        SourceSelectionComboBox sourceSelectionComboBox = (SourceSelectionComboBox)((Object)actionEvent.getSource());
        ComparisonSelection.Index index2 = index = sourceSelectionComboBox == this.mSelectionComboBoxes[0] ? ComparisonSelection.Index.FIRST : ComparisonSelection.Index.SECOND;
        if (this.checkNewSelection(sourceSelectionComboBox.getSelectedItem(), index)) {
            this.mComparisonTypesCombo.removeAllItems();
            String string = this.analyzeCurrentSelections();
            this.mErrorReporter.showError(string);
        } else if (!actionEvent.getActionCommand().equals("SelectionChanged")) {
            this.putCurrentSelectionAtTop(sourceSelectionComboBox.getSelectedItem(), index.ordinal());
        }
    }

    private String updateStateFromCurrentSelection() {
        this.updateStateFromCurrentSelection(ComparisonSelection.Index.FIRST);
        this.updateStateFromCurrentSelection(ComparisonSelection.Index.SECOND);
        return this.analyzeCurrentSelections();
    }

    private void updateStateFromCurrentSelection(ComparisonSelection.Index index) {
        if (this.mCurrentSelection.hasSelection(index)) {
            Object object = this.mCurrentSelection.getSelection(index);
            this.mSelectionComboBoxes[index.ordinal()].setSelectedItem(object);
            this.updateComboBox(object, index.ordinal());
        }
    }

    private String analyzeCurrentSelections() {
        ComparisonSelection.Index index;
        String string = "";
        ComparisonSelection.Index index2 = ComparisonSelection.Index.FIRST;
        if (this.mCurrentSelection.hasSelection(index2)) {
            try {
                this.mCurrentSelection.convertToComparisonSource(index2);
            }
            catch (InvalidConversionException invalidConversionException) {
                string = string + ResourceManager.format("selectiondialog.problemwithfirst", invalidConversionException.getReasonInvalid()) + "\n";
            }
        }
        if (this.mCurrentSelection.hasSelection(index = ComparisonSelection.Index.SECOND)) {
            try {
                this.mCurrentSelection.convertToComparisonSource(index);
            }
            catch (InvalidConversionException invalidConversionException) {
                string = string + ResourceManager.format("selectiondialog.problemwithsecond", invalidConversionException.getReasonInvalid());
            }
        }
        if (this.mCurrentSelection.hasComparisonSources()) {
            try {
                List<ComparisonType> list = this.getComparisonTypes();
                if (list.size() > 0) {
                    for (ComparisonType comparisonType : list) {
                        this.mComparisonTypesCombo.addItem((Object)comparisonType);
                    }
                    this.mComparisonTypesCombo.setSelectedIndex(0);
                } else {
                    this.mComparisonTypesCombo.setSelectedIndex(-1);
                    string = ResourceManager.getString("selectiondialog.cannotcompare");
                }
            }
            catch (Exception exception) {
                string = ResourceManager.getString("selectiondialog.unknownproblem");
                exception.printStackTrace();
            }
        }
        return string;
    }

    private List<ComparisonType> getComparisonTypes() {
        ComparisonSource comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
        ComparisonSource comparisonSource2 = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
        return this.mComparisonTypeRegister.getCompatibleComparisonTypes(comparisonSource, comparisonSource2, null);
    }

    private void putCurrentSelectionAtTop(Object object, int n) {
        if (this.mSelectionComboBoxes[n].getItemCount() > 0 && !this.mSelectionComboBoxes[n].getItemAt(0).equals(object)) {
            this.mSelectionComboBoxes[n].addItem(object);
        }
    }

    private boolean checkNewSelection(Object object, ComparisonSelection.Index index) {
        boolean bl = false;
        Object object2 = this.mCurrentSelection.getSelection(index);
        if (this.isChanged(object2, object)) {
            bl = true;
            this.updateComboBox(object, index.ordinal());
            if (object != null && !object.getClass().equals(String.class)) {
                this.mCurrentSelection.setSelection(index, this.getSelectionDataTypeFromType(object.getClass()), object);
            } else {
                this.mCurrentSelection.setSelection(index, this.getSelectionDataTypeFromComboBox(index.ordinal()), object);
            }
        }
        return bl;
    }

    private SelectionDataType getSelectionDataTypeFromType(Class<?> clazz) {
        SelectionPolicies selectionPolicies = this.mSelectionPoliciesRegister.getPolicies(clazz);
        return selectionPolicies.getSelectionDataType();
    }

    private SelectionDataType getSelectionDataTypeFromComboBox(int n) {
        SelectionPolicies selectionPolicies = this.mSelectionPoliciesRegister.getPolicies(this.mSelectionComboBoxes[n].getCurrentStringConversionPolicyClass());
        return selectionPolicies.getSelectionDataType();
    }

    private void updateComboBox(Object object, int n) {
        this.mSelectionComboBoxes[n].getEditor().setItem(object);
        if (!this.mSelectionComboBoxes[n].isPopupVisible()) {
            this.mSelectionComboBoxes[n].addItem(object);
        }
    }

    private boolean isChanged(Object object, Object object2) {
        return !(object == null && object2 == null || object != null && object2 != null && object.equals(object2));
    }
}

