/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.report;

import com.mathworks.comparisons.gui.dialogs.InternalWarningPanel;
import com.mathworks.comparisons.report.ComparisonReport;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.impl.ComparisonSourceListener;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJComponent;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

public class ReportComparisonSourceListener
implements ComparisonSourceListener {
    private final ComparisonReport fReport;
    private final ComparisonSource fSource;
    private final AtomicBoolean fNotificationEngaged = new AtomicBoolean(false);

    public ReportComparisonSourceListener(ComparisonReport comparisonReport, ComparisonSource comparisonSource) {
        this.fReport = comparisonReport;
        this.fSource = comparisonSource;
    }

    @Override
    public void changedOnDisk() {
        if (PlatformInfo.isMacintosh()) {
            return;
        }
        if (!this.fNotificationEngaged.getAndSet(true)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final Component component = ReportComparisonSourceListener.this.fReport.getRootPane().getGlassPane();
                    InternalWarningPanel.OptionListener optionListener = new InternalWarningPanel.OptionListener(){

                        @Override
                        public void selectedOption(InternalWarningPanel.Option option) {
                            ReportComparisonSourceListener.this.fReport.getRootPane().setGlassPane(component);
                            component.setVisible(false);
                            ReportComparisonSourceListener.this.repaintReport();
                            if (option == InternalWarningPanel.Option.YES) {
                                ReportComparisonSourceListener.this.fReport.refresh();
                            }
                            ReportComparisonSourceListener.this.fNotificationEngaged.set(false);
                        }
                    };
                    JComponent jComponent = ReportComparisonSourceListener.this.createGlassPaneWithWarningPanel(optionListener);
                    ReportComparisonSourceListener.this.fReport.getRootPane().setGlassPane(jComponent);
                    jComponent.setVisible(true);
                    ReportComparisonSourceListener.this.repaintReport();
                }
            });
        }
    }

    private JComponent createGlassPaneWithWarningPanel(InternalWarningPanel.OptionListener optionListener) {
        MJComponent mJComponent = new MJComponent();
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){};
        mJComponent.addMouseListener(mouseInputAdapter);
        mJComponent.addMouseMotionListener(mouseInputAdapter);
        mJComponent.setLayout(new GridBagLayout());
        String string = (String)this.fSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
        InternalWarningPanel internalWarningPanel = new InternalWarningPanel(ResourceManager.format("file.changed.warning", string), optionListener);
        mJComponent.add(internalWarningPanel.getComponent());
        return mJComponent;
    }

    private void repaintReport() {
        this.fReport.revalidate();
        this.fReport.repaint();
    }
}

