/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.register.analyze;

import com.mathworks.comparisons.register.ComparisonTypeDeterminantAnalyzer;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.property.CSPropertyName;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.source.type.CSTypeFile;
import java.io.File;
import org.apache.commons.lang.Validate;

public class CTDAnalyzerFileExtension
implements ComparisonTypeDeterminantAnalyzer<String> {
    @Override
    public String getValue(ComparisonSource comparisonSource) {
        Validate.notNull((Object)comparisonSource, (String)"Comparison source should not be null");
        String string = null;
        if (comparisonSource.hasProperties(new CSTypeFile().getProperties())) {
            int n;
            String string2 = CTDAnalyzerFileExtension.getFileNameFromReadableLocationProperty(comparisonSource);
            if (string2 == null) {
                string2 = CTDAnalyzerFileExtension.getFileNameFromNameProperty(comparisonSource);
            }
            if (string2 != null && (n = string2.lastIndexOf(46)) > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1);
            }
            comparisonSource.refresh();
        }
        return string;
    }

    private static String getFileNameFromReadableLocationProperty(ComparisonSource comparisonSource) {
        CSPropertyReadableLocation cSPropertyReadableLocation = CSPropertyReadableLocation.getInstance();
        Object object = null;
        try {
            object = comparisonSource.getPropertyValue(cSPropertyReadableLocation, new ComparisonSourcePropertyInfo[0]);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (object == null) {
            return null;
        }
        if (!cSPropertyReadableLocation.isValueType(object.getClass())) {
            throw new IllegalStateException("Readable location must be a \"File\"");
        }
        File file = (File)object;
        return file.getName();
    }

    private static String getFileNameFromNameProperty(ComparisonSource comparisonSource) {
        CSPropertyName cSPropertyName = CSPropertyName.getInstance();
        Object object = comparisonSource.getPropertyValue(cSPropertyName, new ComparisonSourcePropertyInfo[0]);
        if (object == null) {
            return null;
        }
        if (!cSPropertyName.isValueType(object.getClass())) {
            throw new IllegalStateException("Name must be a \"String\"");
        }
        return (String)object;
    }
}

