/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.prefs.impl;

import com.mathworks.comparisons.filter.list.FileNameFilter;
import com.mathworks.comparisons.filter.list.StringFilter;
import com.mathworks.comparisons.prefs.GlobalPreferenceManager;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public final class ListComparisonFileNamePreferences
extends GlobalPreferenceManager {
    private static final String FILTER_PREFERENCE_NAME = "FileNameFilters";
    private static final String FILTER_PREFERENCE_DEFAULT = "";
    private static final String OLD_DELIMITER = "\"";

    public ListComparisonFileNamePreferences() {
        super(FILTER_PREFERENCE_NAME, FILTER_PREFERENCE_DEFAULT);
    }

    public Map<StringFilter, Boolean> getFilters() {
        String string = this.getString();
        if (string.contains(OLD_DELIMITER)) {
            return this.getFiltersSavedWithOldFormat();
        }
        return this.getFiltersSavedWithNewFormat();
    }

    public void saveFilters(Map<StringFilter, Boolean> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Map.Entry<StringFilter, Boolean> entry : map.entrySet()) {
            StringFilter stringFilter = entry.getKey();
            hashMap.put(stringFilter.getName(), Boolean.toString(entry.getValue()));
        }
        this.setStringMap(hashMap);
    }

    private Map<StringFilter, Boolean> getFiltersSavedWithOldFormat() {
        HashMap<StringFilter, Boolean> hashMap = new HashMap<StringFilter, Boolean>();
        String string = this.getString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, OLD_DELIMITER);
        while (stringTokenizer.hasMoreTokens()) {
            FileNameFilter fileNameFilter = new FileNameFilter(stringTokenizer.nextToken());
            hashMap.put(fileNameFilter, true);
        }
        return hashMap;
    }

    private Map<StringFilter, Boolean> getFiltersSavedWithNewFormat() {
        HashMap<StringFilter, Boolean> hashMap = new HashMap<StringFilter, Boolean>();
        Map<String, String> map = this.getStringMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            FileNameFilter fileNameFilter = new FileNameFilter(entry.getKey());
            hashMap.put(fileNameFilter, Boolean.parseBoolean(entry.getValue()));
        }
        return hashMap;
    }
}

