/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.main;

import com.mathworks.comparisons.compare.CannotRunWithoutDisplayException;
import com.mathworks.comparisons.compare.ChildComparisonListener;
import com.mathworks.comparisons.compare.Comparison;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.ComparisonEventData;
import com.mathworks.comparisons.event.ComparisonEventListener;
import com.mathworks.comparisons.main.ComparisonTool;
import com.mathworks.comparisons.main.ComparisonUtilities;
import com.mathworks.comparisons.main.SelectionIncompleteException;
import com.mathworks.comparisons.param.parameter.ChildComparisonComparisonParameter;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.report.ComparisonReport;
import com.mathworks.comparisons.report.ReportActivationListener;
import com.mathworks.comparisons.report.ReportComparisonSourceListener;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.selection.ComparisonSelection;
import com.mathworks.comparisons.selection.dialog.SourceSelectionDialog;
import com.mathworks.comparisons.selection.dialog.SourceSelectionListModel;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.source.ComparisonSourcePropertyInfo;
import com.mathworks.comparisons.source.ComparisonSourceUtilities;
import com.mathworks.comparisons.source.impl.ComparisonSourceListener;
import com.mathworks.comparisons.source.property.CSPropertyAbsoluteName;
import com.mathworks.comparisons.source.property.CSPropertyReadableLocation;
import com.mathworks.comparisons.util.ExceptionHandler;
import com.mathworks.comparisons.util.FeatureSwitches;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingWorker;
import org.apache.commons.lang.Validate;

public class ComparisonDriver
implements ComparisonEventListener {
    private static final Map<String, Method> KNOWN_EVENT_METHODS = new HashMap<String, Method>();
    private static final Set<String> UNKNOWN_EVENT_NAMES = new HashSet<String>();
    private final ComparisonSelection mCurrentSelection;
    private final Set<ComparisonStatus> mComparisonStatus = EnumSet.noneOf(ComparisonStatus.class);
    private volatile Comparison<?> mComparison = null;
    private volatile Desktop mParentDesktop = null;
    private volatile DTGroupPropertyProvider mParentGroup = null;
    private volatile ComparisonReport mReport = null;
    private volatile ComparisonSourceListener fLeftSourceListener;
    private volatile ComparisonSourceListener fRightSourceListener;
    private volatile DTClientListener fReportActivationListener;

    public ComparisonDriver(ComparisonSelection comparisonSelection) {
        Validate.notNull((Object)comparisonSelection);
        this.mCurrentSelection = comparisonSelection;
        if (this.mCurrentSelection.isSelectionReady()) {
            this.mComparisonStatus.add(ComparisonStatus.SELECTION_READY);
        }
    }

    public void compareAndDisplay(Desktop desktop, DTGroupPropertyProvider dTGroupPropertyProvider) {
        this.mParentDesktop = desktop;
        this.mParentGroup = dTGroupPropertyProvider;
        SourceSelectionDialog sourceSelectionDialog = null;
        if (!this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY)) {
            sourceSelectionDialog = ComparisonUtilities.createSelectionDialog(this, this.mCurrentSelection);
        }
        ComparisonReport.createComparisonReport(desktop, dTGroupPropertyProvider, this, sourceSelectionDialog);
    }

    public ComparisonResult<?> compareAndReturn() throws CannotRunWithoutDisplayException, SelectionIncompleteException {
        if (this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY)) {
            ComparisonType comparisonType = this.mCurrentSelection.getComparisonType();
            if (comparisonType.hasFeature(ComparisonTypeFeature.CANRUNWITHOUTDISPLAY)) {
                this.mCurrentSelection.prepareForComparison();
                this.updatePreviouslyComparedList();
                this.mComparison = comparisonType.createComparison();
                return this.mComparison.compareAndReturn(this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST), this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND), this.mCurrentSelection);
            }
            throw new CannotRunWithoutDisplayException(comparisonType.getDescription());
        }
        throw new SelectionIncompleteException();
    }

    public void dispose() {
        if (this.mComparison != null) {
            this.mComparison.dispose();
            this.mComparison = null;
        }
        this.removeFileChangedNotificationListeners();
        this.mCurrentSelection.dispose();
        ComparisonTool.getInstance().removeDriver(this);
        this.mReport = null;
    }

    private void removeFileChangedNotificationListeners() {
        if (FeatureSwitches.checkFileChangedInTheBackground()) {
            ComparisonSource comparisonSource;
            ComparisonSource comparisonSource2 = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
            if (comparisonSource2 != null && this.fLeftSourceListener != null) {
                comparisonSource2.removeListener(this.fLeftSourceListener);
            }
            if ((comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND)) != null && this.fRightSourceListener != null) {
                comparisonSource.removeListener(this.fRightSourceListener);
            }
        }
        if (FeatureSwitches.checkFileChangedOnActivation() && this.mParentDesktop != null && this.mReport != null && this.fReportActivationListener != null) {
            this.mParentDesktop.removeClientListener((Component)((Object)this.mReport), this.fReportActivationListener);
        }
    }

    @Override
    public void processEvent(ComparisonEvent comparisonEvent) {
        assert (comparisonEvent != null && comparisonEvent.getEventData() != null);
        ComparisonEventData comparisonEventData = comparisonEvent.getEventData();
        String string = comparisonEventData.getName();
        Method method = this.getEventHandlerFor(string);
        if (method != null) {
            try {
                method.invoke((Object)this, comparisonEvent);
            }
            catch (Throwable throwable) {
                ExceptionHandler.rethrow(throwable);
            }
        }
    }

    private void handleReportCreated(ComparisonEvent comparisonEvent) {
        assert (comparisonEvent.getSource() instanceof ComparisonReport);
        this.mComparisonStatus.add(ComparisonStatus.REPORT_CREATED);
        this.mReport = (ComparisonReport)((Object)comparisonEvent.getSource());
        this.registerWithParentIfChildComparison();
    }

    private void handleReportOpened(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_OPENED);
        if (this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY)) {
            this.whenSelectionReady();
        }
    }

    private void handleReportClosed(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_CLOSED);
        this.dispose();
    }

    private void handleReportClosing(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_CLOSING);
        final AtomicBoolean atomicBoolean = new AtomicBoolean(true);
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                if (ComparisonDriver.this.mComparison != null) {
                    atomicBoolean.set(ComparisonDriver.this.mComparison.canClose());
                    if (atomicBoolean.get()) {
                        ComparisonDriver.this.mComparison.close();
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                if (ComparisonDriver.this.mReport != null) {
                    if (atomicBoolean.get()) {
                        ComparisonDriver.this.mReport.approveClose();
                    } else {
                        ComparisonDriver.this.mReport.vetoCloseWithData();
                    }
                }
            }
        }.execute();
    }

    private void handleSelectionDialogCreated(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.SELECTION_DIALOG_CREATED);
        if (this.mReport != null) {
            this.mReport.showDialog();
        }
    }

    private void handleSelectionDialogDisposed(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.SELECTION_DIALOG_DISPOSED);
    }

    private void handleSelectionReady(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.SELECTION_READY);
        this.mReport.disposeDialog();
        this.whenSelectionReady();
    }

    private void handleComparisonStarted(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.COMPARISON_STARTED);
    }

    private void handleComparisonFinished(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.COMPARISON_FINISHED);
    }

    private void handleComparisonCancelled(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.COMPARISON_CANCELLED);
    }

    private void handleErrorOccurred(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.add(ComparisonStatus.ERROR_OCCURRED);
        this.removeFileChangedNotificationListeners();
    }

    private synchronized void handleNewComparison(ComparisonEvent comparisonEvent) {
        if (this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_READY) || this.mComparisonStatus.contains((Object)ComparisonStatus.SELECTION_DIALOG_DISPOSED)) {
            ComparisonUtilities.startEmptyComparison(this.mParentDesktop, this.mParentGroup);
        } else {
            this.mReport.showDialog();
        }
    }

    private void handleSwapSides(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_STARTED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_FINISHED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_CANCELLED);
        this.mCurrentSelection.swap();
        this.whenDecorationReady();
    }

    private void handleRefresh(ComparisonEvent comparisonEvent) {
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_STARTED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_FINISHED);
        this.mComparisonStatus.remove((Object)ComparisonStatus.COMPARISON_CANCELLED);
        this.mCurrentSelection.refresh();
        this.whenDecorationReady();
    }

    private void whenSelectionReady() {
        if (this.mReport == null) {
            return;
        }
        assert (this.mCurrentSelection.isSelectionReady());
        ComparisonType comparisonType = this.mCurrentSelection.getComparisonType();
        this.mComparison = comparisonType.createComparison();
        this.mComparison.setMainComparisonEventListener(this);
        this.mReport.setName(comparisonType.getDataType().getName() + "Comparison");
        this.listenToComparisonSourceChanges();
        this.performDecoration();
    }

    private void listenToComparisonSourceChanges() {
        ComparisonSource comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
        ComparisonSource comparisonSource2 = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
        if (FeatureSwitches.checkFileChangedInTheBackground()) {
            this.fLeftSourceListener = new ReportComparisonSourceListener(this.mReport, comparisonSource);
            comparisonSource.addListener(this.fLeftSourceListener);
            this.fRightSourceListener = new ReportComparisonSourceListener(this.mReport, comparisonSource2);
            comparisonSource2.addListener(this.fRightSourceListener);
        }
        if (FeatureSwitches.checkFileChangedOnActivation() && this.mParentDesktop != null) {
            this.fReportActivationListener = new ReportActivationListener(this.mReport, comparisonSource, comparisonSource2);
            this.mParentDesktop.addClientListener((Component)((Object)this.mReport), this.fReportActivationListener);
        }
    }

    private void performDecoration() {
        this.mComparisonStatus.add(ComparisonStatus.REPORT_DECORATION_STARTED);
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComparisonReportDecorator comparisonReportDecorator = ComparisonDriver.this.mComparison.getDecorator();
                ComparisonDriver.this.mReport.setCentralComponent(comparisonReportDecorator.createCentralComponent());
                ComparisonDriver.this.mReport.setToolstripConfiguration(comparisonReportDecorator.getToolstripConfiguration(ComparisonDriver.this.mReport.getToolstripConfiguration()));
                ComparisonDriver.this.mComparisonStatus.add(ComparisonStatus.REPORT_DECORATION_FINISHED);
                ComparisonDriver.this.whenDecorationReady();
            }
        });
    }

    private void whenDecorationReady() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ComparisonDriver.this.mComparison.getDecorator().disableControls();
            }
        });
        this.mCurrentSelection.prepareForComparison();
        ComparisonSource comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
        ComparisonSource comparisonSource2 = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
        this.setReportTitleFor(comparisonSource, comparisonSource2);
        this.mComparison.compareAndDisplay(comparisonSource, comparisonSource2, this.mCurrentSelection);
        this.updatePreviouslyComparedList();
    }

    private void registerWithParentIfChildComparison() {
        if (!this.mCurrentSelection.hasParameter(ChildComparisonComparisonParameter.getInstance())) {
            return;
        }
        ChildComparisonListener childComparisonListener = (ChildComparisonListener)this.mCurrentSelection.getValue(ChildComparisonComparisonParameter.getInstance());
        childComparisonListener.registerReport(this.mReport);
    }

    private void updatePreviouslyComparedList() {
        String string;
        ComparisonSource comparisonSource;
        SourceSelectionListModel sourceSelectionListModel = ComparisonTool.getInstance().getPreviouslyComparedList();
        Object object = this.mCurrentSelection.getSelection(ComparisonSelection.Index.FIRST);
        Object object2 = this.mCurrentSelection.getSelection(ComparisonSelection.Index.SECOND);
        if (object2 == null) {
            comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.SECOND);
            if (ComparisonDriver.isLocalSource(comparisonSource)) {
                string = (String)comparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
                sourceSelectionListModel.add(new File(string));
            }
        } else {
            sourceSelectionListModel.add(object2);
        }
        if (object == null) {
            comparisonSource = this.mCurrentSelection.getComparisonSource(ComparisonSelection.Index.FIRST);
            if (ComparisonDriver.isLocalSource(comparisonSource)) {
                string = (String)comparisonSource.getPropertyValue(CSPropertyAbsoluteName.getInstance(), new ComparisonSourcePropertyInfo[0]);
                sourceSelectionListModel.add(new File(string));
            }
        } else {
            sourceSelectionListModel.add(object);
        }
    }

    private static boolean isLocalSource(ComparisonSource comparisonSource) {
        return comparisonSource.hasProperty(CSPropertyReadableLocation.getInstance()) && comparisonSource.hasProperty(CSPropertyAbsoluteName.getInstance());
    }

    private void setReportTitleFor(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        String string = ComparisonSourceUtilities.getSuitableTitle(comparisonSource);
        String string2 = ComparisonSourceUtilities.getSuitableShortTitle(comparisonSource);
        String string3 = ComparisonSourceUtilities.getSuitableTitle(comparisonSource2);
        String string4 = ComparisonSourceUtilities.getSuitableShortTitle(comparisonSource2);
        if (string == null) {
            string = string3;
        }
        if (string2 == null) {
            string2 = string4;
        }
        if (string != null && string.equals(string3)) {
            string3 = null;
        }
        if (string2 != null && string2.equals(string4)) {
            string4 = null;
        }
        if (string != null && string3 != null) {
            this.mReport.setTitle(ResourceManager.format("comparisonreport.title.two", string, string3));
        } else if (string != null) {
            this.mReport.setTitle(ResourceManager.format("comparisonreport.title.one", string));
        } else {
            this.mReport.setTitle(this.mCurrentSelection.getComparisonType().getDescription());
        }
        if (string2 != null && string4 != null) {
            this.mReport.setShortTitle(ResourceManager.format("comparisonreport.title.two", string2, string4));
        } else if (string2 != null) {
            this.mReport.setShortTitle(ResourceManager.format("comparisonreport.title.one", string2));
        } else {
            String string5 = this.mCurrentSelection.getComparisonType().getDescription();
            if (string5.length() > 31) {
                string5 = string5.substring(0, 31);
            }
            this.mReport.setShortTitle(string5);
        }
    }

    private synchronized Method getEventHandlerFor(String string) {
        Method method = null;
        if (!UNKNOWN_EVENT_NAMES.contains(string)) {
            if (KNOWN_EVENT_METHODS.containsKey(string)) {
                method = KNOWN_EVENT_METHODS.get(string);
            } else {
                method = this.resolveMethod(string);
                if (method == null) {
                    UNKNOWN_EVENT_NAMES.add(string);
                } else {
                    KNOWN_EVENT_METHODS.put(string, method);
                }
            }
        }
        return method;
    }

    private Method resolveMethod(String string) {
        Method method = null;
        try {
            method = this.getClass().getDeclaredMethod("handle" + string, ComparisonEvent.class);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        return method;
    }

    private static enum ComparisonStatus {
        REPORT_CREATED,
        REPORT_OPENED,
        REPORT_CLOSED,
        REPORT_CLOSING,
        SELECTION_DIALOG_CREATED,
        SELECTION_DIALOG_DISPOSED,
        SELECTION_READY,
        REPORT_DECORATION_STARTED,
        REPORT_DECORATION_FINISHED,
        COMPARISON_STARTED,
        COMPARISON_FINISHED,
        COMPARISON_CANCELLED,
        ERROR_OCCURRED,
        DRIVER_DISPOSED;

    }
}

