/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.filter.list;

import com.mathworks.comparisons.filter.ComparisonFilterState;
import com.mathworks.comparisons.filter.MutableComparisonFilterState;
import com.mathworks.comparisons.filter.list.StringFilter;
import com.mathworks.comparisons.prefs.PreferenceAware;
import com.mathworks.comparisons.prefs.impl.ListComparisonFileNamePreferences;
import com.mathworks.comparisons.util.Restorable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ListComparisonFilterState
implements MutableComparisonFilterState<StringFilter>,
PreferenceAware {
    private static final ListComparisonFileNamePreferences PREFERENCES = new ListComparisonFileNamePreferences();
    private final Map<StringFilter, Boolean> fFilterStates = new ConcurrentHashMap<StringFilter, Boolean>();
    private final Collection<ChangeListener> fListeners = new CopyOnWriteArrayList<ChangeListener>();

    public ListComparisonFilterState() {
        this.initializeFiltersFromPreferences();
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.fListeners.add(changeListener);
    }

    @Override
    public void addFilter(StringFilter stringFilter) {
        Validate.notNull((Object)stringFilter);
        this.fFilterStates.put(stringFilter, false);
        this.notifyListeners();
    }

    @Override
    public void removeFilter(StringFilter stringFilter) {
        Validate.notNull((Object)stringFilter);
        this.fFilterStates.remove(stringFilter);
        this.notifyListeners();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ListComparisonFilterState)) {
            return false;
        }
        ComparisonFilterState comparisonFilterState = (ComparisonFilterState)object;
        return this.doFilterListsMatch(comparisonFilterState.getFilterStates());
    }

    @Override
    public Collection<StringFilter> getFilters() {
        return new ArrayList<StringFilter>(this.fFilterStates.keySet());
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.fFilterStates).toHashCode();
    }

    @Override
    public Restorable.Memento createMemento() {
        HashMap<StringFilter, Boolean> hashMap = new HashMap<StringFilter, Boolean>();
        hashMap.putAll(this.fFilterStates);
        return new ListFiltersMemento(hashMap);
    }

    @Override
    public void restoreFromMemento(Restorable.Memento memento) {
        if (!(memento instanceof ListFiltersMemento)) {
            throw new IllegalArgumentException("Memento must be instance of ListFiltersMemento.");
        }
        ListFiltersMemento listFiltersMemento = (ListFiltersMemento)memento;
        listFiltersMemento.restore(this);
    }

    @Override
    public void saveToPreferences() {
        PREFERENCES.saveFilters(this.fFilterStates);
    }

    @Override
    public Map<StringFilter, Boolean> getFilterStates() {
        return new ConcurrentHashMap<StringFilter, Boolean>(this.fFilterStates);
    }

    @Override
    public boolean isEnabled(StringFilter stringFilter) {
        Validate.notNull((Object)stringFilter);
        Validate.isTrue((boolean)this.fFilterStates.containsKey(stringFilter), (String)"Filter must be part of group");
        return this.fFilterStates.get(stringFilter);
    }

    @Override
    public void setEnabled(StringFilter stringFilter, boolean bl) {
        Validate.notNull((Object)stringFilter);
        Validate.isTrue((boolean)this.fFilterStates.containsKey(stringFilter), (String)"Filter must be part of group");
        this.fFilterStates.put(stringFilter, bl);
    }

    @Override
    public boolean isVisible(StringFilter stringFilter) {
        Validate.notNull((Object)stringFilter);
        Validate.isTrue((boolean)this.fFilterStates.containsKey(stringFilter), (String)"Filter must be part of group");
        return true;
    }

    public boolean isFilteredOut(String string) {
        for (StringFilter stringFilter : this.fFilterStates.keySet()) {
            if (!this.isEnabled(stringFilter) || !stringFilter.evaluate(string)) continue;
            return true;
        }
        return false;
    }

    private boolean doFilterListsMatch(Map<StringFilter, Boolean> map) {
        boolean bl = true;
        for (Map.Entry<StringFilter, Boolean> entry : this.fFilterStates.entrySet()) {
            StringFilter stringFilter = entry.getKey();
            if (!map.containsKey(stringFilter)) {
                bl = false;
                break;
            }
            bl = map.get(stringFilter).equals(entry.getValue());
            if (bl) continue;
            break;
        }
        return bl;
    }

    private void initializeFiltersFromPreferences() {
        Map<StringFilter, Boolean> map = PREFERENCES.getFilters();
        this.fFilterStates.clear();
        this.fFilterStates.putAll(map);
    }

    private void notifyListeners() {
        for (ChangeListener changeListener : this.fListeners) {
            changeListener.stateChanged(null);
        }
    }

    private static class ListFiltersMemento
    implements Restorable.Memento {
        private final Map<StringFilter, Boolean> fFilterStateMap = new HashMap<StringFilter, Boolean>();

        private ListFiltersMemento(Map<StringFilter, Boolean> map) {
            this.fFilterStateMap.putAll(map);
        }

        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder(17, 37);
            for (Map.Entry<StringFilter, Boolean> entry : this.fFilterStateMap.entrySet()) {
                hashCodeBuilder.append((Object)entry.getKey());
                hashCodeBuilder.append((Object)entry.getValue());
            }
            return hashCodeBuilder.toHashCode();
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof ListFiltersMemento)) {
                return false;
            }
            ListFiltersMemento listFiltersMemento = (ListFiltersMemento)object;
            Map<StringFilter, Boolean> map = listFiltersMemento.fFilterStateMap;
            if (this.fFilterStateMap.size() != map.size()) {
                return false;
            }
            for (Map.Entry<StringFilter, Boolean> entry : this.fFilterStateMap.entrySet()) {
                StringFilter stringFilter = entry.getKey();
                Boolean bl = entry.getValue();
                if (!map.containsKey(stringFilter)) {
                    return false;
                }
                if (map.get(stringFilter).equals(bl)) continue;
                return false;
            }
            return true;
        }

        private void restore(ListComparisonFilterState listComparisonFilterState) {
            listComparisonFilterState.fFilterStates.clear();
            listComparisonFilterState.fFilterStates.putAll(this.fFilterStateMap);
        }
    }
}

