/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.filter.list;

import com.mathworks.comparisons.filter.Filter;
import com.mathworks.comparisons.filter.list.StringFilter;
import com.mathworks.comparisons.util.ResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FileNameFilter
implements StringFilter {
    private static final Collection<String> INVALID_CHARACTERS = new ArrayList<String>();
    private final boolean fIsCaseSensitive = new File("A").equals(new File("a"));
    private final String fStringToFilter;
    private final UUID fID = UUID.randomUUID();

    public FileNameFilter(String string) {
        Validate.notNull((Object)string);
        if (!FileNameFilter.isFilterValid(string)) {
            throw new IllegalArgumentException(ResourceManager.format("exception.illegalfilter", string));
        }
        this.fStringToFilter = string;
    }

    public boolean evaluate(Object object) {
        Validate.notNull((Object)object);
        Validate.isTrue((boolean)(object instanceof String));
        return Pattern.matches(this.createRegularExpression(this.fStringToFilter), (CharSequence)object);
    }

    @Override
    public String getID() {
        return this.fID.toString();
    }

    @Override
    public String getName() {
        return this.fStringToFilter;
    }

    @Override
    public int compareTo(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.fStringToFilter;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof FileNameFilter)) {
            return false;
        }
        Filter filter = (Filter)object;
        return this.getID().equals(filter.getID());
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getID()).toHashCode();
    }

    private static boolean isFilterValid(String string) {
        for (String string2 : INVALID_CHARACTERS) {
            if (!string.contains(string2)) continue;
            return false;
        }
        return true;
    }

    private String createRegularExpression(String string) {
        String string2 = string;
        string2 = string2.replace("\\", "\\\\");
        string2 = string2.replace("/", "\\/");
        string2 = string2.replace(".", "\\.");
        string2 = string2.replace("*", "[^\\/]*");
        string2 = "(.*\\/)*" + string2;
        if (string2.endsWith("/")) {
            string2 = string2 + "(.*)";
        }
        if (this.fIsCaseSensitive) {
            string2 = "(?i)" + string2;
        }
        return string2;
    }

    static {
        INVALID_CHARACTERS.add(";");
        INVALID_CHARACTERS.add("|");
        INVALID_CHARACTERS.add("\"");
    }
}

