/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.variable;

import com.mathworks.comparisons.decorator.variable.ValueInfo;
import com.mathworks.comparisons.decorator.variable.VariableDifferenceType;

public class VariableDifferences {
    private VariableDifferenceType fType;
    private String fName1;
    private String fName2;
    private String fAccessFcn1;
    private String fAccessFcn2;
    private String fSubsref1;
    private String fSubsref2;
    private ValueInfo fValueInfo1;
    private ValueInfo fValueInfo2;
    private double[][] fNumeric1;
    private double[][] fNumeric2;
    private ValueInfo[][] fNonNumeric1;
    private ValueInfo[][] fNonNumeric2;
    private boolean[][] fDiffs;
    private FieldEntry[] fFields;
    private String fLabel1;
    private String fLabel2;
    private static ValueInfo[][] sEmptyNonNumeric = new ValueInfo[0][0];
    private static double[][] sEmptyNumeric = new double[0][0];

    private VariableDifferences(VariableDifferenceType variableDifferenceType) {
        this.fType = variableDifferenceType;
    }

    public String getName1() {
        return this.fName1;
    }

    public String getName2() {
        return this.fName2;
    }

    public String getAccessFcn1() {
        return this.fAccessFcn1;
    }

    public String getAccessFcn2() {
        return this.fAccessFcn2;
    }

    public String getSubsref1() {
        return this.fSubsref1 == null ? "" : this.fSubsref1;
    }

    public String getSubsref2() {
        return this.fSubsref2 == null ? "" : this.fSubsref2;
    }

    public ValueInfo getValueSummary1() {
        return this.fValueInfo1;
    }

    public ValueInfo getValueSummary2() {
        return this.fValueInfo2;
    }

    public VariableDifferenceType getType() {
        return this.fType;
    }

    public double[][] getNumeric1() {
        return this.fNumeric1 == null ? sEmptyNumeric : this.fNumeric1;
    }

    public double[][] getNumeric2() {
        return this.fNumeric2 == null ? sEmptyNumeric : this.fNumeric2;
    }

    public ValueInfo[][] getNonNumeric1() {
        return this.fNonNumeric1 == null ? sEmptyNonNumeric : this.fNonNumeric1;
    }

    public ValueInfo[][] getNonNumeric2() {
        return this.fNonNumeric2 == null ? sEmptyNonNumeric : this.fNonNumeric2;
    }

    public boolean[][] getDiffs() {
        return this.fDiffs;
    }

    public FieldEntry[] getFields() {
        return this.fFields;
    }

    public String getString1() {
        return this.fLabel1;
    }

    public String getString2() {
        return this.fLabel2;
    }

    public void setName1(String string) {
        this.fName1 = string;
    }

    public void setName2(String string) {
        this.fName2 = string;
    }

    public void setSubsref1(String string) {
        this.fSubsref1 = string;
    }

    public void setSubsref2(String string) {
        this.fSubsref2 = string;
    }

    public void setAccessFcn1(String string) {
        this.fAccessFcn1 = string;
    }

    public void setAccessFcn2(String string) {
        this.fAccessFcn2 = string;
    }

    public void setValueSummary1(ValueInfo valueInfo) {
        this.fValueInfo1 = valueInfo;
    }

    public void setValueSummary2(ValueInfo valueInfo) {
        this.fValueInfo2 = valueInfo;
    }

    public static VariableDifferences createNumericDiffs(double[][] dArray, double[][] dArray2) {
        VariableDifferences variableDifferences = new VariableDifferences(VariableDifferenceType.NUMERIC_ARRAYS);
        variableDifferences.fNumeric1 = dArray;
        variableDifferences.fNumeric2 = dArray2;
        return variableDifferences;
    }

    public static VariableDifferences createLogicalDiffs(double[][] dArray, double[][] dArray2) {
        VariableDifferences variableDifferences = new VariableDifferences(VariableDifferenceType.LOGICAL_ARRAYS);
        variableDifferences.fNumeric1 = dArray;
        variableDifferences.fNumeric2 = dArray2;
        return variableDifferences;
    }

    public static VariableDifferences createNonNumericDiffs(ValueInfo[][] valueInfoArray, ValueInfo[][] valueInfoArray2, boolean[][] blArray) {
        VariableDifferences variableDifferences = new VariableDifferences(VariableDifferenceType.NON_NUMERIC_ARRAYS);
        variableDifferences.fNonNumeric1 = valueInfoArray;
        variableDifferences.fNonNumeric2 = valueInfoArray2;
        variableDifferences.fDiffs = blArray;
        return variableDifferences;
    }

    public static VariableDifferences createComplexNumericDiffs(ValueInfo[][] valueInfoArray, ValueInfo[][] valueInfoArray2, boolean[][] blArray) {
        VariableDifferences variableDifferences = new VariableDifferences(VariableDifferenceType.COMPLEX_NUMERIC_ARRAYS);
        variableDifferences.fNonNumeric1 = valueInfoArray;
        variableDifferences.fNonNumeric2 = valueInfoArray2;
        variableDifferences.fDiffs = blArray;
        return variableDifferences;
    }

    private static VariableDifferences createFieldDiffs(VariableDifferenceType variableDifferenceType, String[] stringArray, ValueInfo[] valueInfoArray, ValueInfo[] valueInfoArray2, boolean[] blArray) {
        VariableDifferences variableDifferences = new VariableDifferences(variableDifferenceType);
        int n = stringArray != null ? stringArray.length : 0;
        FieldEntry[] fieldEntryArray = new FieldEntry[n];
        for (int i = 0; i < n; ++i) {
            fieldEntryArray[i] = new FieldEntry(stringArray[i], valueInfoArray[i], valueInfoArray2[i], blArray[i]);
        }
        variableDifferences.fFields = fieldEntryArray;
        return variableDifferences;
    }

    public static VariableDifferences createStructDiffs(String[] stringArray, ValueInfo[] valueInfoArray, ValueInfo[] valueInfoArray2, boolean[] blArray) {
        return VariableDifferences.createFieldDiffs(VariableDifferenceType.STRUCTS, stringArray, valueInfoArray, valueInfoArray2, blArray);
    }

    public static VariableDifferences createObjectDiffs(String[] stringArray, ValueInfo[] valueInfoArray, ValueInfo[] valueInfoArray2, boolean[] blArray) {
        return VariableDifferences.createFieldDiffs(VariableDifferenceType.OBJECTS, stringArray, valueInfoArray, valueInfoArray2, blArray);
    }

    public static VariableDifferences createStringDiffs(String string, String string2) {
        VariableDifferences variableDifferences = new VariableDifferences(VariableDifferenceType.STRINGS);
        variableDifferences.fLabel1 = string;
        variableDifferences.fLabel2 = string2;
        return variableDifferences;
    }

    public static VariableDifferences createUnrelatedDiffs() {
        VariableDifferences variableDifferences = new VariableDifferences(VariableDifferenceType.UNRELATED_TYPES);
        return variableDifferences;
    }

    public static class FieldEntry {
        private String fName;
        private ValueInfo fSummary1;
        private ValueInfo fSummary2;
        private boolean fDiff;

        FieldEntry(String string, ValueInfo valueInfo, ValueInfo valueInfo2, boolean bl) {
            this.fName = string;
            this.fSummary1 = valueInfo;
            this.fSummary2 = valueInfo2;
            this.fDiff = bl;
        }

        public String getName() {
            return this.fName;
        }

        public String getSummary1() {
            if (this.fSummary1.getMatlabClass().isEmpty()) {
                return null;
            }
            return this.fSummary1.toString();
        }

        public String getSummary2() {
            if (this.fSummary2.getMatlabClass().isEmpty()) {
                return null;
            }
            return this.fSummary2.toString();
        }

        public String getClass1() {
            return this.fSummary1.getMatlabClass();
        }

        public String getClass2() {
            return this.fSummary2.getMatlabClass();
        }

        public boolean getDiff() {
            return this.fDiff;
        }
    }
}

