/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport.toolstrip;

import com.mathworks.comparisons.decorator.actionid.ActionIDFind;
import com.mathworks.comparisons.decorator.actionid.ActionIDHelp;
import com.mathworks.comparisons.decorator.actionid.ActionIDPrint;
import com.mathworks.comparisons.decorator.actionid.ActionIDRefresh;
import com.mathworks.comparisons.decorator.actionid.ActionIDSaveAs;
import com.mathworks.comparisons.decorator.actionid.ActionIDSwapSides;
import com.mathworks.comparisons.report.ActionManager;
import com.mathworks.comparisons.report.toolstrip.ComparisonTabConfigurationFactory;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ComparisonToolstripUtils;
import com.mathworks.comparisons.report.toolstrip.DefaultFindToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultHelpToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultNavigateToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultPrintToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultRefreshToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.DefaultSaveAsToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.TSTabConfigurationFactory;
import com.mathworks.comparisons.report.toolstrip.ToolSetFactory;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfiguration;
import com.mathworks.comparisons.report.toolstrip.ToolstripTabConfigurationFactory;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.toolstrip.factory.TSTabConfiguration;
import com.mathworks.toolstrip.factory.TSToolSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class HtmlComparisonTabConfigurationFactory
implements ToolstripTabConfigurationFactory {
    private final List<ToolSetFactory> fToolSetFactories = new ArrayList<ToolSetFactory>();
    private final ActionManager fActionManager;
    private final ToolstripTabConfiguration fTabConfiguration;

    public HtmlComparisonTabConfigurationFactory(ToolstripTabConfiguration toolstripTabConfiguration, ActionManager actionManager) {
        this.fTabConfiguration = toolstripTabConfiguration;
        this.fActionManager = actionManager;
        this.fToolSetFactories.addAll(toolstripTabConfiguration.getToolSetFactories());
        this.configureFileSection();
        this.configureComparisonSection();
        this.configureNavigateSection();
        this.configureHelpSection();
    }

    @Override
    public ToolstripTabConfiguration createConfiguration() {
        return new ComparisonToolstripTabConfiguration(this.fTabConfiguration.getTabName(), new TSTabConfigurationFactory(){

            @Override
            public TSTabConfiguration createConfiguration() {
                return ComparisonToolstripUtils.readTabConfiguration(ComparisonTabConfigurationFactory.class, "ComparisonTab.xml");
            }
        }, this.fToolSetFactories);
    }

    private void configureComparisonSection() {
        final TSToolSet tSToolSet = new DefaultRefreshToolSetFactory().createToolSet();
        tSToolSet.configureAndAdd("refresh", (Action)new ChildAction(this.fActionManager.getAction(ActionIDRefresh.getInstance().getName())));
        tSToolSet.configureAndAdd("swap_sides", (Action)new ChildAction(this.fActionManager.getAction(ActionIDSwapSides.getInstance().getName())));
        this.fToolSetFactories.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void configureHelpSection() {
        final TSToolSet tSToolSet = new DefaultHelpToolSetFactory().createToolSet();
        tSToolSet.configureAndAdd("help", (Action)new ChildAction(this.fActionManager.getAction(ActionIDHelp.getInstance().getName())));
        this.fToolSetFactories.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
    }

    private void configureFileSection() {
        final TSToolSet tSToolSet = new DefaultSaveAsToolSetFactory().createToolSet();
        tSToolSet.configureAndAdd("save_to_html", (Action)new ChildAction(this.fActionManager.getAction(ActionIDSaveAs.getInstance().getName())));
        this.fToolSetFactories.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
        final TSToolSet tSToolSet2 = new DefaultPrintToolSetFactory().createToolSet();
        tSToolSet2.configureAndAdd("print", (Action)new ChildAction(this.fActionManager.getAction(ActionIDPrint.getInstance().getName())));
        this.fToolSetFactories.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet2;
            }
        });
    }

    private void configureNavigateSection() {
        final TSToolSet tSToolSet = new DefaultFindToolSetFactory().createToolSet();
        ChildAction childAction = new ChildAction(this.fActionManager.getAction(ActionIDFind.getInstance().getName()));
        tSToolSet.configureAndAdd("find", (Action)new ChildAction((Action)childAction));
        tSToolSet.configureAndAdd("default_find", (Action)new ChildAction((Action)childAction));
        this.fToolSetFactories.add(new ToolSetFactory(){

            @Override
            public TSToolSet createToolSet() {
                return tSToolSet;
            }
        });
        this.fToolSetFactories.add(new DefaultNavigateToolSetFactory());
    }
}

