/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.decorator.htmlreport;

import com.mathworks.comparisons.decorator.PopupMenuProvider;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHTMLRenderer;
import com.mathworks.html.ContextMenuTargetData;
import com.mathworks.html.HtmlActions;
import com.mathworks.html.HtmlCallbackProvider;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlComponentWrapper;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.HtmlDataListener;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentAdapter;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JPopupMenu;

public class ComparisonHtmlComponent
extends HtmlComponentWrapper<HtmlComponent> {
    private static final AtomicBoolean USE_JX_BROWSER = new AtomicBoolean(true);

    public ComparisonHtmlComponent() {
        super(ComparisonHtmlComponent.createHtmlComponent());
    }

    public static void useJxBrowser(boolean bl) {
        USE_JX_BROWSER.set(bl);
    }

    public HtmlComponent getHtmlComponent() {
        return this.getWrappedComponent();
    }

    public String executeScriptWithReturn(String string) {
        return this.executeScriptWithReturn(string, Integer.MAX_VALUE);
    }

    public String executeScriptWithReturn(String string, int n) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        this.executeScript(string, (HtmlDataListener)new HtmlDataListener<String>(){

            public void dataRetrieved(String string) {
                atomicReference.set(string);
                countDownLatch.countDown();
            }
        });
        try {
            countDownLatch.await(n, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            throw new IllegalStateException(interruptedException);
        }
        return atomicReference.get();
    }

    public void setPopupMenuProvider(final PopupMenuProvider popupMenuProvider) {
        if (popupMenuProvider != null) {
            HtmlConversionUtils.visitBrowser((HtmlComponent)this.getHtmlComponent(), (HtmlConversionUtils.BrowserVisitor)new HtmlConversionUtils.BrowserVisitor(){

                public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
                    mJHtmlPanel.setHtmlContextMenuBuilder(new HtmlContextMenuBuilder(){

                        public JPopupMenu buildContextMenu(HtmlActions htmlActions, ContextMenuTargetData contextMenuTargetData) {
                            return popupMenuProvider.createPopupMenu();
                        }
                    });
                }

                public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
                    if (hTMLRenderer instanceof ComparisonHTMLRenderer) {
                        ((ComparisonHTMLRenderer)hTMLRenderer).setPopupMenuProvider(popupMenuProvider);
                    }
                }
            });
        }
    }

    public void showHtmlFragment(String string, String string2) {
        ComparisonHtmlComponent.showHtmlFragment((HtmlCallbackProvider)this.getHtmlComponent(), string, string2);
    }

    public static void showHtmlFragment(HtmlCallbackProvider htmlCallbackProvider, String string, String string2) {
        String string3 = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + Charset.forName("UTF-8").toString() + "\"/>\n" + "<title>" + string2 + "</title></head>\n" + "<body>" + string + "</body></html>";
        htmlCallbackProvider.setHtmlText(string3);
    }

    private static HtmlComponent createHtmlComponent() {
        if (USE_JX_BROWSER.get()) {
            return HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER});
        }
        return new HtmlComponentAdapter((HTMLRenderer)new ComparisonHTMLRenderer());
    }
}

