/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.compare.impl;

import com.mathworks.comparisons.compare.impl.CompareInMatlab;
import com.mathworks.comparisons.decorator.ComparisonReportDecorator;
import com.mathworks.comparisons.decorator.htmlreport.ComparisonHtmlComponent;
import com.mathworks.comparisons.decorator.htmlreport.HTMLReportDecorator;
import com.mathworks.comparisons.event.ComparisonEvent;
import com.mathworks.comparisons.event.data.CEventDataErrorOccurred;
import com.mathworks.comparisons.result.ComparisonResult;
import com.mathworks.comparisons.result.impl.ComparisonResultString;
import com.mathworks.comparisons.util.HTMLUtils;
import com.mathworks.comparisons.util.LocalIOUtils;
import com.mathworks.comparisons.util.ResourceManager;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;

public abstract class CompareInMatlabGenerateHTML
extends CompareInMatlab<String> {
    private static final String COMPARISON_REPORT_PREFIX = "matlab_comparison_report_";
    private static final String COMPARISON_REPORT_SUFFIX = ".html";
    private HTMLReportDecorator fHTMLReportDecorator = null;
    private final Collection<File> fTempFiles = new CopyOnWriteArrayList<File>();
    private PageChangedListener fPageChangedListener = null;

    protected CompareInMatlabGenerateHTML(String string, int n) {
        this(string, string, n, n);
    }

    protected CompareInMatlabGenerateHTML(String string, String string2, int n, int n2) {
        super(string, string2, n, n2);
    }

    @Override
    public ComparisonReportDecorator getDecorator() {
        if (this.fHTMLReportDecorator == null) {
            this.fHTMLReportDecorator = this.createDefaultDecorator();
        }
        return this.fHTMLReportDecorator;
    }

    @Override
    public void overrideDefaultDecorator(ComparisonReportDecorator comparisonReportDecorator) {
        assert (comparisonReportDecorator instanceof HTMLReportDecorator) : "Decorator should be HTMLReportDecorator implementation";
        if (this.fHTMLReportDecorator != null) {
            this.dispose();
        }
        this.fHTMLReportDecorator = (HTMLReportDecorator)comparisonReportDecorator;
    }

    @Override
    public void dispose() {
        if (this.fHTMLReportDecorator != null) {
            this.fHTMLReportDecorator.dispose();
            this.fHTMLReportDecorator = null;
        }
        this.deleteExistingTempFiles();
    }

    @Override
    protected ComparisonResult<String> convertToComparisonResult(Object object) {
        assert (object instanceof String);
        ComparisonResultString comparisonResultString = new ComparisonResultString();
        comparisonResultString.addResultData((String)object);
        return comparisonResultString;
    }

    @Override
    protected void displayComparisonResult(Object object) throws Exception {
        assert (object instanceof String);
        if (this.fHTMLReportDecorator == null) {
            return;
        }
        String string = (String)object;
        ComparisonHtmlComponent comparisonHtmlComponent = this.fHTMLReportDecorator.getHTMLRenderer();
        if (comparisonHtmlComponent == null) {
            return;
        }
        if (string.isEmpty()) {
            comparisonHtmlComponent.setHtmlText("");
        } else {
            File file = LocalIOUtils.createTempFile(COMPARISON_REPORT_PREFIX, COMPARISON_REPORT_SUFFIX);
            CompareInMatlabGenerateHTML.writeContentsToFile(file, string);
            this.fTempFiles.add(file);
            if (this.fPageChangedListener != null) {
                comparisonHtmlComponent.removePageChangedListener(this.fPageChangedListener);
            }
            this.fPageChangedListener = new PageChangedListener(){

                public void pageChanged(PageChangedEvent pageChangedEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (CompareInMatlabGenerateHTML.this.fHTMLReportDecorator != null) {
                                CompareInMatlabGenerateHTML.this.fHTMLReportDecorator.enableControls();
                            }
                        }
                    });
                }
            };
            comparisonHtmlComponent.addPageChangedListener(this.fPageChangedListener);
            comparisonHtmlComponent.setCurrentLocation(file.toURI().toString());
        }
    }

    @Override
    protected void handle(Exception exception, boolean bl) {
        if (this.fHTMLReportDecorator != null) {
            int n;
            String string = exception.getMessage();
            if (bl && (n = string.indexOf("at com.mathworks.")) > 0) {
                string = string.substring(0, n);
            }
            string = StringEscapeUtils.escapeHtml((String)string);
            string = string.replace("\n", "<br/>");
            String string2 = StringEscapeUtils.escapeHtml((String)ResourceManager.getString("exception.comparisonfailed"));
            final String string3 = HTMLUtils.wrapInHTML(string2, string);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CompareInMatlabGenerateHTML.this.fHTMLReportDecorator.reportError(string3);
                    CompareInMatlabGenerateHTML.this.getEventSupport().fireComparisonEvent(new ComparisonEvent(this, CEventDataErrorOccurred.getInstance()));
                }
            });
        } else {
            exception.printStackTrace();
        }
    }

    protected abstract HTMLReportDecorator createDefaultDecorator();

    private void deleteExistingTempFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : this.fTempFiles) {
            file.delete();
            arrayList.add(file);
        }
        this.fTempFiles.removeAll(arrayList);
    }

    private static void writeContentsToFile(File file, String string) throws IOException {
        boolean bl = false;
        int n = 100000;
        int n2 = 0;
        int n3 = string.length();
        while (!bl) {
            String string2 = string.substring(n2, Math.min(n2 + n, n3));
            try {
                FileUtils.writeStringToFile((File)file, (String)string2, (Charset)Charset.forName("UTF-8"), (boolean)true);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new IOException(outOfMemoryError);
            }
            if ((n2 += n) < n3) continue;
            bl = true;
        }
    }
}

