/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.collection.impl;

import com.mathworks.comparisons.collection.ComparisonCollection;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.util.Disposable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.Validate;

public abstract class ComparisonCollectionImpl
implements ComparisonCollection,
Disposable {
    private final String fName;
    private final String fType;
    private final SortedSet<ComparisonSource> fContents;

    protected ComparisonCollectionImpl(String string, String string2, Comparator<ComparisonSource> comparator) {
        Validate.notNull((Object)string);
        Validate.notNull((Object)string2);
        Validate.notNull(comparator);
        this.fName = string;
        this.fType = string2;
        this.fContents = Collections.synchronizedSortedSet(new TreeSet<ComparisonSource>(comparator));
    }

    @Override
    public Collection<ComparisonSource> getComparisonSources() {
        return Collections.synchronizedSortedSet(new TreeSet<ComparisonSource>(this.fContents));
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public String getType() {
        return this.fType;
    }

    public void dispose() {
    }

    protected void addSource(ComparisonSource comparisonSource) {
        this.fContents.add(comparisonSource);
    }
}

