/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom4j;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom4j.DocumentWrapper;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SiblingCountingNode;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.Entity;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class NodeWrapper
implements NodeInfo,
VirtualNode,
SiblingCountingNode {
    protected Object node;
    protected short nodeKind;
    private NodeWrapper parent;
    protected DocumentWrapper docWrapper;
    protected int index;

    protected NodeWrapper(Object node, NodeWrapper parent, int index) {
        this.node = node;
        this.parent = parent;
        this.index = index;
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper) {
        return this.makeWrapper(node, docWrapper, null, -1);
    }

    protected NodeWrapper makeWrapper(Object node, DocumentWrapper docWrapper, NodeWrapper parent, int index) {
        NodeWrapper wrapper;
        if (node instanceof Document) {
            return docWrapper;
        }
        if (node instanceof Element) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = 1;
        } else if (node instanceof Attribute) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)2;
        } else if (node instanceof String || node instanceof Text || node instanceof CDATA) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)3;
        } else if (node instanceof Comment) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)8;
        } else if (node instanceof ProcessingInstruction) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)7;
        } else if (node instanceof Namespace) {
            wrapper = new NodeWrapper(node, parent, index);
            wrapper.nodeKind = (short)13;
        } else {
            throw new IllegalArgumentException("Bad node type in dom4j! " + node.getClass() + " instance " + node.toString());
        }
        wrapper.docWrapper = docWrapper;
        return wrapper;
    }

    public Object getUnderlyingNode() {
        return this.node;
    }

    public NamePool getNamePool() {
        return this.docWrapper.getNamePool();
    }

    public int getNodeKind() {
        return this.nodeKind;
    }

    public SequenceIterator getTypedValue() {
        return SingletonIterator.makeIterator((Item)((AtomicValue)this.atomize()));
    }

    public Value atomize() {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.getStringValueCS());
            }
        }
        return new UntypedAtomicValue(this.getStringValueCS());
    }

    public int getTypeAnnotation() {
        if (this.getNodeKind() == 2) {
            return 631;
        }
        return 630;
    }

    public boolean isSameNode(NodeInfo other) {
        if (!(other instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper ow = (NodeWrapper)other;
        return this.node.equals(ow.node);
    }

    public String getSystemId() {
        return this.docWrapper.baseURI;
    }

    public void setSystemId(String uri) {
        this.docWrapper.baseURI = uri;
    }

    public String getBaseURI() {
        if (this.getNodeKind() == 13) {
            return null;
        }
        NodeWrapper n = this;
        if (this.getNodeKind() != 1) {
            n = n.getParent();
        }
        while (n != null) {
            String xmlbase = n.getAttributeValue(385);
            if (xmlbase != null) {
                return xmlbase;
            }
            n = n.getParent();
        }
        return this.docWrapper.baseURI;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo other) {
        return Navigator.compareOrder((SiblingCountingNode)this, (SiblingCountingNode)((SiblingCountingNode)other));
    }

    public String getStringValue() {
        return NodeWrapper.getStringValue(this.node);
    }

    public CharSequence getStringValueCS() {
        return NodeWrapper.getStringValue(this.node);
    }

    private static String getStringValue(Object node) {
        if (node instanceof Document) {
            return ((Document)node).getStringValue();
        }
        if (node instanceof Element) {
            return ((Element)node).getStringValue();
        }
        if (node instanceof Attribute) {
            return ((Attribute)node).getValue();
        }
        if (node instanceof Text) {
            return ((Text)node).getText();
        }
        if (node instanceof CDATA) {
            return ((CDATA)node).getText();
        }
        if (node instanceof String) {
            return (String)node;
        }
        if (node instanceof Comment) {
            return ((Comment)node).getText();
        }
        if (node instanceof ProcessingInstruction) {
            return ((ProcessingInstruction)node).getStringValue();
        }
        if (node instanceof Namespace) {
            return ((Namespace)node).getURI();
        }
        return "";
    }

    public int getNameCode() {
        switch (this.nodeKind) {
            case 1: 
            case 2: 
            case 7: 
            case 13: {
                return this.docWrapper.getNamePool().allocate(this.getPrefix(), this.getURI(), this.getLocalPart());
            }
        }
        return -1;
    }

    public int getFingerprint() {
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getName();
            }
            case 2: {
                return ((Attribute)this.node).getName();
            }
            case 3: 
            case 8: 
            case 9: {
                return "";
            }
            case 7: {
                return ((ProcessingInstruction)this.node).getTarget();
            }
            case 13: {
                return ((Namespace)this.node).getPrefix();
            }
        }
        return null;
    }

    public String getPrefix() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespacePrefix();
            }
            case 2: {
                return ((Attribute)this.node).getNamespacePrefix();
            }
        }
        return "";
    }

    public String getURI() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getNamespaceURI();
            }
            case 2: {
                return ((Attribute)this.node).getNamespaceURI();
            }
        }
        return "";
    }

    public String getDisplayName() {
        switch (this.nodeKind) {
            case 1: {
                return ((Element)this.node).getQualifiedName();
            }
            case 2: {
                return ((Attribute)this.node).getQualifiedName();
            }
            case 7: 
            case 13: {
                return this.getLocalPart();
            }
        }
        return "";
    }

    public NodeInfo getParent() {
        if (this.parent == null) {
            if (this.node instanceof Element) {
                this.parent = ((Element)this.node).isRootElement() ? this.makeWrapper(((Element)this.node).getDocument(), this.docWrapper) : this.makeWrapper(((Element)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Text) {
                this.parent = this.makeWrapper(((Text)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof CDATA) {
                this.parent = this.makeWrapper(((CDATA)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Comment) {
                this.parent = this.makeWrapper(((Comment)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof ProcessingInstruction) {
                this.parent = this.makeWrapper(((ProcessingInstruction)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Attribute) {
                this.parent = this.makeWrapper(((Attribute)this.node).getParent(), this.docWrapper);
            } else if (this.node instanceof Document) {
                this.parent = null;
            } else {
                if (this.node instanceof Namespace) {
                    throw new UnsupportedOperationException("Cannot find parent of DOM4J namespace node");
                }
                throw new IllegalStateException("Unknown DOM4J node type " + this.node.getClass());
            }
        }
        return this.parent;
    }

    public int getSiblingPosition() {
        if (this.index == -1) {
            NodeInfo n;
            AxisIterator iter;
            int ix = 0;
            this.getParent();
            switch (this.nodeKind) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    NodeWrapper parent = (NodeWrapper)this.getParent();
                    List children = parent.getNodeKind() == 9 ? ((Document)parent.node).content() : ((Element)parent.node).content();
                    ListIterator iterator = children.listIterator();
                    while (iterator.hasNext()) {
                        Object n2 = iterator.next();
                        if (n2 == this.node) {
                            this.index = ix;
                            return this.index;
                        }
                        ++ix;
                    }
                    throw new IllegalStateException("DOM4J node not linked to parent node");
                }
                case 2: {
                    iter = this.parent.iterateAxis((byte)2);
                    break;
                }
                case 13: {
                    iter = this.parent.iterateAxis((byte)8);
                    break;
                }
                default: {
                    this.index = 0;
                    return this.index;
                }
            }
            while ((n = (NodeInfo)iter.next()) != null) {
                if (n.isSameNodeInfo((NodeInfo)this)) {
                    this.index = ix;
                    return this.index;
                }
                ++ix;
            }
            throw new IllegalStateException("DOM4J node not linked to parent node");
        }
        return this.index;
    }

    public AxisIterator iterateAxis(byte axisNumber) {
        return this.iterateAxis(axisNumber, (NodeTest)AnyNodeTest.getInstance());
    }

    public AxisIterator iterateAxis(byte axisNumber, NodeTest nodeTest) {
        switch (axisNumber) {
            case 0: {
                if (this.nodeKind == 9) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 1: {
                if (this.nodeKind == 9) {
                    return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
                }
                return new Navigator.AxisFilter((AxisIterator)new Navigator.AncestorEnumeration((NodeInfo)this, true), nodeTest);
            }
            case 2: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new AttributeEnumeration(this), nodeTest);
            }
            case 3: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, true, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 4: {
                if (this.hasChildNodes()) {
                    return new Navigator.AxisFilter((AxisIterator)new Navigator.DescendantEnumeration((NodeInfo)this, false, true), nodeTest);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.DescendantEnumeration((NodeInfo)this, true, true), nodeTest);
            }
            case 6: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.FollowingEnumeration((NodeInfo)this), nodeTest);
            }
            case 7: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, false, true), nodeTest);
            }
            case 8: {
                if (this.nodeKind != 1) {
                    return EmptyIterator.getInstance();
                }
                return new Navigator.AxisFilter((AxisIterator)new NamespaceEnumeration(this), nodeTest);
            }
            case 9: {
                this.getParent();
                return Navigator.filteredSingleton((NodeInfo)this.parent, (NodeTest)nodeTest);
            }
            case 10: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, false), nodeTest);
            }
            case 11: {
                switch (this.nodeKind) {
                    case 2: 
                    case 9: 
                    case 13: {
                        return EmptyIterator.getInstance();
                    }
                }
                return new Navigator.AxisFilter((AxisIterator)new ChildEnumeration(this, false, false), nodeTest);
            }
            case 12: {
                return Navigator.filteredSingleton((NodeInfo)this, (NodeTest)nodeTest);
            }
            case 13: {
                return new Navigator.AxisFilter((AxisIterator)new Navigator.PrecedingEnumeration((NodeInfo)this, true), nodeTest);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + axisNumber);
    }

    public String getAttributeValue(int fingerprint) {
        if (this.nodeKind == 1) {
            Iterator list = ((Element)this.node).attributes().iterator();
            NamePool pool = this.docWrapper.getNamePool();
            while (list.hasNext()) {
                Attribute att = (Attribute)list.next();
                int nameCode = pool.allocate(att.getNamespacePrefix(), att.getNamespaceURI(), att.getName());
                if (fingerprint != (nameCode & 0xFFFFF)) continue;
                return att.getValue();
            }
        }
        return null;
    }

    public NodeInfo getRoot() {
        return this.docWrapper;
    }

    public DocumentInfo getDocumentRoot() {
        return this.docWrapper;
    }

    public boolean hasChildNodes() {
        switch (this.nodeKind) {
            case 9: {
                return true;
            }
            case 1: {
                List content = ((Element)this.node).content();
                for (int i = 0; i < content.size(); ++i) {
                    if (content.get(i) instanceof Namespace) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public void generateId(FastStringBuffer buffer) {
        Navigator.appendSequentialKey((SiblingCountingNode)this, (FastStringBuffer)buffer, (boolean)true);
    }

    public int getDocumentNumber() {
        return this.getParent().getDocumentNumber();
    }

    public void copy(Receiver out, int whichNamespaces, boolean copyAnnotations, int locationId) throws XPathException {
        Navigator.copy((NodeInfo)this, (Receiver)out, (NamePool)this.docWrapper.getNamePool(), (int)whichNamespaces, (boolean)copyAnnotations, (int)locationId);
    }

    public void outputNamespaceNodes(Receiver out, boolean includeAncestors) throws XPathException {
        if (this.nodeKind == 1) {
            NodeWrapper wrapper;
            NamePool pool = this.docWrapper.getNamePool();
            AxisIterator enm = this.iterateAxis((byte)8);
            while ((wrapper = (NodeWrapper)enm.next()) != null && (includeAncestors || wrapper.getParent().isSameNodeInfo((NodeInfo)this))) {
                Namespace ns = (Namespace)wrapper.node;
                int nscode = pool.allocateNamespaceCode(ns.getPrefix(), ns.getURI());
                out.namespace(nscode, 0);
            }
        }
    }

    public boolean isSameNodeInfo(NodeInfo other) {
        if (!(other instanceof NodeWrapper)) {
            return false;
        }
        NodeWrapper ow = (NodeWrapper)other;
        if (this.node instanceof Namespace) {
            return this.getLocalPart().equals(ow.getLocalPart()) && this.getParent().isSameNodeInfo(ow.getParent());
        }
        return this.node.equals(ow.node);
    }

    public Configuration getConfiguration() {
        return this.docWrapper.getConfiguration();
    }

    public int[] getDeclaredNamespaces(int[] buffer) {
        if (this.node instanceof Element) {
            Element elem = (Element)this.node;
            List namespaces = elem.declaredNamespaces();
            if (namespaces == null || namespaces.isEmpty()) {
                return EMPTY_NAMESPACE_LIST;
            }
            int count = namespaces.size();
            if (count == 0) {
                return EMPTY_NAMESPACE_LIST;
            }
            int[] result = buffer == null || count > buffer.length ? new int[count] : buffer;
            NamePool pool = this.getNamePool();
            int n = 0;
            Iterator i = namespaces.iterator();
            while (i.hasNext()) {
                Namespace namespace = (Namespace)i.next();
                String prefix = namespace.getPrefix();
                String uri = namespace.getURI();
                result[n++] = pool.allocateNamespaceCode(prefix, uri);
            }
            if (count < result.length) {
                result[count] = -1;
            }
            return result;
        }
        return null;
    }

    private final class ChildEnumeration
    extends Navigator.BaseEnumeration {
        private NodeWrapper start;
        private NodeWrapper commonParent;
        private ListIterator children;
        private int ix = 0;
        private boolean downwards;
        private boolean forwards;

        public ChildEnumeration(NodeWrapper start, boolean downwards, boolean forwards) {
            this.start = start;
            this.downwards = downwards;
            this.forwards = forwards;
            this.commonParent = downwards ? start : (NodeWrapper)start.getParent();
            this.children = this.commonParent.getNodeKind() == 9 ? ((Document)this.commonParent.node).content().listIterator() : ((Element)this.commonParent.node).content().listIterator();
            if (downwards) {
                if (!forwards) {
                    while (this.children.hasNext()) {
                        this.children.next();
                        ++this.ix;
                    }
                }
            } else {
                this.ix = start.getSiblingPosition();
                if (forwards) {
                    for (int i = 0; i <= this.ix; ++i) {
                        this.children.next();
                    }
                    ++this.ix;
                } else {
                    for (int i = 0; i < this.ix; ++i) {
                        this.children.next();
                    }
                    --this.ix;
                }
            }
        }

        public void advance() {
            if (this.forwards) {
                if (this.children.hasNext()) {
                    Object nextChild = this.children.next();
                    if (nextChild instanceof DocumentType || nextChild instanceof Namespace) {
                        ++this.ix;
                        this.advance();
                        return;
                    }
                    if (nextChild instanceof Entity) {
                        throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                    }
                    this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix++);
                } else {
                    this.current = null;
                }
            } else if (this.children.hasPrevious()) {
                Object nextChild = this.children.previous();
                if (nextChild instanceof DocumentType || nextChild instanceof Namespace) {
                    --this.ix;
                    this.advance();
                    return;
                }
                if (nextChild instanceof Entity) {
                    throw new IllegalStateException("Unexpanded entity in DOM4J tree");
                }
                this.current = NodeWrapper.this.makeWrapper(nextChild, NodeWrapper.this.docWrapper, this.commonParent, this.ix--);
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new ChildEnumeration(this.start, this.downwards, this.forwards);
        }
    }

    private final class NamespaceEnumeration
    extends Navigator.BaseEnumeration {
        private HashMap nslist = new HashMap();
        private Iterator prefixes;
        private int ix = 0;
        private NodeWrapper start;

        public NamespaceEnumeration(NodeWrapper start) {
            this.start = start;
            NodeWrapper curr = start;
            do {
                List addl;
                Element elem = (Element)curr.node;
                Namespace ns = elem.getNamespace();
                String prefix = ns.getPrefix();
                String uri = ns.getURI();
                if (!(prefix.length() == 0 && uri.length() == 0 || this.nslist.containsKey(prefix))) {
                    this.nslist.put(ns.getPrefix(), ns);
                }
                if ((addl = elem.additionalNamespaces()).isEmpty()) continue;
                Iterator itr = addl.iterator();
                while (itr.hasNext()) {
                    ns = (Namespace)itr.next();
                    if (this.nslist.containsKey(ns.getPrefix())) continue;
                    this.nslist.put(ns.getPrefix(), ns);
                }
            } while ((curr = (NodeWrapper)curr.getParent()).getNodeKind() == 1);
            this.nslist.put("xml", Namespace.XML_NAMESPACE);
            this.prefixes = this.nslist.keySet().iterator();
        }

        public void advance() {
            if (this.prefixes.hasNext()) {
                String prefix = (String)this.prefixes.next();
                Namespace ns = (Namespace)this.nslist.get(prefix);
                this.current = NodeWrapper.this.makeWrapper(ns, NodeWrapper.this.docWrapper, this.start, this.ix++);
            } else {
                this.current = null;
            }
        }

        public SequenceIterator getAnother() {
            return new NamespaceEnumeration(this.start);
        }
    }

    private final class AttributeEnumeration
    extends Navigator.BaseEnumeration {
        private Iterator atts;
        private int ix = 0;
        private NodeWrapper start;

        public AttributeEnumeration(NodeWrapper start) {
            this.start = start;
            this.atts = ((Element)start.node).attributes().iterator();
        }

        public void advance() {
            this.current = this.atts.hasNext() ? NodeWrapper.this.makeWrapper(this.atts.next(), NodeWrapper.this.docWrapper, this.start, this.ix++) : null;
        }

        public SequenceIterator getAnother() {
            return new AttributeEnumeration(this.start);
        }
    }
}

