/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom4j;

import java.io.Serializable;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.dom4j.DocumentWrapper;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.ExternalObjectModel;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.value.Value;
import org.dom4j.Attribute;
import org.dom4j.CDATA;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.ProcessingInstruction;
import org.dom4j.Text;

public class DOM4JObjectModel
implements ExternalObjectModel,
Serializable {
    public boolean isRecognizedNode(Object object) {
        return object instanceof Document || object instanceof Element || object instanceof Attribute || object instanceof Text || object instanceof CDATA || object instanceof Comment || object instanceof ProcessingInstruction || object instanceof Namespace;
    }

    public boolean isRecognizedNodeClass(Class nodeClass) {
        return Document.class.isAssignableFrom(nodeClass) || Element.class.isAssignableFrom(nodeClass) || Attribute.class.isAssignableFrom(nodeClass) || Text.class.isAssignableFrom(nodeClass) || CDATA.class.isAssignableFrom(nodeClass) || Comment.class.isAssignableFrom(nodeClass) || ProcessingInstruction.class.isAssignableFrom(nodeClass) || Namespace.class.isAssignableFrom(nodeClass);
    }

    public boolean isRecognizedNodeListClass(Class nodeClass) {
        return false;
    }

    public Receiver getDocumentBuilder(Result result) {
        return null;
    }

    public boolean sendSource(Source source, Receiver receiver, PipelineConfiguration pipe) throws XPathException {
        return false;
    }

    public NodeInfo unravel(Source source, Configuration config) {
        return null;
    }

    public Value convertObjectToXPathValue(Object object, Configuration config) throws XPathException {
        return null;
    }

    public Object convertXPathValueToObject(Value value, Class targetClass, XPathContext context) {
        return null;
    }

    public DocumentInfo wrapDocument(Object node, String baseURI, Configuration config) {
        Document documentNode = this.getDocumentRoot(node);
        return new DocumentWrapper(documentNode, baseURI, config);
    }

    public NodeInfo wrapNode(DocumentInfo document, Object node) {
        return ((DocumentWrapper)document).wrap(node);
    }

    private Document getDocumentRoot(Object node) {
        while (!(node instanceof Document)) {
            if (node instanceof Element) {
                if (((Element)node).isRootElement()) {
                    return ((Element)node).getDocument();
                }
                node = ((Element)node).getParent();
                continue;
            }
            if (node instanceof Text) {
                node = ((Text)node).getParent();
                continue;
            }
            if (node instanceof Comment) {
                node = ((Comment)node).getParent();
                continue;
            }
            if (node instanceof ProcessingInstruction) {
                node = ((ProcessingInstruction)node).getParent();
                continue;
            }
            if (node instanceof Attribute) {
                node = ((Attribute)node).getParent();
                continue;
            }
            if (node instanceof Document) {
                return (Document)node;
            }
            if (node instanceof Namespace) {
                throw new UnsupportedOperationException("Cannot find parent of DOM4J namespace node");
            }
            throw new IllegalStateException("Unknown DOM4J node type " + node.getClass());
        }
        return (Document)node;
    }

    public Object convertToNodeList(SequenceExtent extent) {
        return null;
    }
}

