/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SequenceList<E>
extends TransformedList<E, E> {
    private final List<E> sequence = new ArrayList();
    private final Comparator<E> comparator;
    private final Sequencer<E> sequencer;

    public SequenceList(EventList<E> source, Sequencer<E> sequencer) {
        this(source, sequencer, GlazedLists.comparableComparator());
    }

    public SequenceList(EventList<E> source, Sequencer<E> sequencer, Comparator<E> comparator) {
        this(new SortedList<E>(source, comparator), sequencer, comparator);
    }

    private SequenceList(SortedList<E> source, Sequencer<E> sequencer, Comparator<E> comparator) {
        super(source);
        if (sequencer == null) {
            throw new IllegalArgumentException("sequencer may not be null");
        }
        if (comparator == null) {
            throw new IllegalArgumentException("comparator may not be null");
        }
        this.sequencer = sequencer;
        this.comparator = comparator;
        this.updateSequence();
        source.addListEventListener(this);
    }

    @Override
    public int size() {
        return this.sequence.size();
    }

    @Override
    public E get(int index) {
        return this.sequence.get(index);
    }

    private boolean isSequenceValue(E value) {
        E sequencedValue = this.sequencer.previous(this.sequencer.next(value));
        return this.comparator.compare(value, sequencedValue) == 0;
    }

    public E getPreviousSequenceValue(E value) {
        if (this.isSequenceValue(value)) {
            return value;
        }
        return this.sequencer.previous(value);
    }

    public E getNextSequenceValue(E value) {
        if (this.isSequenceValue(value)) {
            return value;
        }
        return this.sequencer.next(value);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.updateSequence();
    }

    private void updateSequence() {
        this.updates.beginEvent();
        if (this.source.isEmpty()) {
            while (!this.sequence.isEmpty()) {
                this.updates.elementDeleted(0, this.sequence.remove(0));
            }
        } else {
            if (this.isEmpty()) {
                Object value = this.source.get(0);
                Object previousSequenceValue = this.getPreviousSequenceValue(value);
                Object nextSequenceValue = this.getNextSequenceValue(value);
                this.sequence.add(0, previousSequenceValue);
                this.updates.elementInserted(0, previousSequenceValue);
                this.sequence.add(1, nextSequenceValue);
                this.updates.elementInserted(1, nextSequenceValue);
            }
            Object firstSourceValue = this.source.get(0);
            while (this.comparator.compare(firstSourceValue, this.get(0)) == -1) {
                E element = this.sequencer.previous(this.get(0));
                this.sequence.add(0, element);
                this.updates.elementInserted(0, element);
            }
            while (this.comparator.compare(this.get(1), firstSourceValue) == -1) {
                E oldValue = this.sequence.remove(0);
                this.updates.elementDeleted(0, oldValue);
            }
            Object lastSourceValue = this.source.get(this.source.size() - 1);
            while (this.comparator.compare(lastSourceValue, this.get(this.size() - 1)) == 1) {
                E element = this.sequencer.next(this.get(this.size() - 1));
                int index = this.size();
                this.sequence.add(index, element);
                this.updates.elementInserted(index, element);
            }
            while (this.comparator.compare(this.get(this.size() - 2), lastSourceValue) == 1) {
                int lastIndex = this.size() - 1;
                this.updates.elementDeleted(lastIndex, this.sequence.remove(lastIndex));
            }
        }
        this.updates.commitEvent();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Sequencer<E> {
        public E previous(E var1);

        public E next(E var1);
    }
}

