/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.apache.fop.util.ConversionUtils;
import org.apache.fop.util.XMLConstants;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class XMLUtil
implements XMLConstants {
    private XMLUtil() {
    }

    public static boolean getAttributeAsBoolean(Attributes attributes, String string, boolean bl) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public static int getAttributeAsInt(Attributes attributes, String string, int n) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public static int getAttributeAsInt(Attributes attributes, String string) throws SAXException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new SAXException("Attribute '" + string + "' is missing");
        }
        return Integer.parseInt(string2);
    }

    public static Integer getAttributeAsInteger(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        return new Integer(string2);
    }

    public static Rectangle2D getAttributeAsRectangle2D(Attributes attributes, String string) {
        String string2 = attributes.getValue(string).trim();
        double[] dArray = ConversionUtils.toDoubleArray(string2, "\\s");
        if (dArray.length != 4) {
            throw new IllegalArgumentException("Rectangle must consist of 4 double values!");
        }
        return new Rectangle2D.Double(dArray[0], dArray[1], dArray[2], dArray[3]);
    }

    public static Rectangle getAttributeAsRectangle(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        int[] nArray = ConversionUtils.toIntArray(string2.trim(), "\\s");
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Rectangle must consist of 4 int values!");
        }
        return new Rectangle(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public static int[] getAttributeAsIntArray(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        return ConversionUtils.toIntArray(string2.trim(), "\\s");
    }

    public static void addAttribute(AttributesImpl attributesImpl, QName qName, String string) {
        attributesImpl.addAttribute(qName.getNamespaceURI(), qName.getLocalName(), qName.getQName(), "CDATA", string);
    }

    public static void addAttribute(AttributesImpl attributesImpl, String string, String string2) {
        attributesImpl.addAttribute("", string, string, "CDATA", string2);
    }

    public static String encodePositionAdjustments(int[][] nArray, int n) {
        assert (nArray != null);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n;
        int n3 = 0;
        stringBuffer.append(n2);
        for (int i = 0; i < n2; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < 4; ++j) {
                int n4 = nArray2[j];
                if (n4 != 0) {
                    XMLUtil.encodeNextAdjustment(stringBuffer, n3, n4);
                    n3 = 0;
                    continue;
                }
                ++n3;
            }
        }
        XMLUtil.encodeNextAdjustment(stringBuffer, n3, 0);
        return stringBuffer.toString();
    }

    public static String encodePositionAdjustments(int[][] nArray) {
        assert (nArray != null);
        return XMLUtil.encodePositionAdjustments(nArray, nArray.length);
    }

    private static void encodeNextAdjustment(StringBuffer stringBuffer, int n, int n2) {
        XMLUtil.encodeZeroes(stringBuffer, n);
        XMLUtil.encodeAdjustment(stringBuffer, n2);
    }

    private static void encodeZeroes(StringBuffer stringBuffer, int n) {
        if (n > 0) {
            stringBuffer.append(' ');
            if (n == 1) {
                stringBuffer.append('0');
            } else {
                stringBuffer.append('Z');
                stringBuffer.append(n);
            }
        }
    }

    private static void encodeAdjustment(StringBuffer stringBuffer, int n) {
        if (n != 0) {
            stringBuffer.append(' ');
            stringBuffer.append(n);
        }
    }

    public static int[][] decodePositionAdjustments(String string) {
        String[] stringArray;
        int[][] nArray = null;
        if (string != null && (stringArray = string.split("\\s")) != null && stringArray.length > 0) {
            int n = Integer.parseInt(stringArray[0]);
            nArray = new int[n][4];
            int n2 = stringArray.length;
            int n3 = 0;
            for (int i = 1; i < n2; ++i) {
                String string2 = stringArray[i];
                if (string2.charAt(0) == 'Z') {
                    int n4 = Integer.parseInt(string2.substring(1));
                    n3 += n4;
                    continue;
                }
                nArray[n3 / 4][n3 % 4] = Integer.parseInt(string2);
                ++n3;
            }
        }
        return nArray;
    }

    public static int[][] getAttributeAsPositionAdjustments(Attributes attributes, String string) {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return null;
        }
        return XMLUtil.decodePositionAdjustments(string2.trim());
    }
}

