/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.apache.fop.util.ContentHandlerFactory;
import org.apache.fop.util.DelegatingContentHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class DOMBuilderContentHandlerFactory
implements ContentHandlerFactory {
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private String namespaceURI;
    private DOMImplementation domImplementation;

    public DOMBuilderContentHandlerFactory(String string, DOMImplementation dOMImplementation) {
        this.namespaceURI = string;
        this.domImplementation = dOMImplementation;
    }

    public String[] getSupportedNamespaces() {
        return new String[]{this.namespaceURI};
    }

    public ContentHandler createContentHandler() throws SAXException {
        return new Handler();
    }

    private class Handler
    extends DelegatingContentHandler
    implements ContentHandlerFactory.ObjectSource {
        private Document doc;
        private ContentHandlerFactory.ObjectBuiltListener obListener;

        public Document getDocument() {
            return this.doc;
        }

        public Object getObject() {
            return this.getDocument();
        }

        public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener objectBuiltListener) {
            this.obListener = objectBuiltListener;
        }

        public void startDocument() throws SAXException {
            if (this.doc != null) {
                super.startDocument();
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.doc == null) {
                TransformerHandler transformerHandler;
                try {
                    transformerHandler = tFactory.newTransformerHandler();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    throw new SAXException("Error creating a new TransformerHandler", transformerConfigurationException);
                }
                this.doc = DOMBuilderContentHandlerFactory.this.domImplementation.createDocument(DOMBuilderContentHandlerFactory.this.namespaceURI, string3, null);
                this.doc.removeChild(this.doc.getDocumentElement());
                transformerHandler.setResult(new DOMResult(this.doc));
                this.setDelegateContentHandler(transformerHandler);
                this.setDelegateLexicalHandler(transformerHandler);
                this.setDelegateDTDHandler(transformerHandler);
                transformerHandler.startDocument();
            }
            super.startElement(string, string2, string3, attributes);
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.obListener != null) {
                this.obListener.notifyObjectBuilt(this.getObject());
            }
        }
    }
}

