/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandLineLogger
implements Log {
    public static final int LOG_LEVEL_TRACE = 1;
    public static final int LOG_LEVEL_DEBUG = 2;
    public static final int LOG_LEVEL_INFO = 3;
    public static final int LOG_LEVEL_WARN = 4;
    public static final int LOG_LEVEL_ERROR = 5;
    public static final int LOG_LEVEL_FATAL = 6;
    private int logLevel;
    private String logName;

    public CommandLineLogger(String string) {
        this.logName = string;
        this.setLogLevel((String)LogFactory.getFactory().getAttribute("level"));
    }

    public void setLogLevel(String string) {
        this.logLevel = "fatal".equals(string) ? 6 : ("error".equals(string) ? 5 : ("warn".equals(string) ? 4 : ("info".equals(string) ? 3 : ("debug".equals(string) ? 2 : ("trace".equals(string) ? 1 : 3)))));
    }

    public final boolean isTraceEnabled() {
        return this.logLevel <= 1;
    }

    public final boolean isDebugEnabled() {
        return this.logLevel <= 2;
    }

    public final boolean isInfoEnabled() {
        return this.logLevel <= 3;
    }

    public final boolean isWarnEnabled() {
        return this.logLevel <= 4;
    }

    public final boolean isErrorEnabled() {
        return this.logLevel <= 5;
    }

    public final boolean isFatalEnabled() {
        return this.logLevel <= 6;
    }

    public final void trace(Object object) {
        if (this.isTraceEnabled()) {
            this.log(1, object, null);
        }
    }

    public final void trace(Object object, Throwable throwable) {
        if (this.isTraceEnabled()) {
            this.log(1, object, throwable);
        }
    }

    public final void debug(Object object) {
        if (this.isDebugEnabled()) {
            this.log(2, object, null);
        }
    }

    public final void debug(Object object, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.log(2, object, throwable);
        }
    }

    public final void info(Object object) {
        if (this.isInfoEnabled()) {
            this.log(3, object, null);
        }
    }

    public final void info(Object object, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.log(3, object, throwable);
        }
    }

    public final void warn(Object object) {
        if (this.isWarnEnabled()) {
            this.log(4, object, null);
        }
    }

    public final void warn(Object object, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.log(4, object, throwable);
        }
    }

    public final void error(Object object) {
        if (this.isErrorEnabled()) {
            this.log(5, object, null);
        }
    }

    public final void error(Object object, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.log(5, object, throwable);
        }
    }

    public final void fatal(Object object) {
        if (this.isFatalEnabled()) {
            this.log(6, object, null);
        }
    }

    public final void fatal(Object object, Throwable throwable) {
        if (this.isFatalEnabled()) {
            this.log(6, object, throwable);
        }
    }

    protected void log(int n, Object object, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(object));
        if (throwable != null) {
            stringBuffer.append("\n");
            if (!this.isDebugEnabled()) {
                stringBuffer.append(throwable.toString());
                stringBuffer.append("\n");
            } else {
                StringWriter stringWriter = new StringWriter(1024);
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                stringBuffer.append(stringWriter.toString());
            }
        }
        if (n >= 4) {
            System.err.println(stringBuffer);
        } else {
            System.out.println(stringBuffer);
        }
    }
}

