/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class SVGUtilities {
    private static final String SVG_NS = "http://www.w3.org/2000/svg";

    private SVGUtilities() {
    }

    public static Document createSVGDocument(float f, float f2) {
        DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        Document document = dOMImplementation.createDocument(SVG_NS, "svg", null);
        Element element = document.getDocumentElement();
        element.setAttributeNS(null, "width", "" + f);
        element.setAttributeNS(null, "height", "" + f2);
        return document;
    }

    public static float getStringWidth(String string, Font font) {
        Rectangle2D rectangle2D = font.getStringBounds(string, 0, string.length(), new FontRenderContext(new AffineTransform(), true, true));
        return (float)rectangle2D.getWidth();
    }

    public static float getStringHeight(String string, Font font) {
        Rectangle2D rectangle2D = font.getStringBounds(string, 0, string.length(), new FontRenderContext(new AffineTransform(), true, true));
        return (float)rectangle2D.getHeight();
    }

    public static Rectangle2D getStringBounds(String string, Font font) {
        return font.getStringBounds(string, 0, string.length(), new FontRenderContext(new AffineTransform(), true, true));
    }

    public static Element createLine(Document document, float f, float f2, float f3, float f4) {
        Element element = document.createElementNS(SVG_NS, "line");
        element.setAttributeNS(null, "x1", "" + f);
        element.setAttributeNS(null, "x2", "" + f3);
        element.setAttributeNS(null, "y1", "" + f2);
        element.setAttributeNS(null, "y2", "" + f4);
        return element;
    }

    public static Element createEllipse(Document document, float f, float f2, float f3, float f4) {
        Element element = document.createElementNS(SVG_NS, "ellipse");
        element.setAttributeNS(null, "cx", "" + f);
        element.setAttributeNS(null, "rx", "" + f3);
        element.setAttributeNS(null, "cy", "" + f2);
        element.setAttributeNS(null, "ry", "" + f4);
        return element;
    }

    public static Element createPath(Document document, String string) {
        Element element = document.createElementNS(SVG_NS, "path");
        element.setAttributeNS(null, "d", string);
        return element;
    }

    public static Element createText(Document document, float f, float f2, String string) {
        Element element = document.createElementNS(SVG_NS, "text");
        element.setAttributeNS(null, "x", "" + f);
        element.setAttributeNS(null, "y", "" + f2);
        Text text = document.createTextNode(string);
        element.appendChild(text);
        return element;
    }

    public static Element createRect(Document document, float f, float f2, float f3, float f4) {
        Element element = document.createElementNS(SVG_NS, "rect");
        element.setAttributeNS(null, "x", "" + f);
        element.setAttributeNS(null, "y", "" + f2);
        element.setAttributeNS(null, "width", "" + f3);
        element.setAttributeNS(null, "height", "" + f4);
        return element;
    }

    public static Element createG(Document document) {
        Element element = document.createElementNS(SVG_NS, "g");
        return element;
    }

    public static Element createClip(Document document, Element element, String string) {
        Element element2 = document.createElementNS(SVG_NS, "clipPath");
        element2.setAttributeNS(null, "id", string);
        element2.appendChild(element);
        return element2;
    }

    public static Element createImage(Document document, String string, float f, float f2) {
        Element element = document.createElementNS(SVG_NS, "image");
        element.setAttributeNS("http://www.w3.org/1999/xlink", "href", string);
        element.setAttributeNS(null, "width", "" + f);
        element.setAttributeNS(null, "height", "" + f2);
        return element;
    }

    public static Element wrapText(Document document, String string, Font font, float f) {
        Element element = SVGUtilities.createG(document);
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
        float f2 = 0.0f;
        String string2 = "";
        int n = 0;
        float f3 = SVGUtilities.getStringHeight(string, font);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            float f4 = SVGUtilities.getStringWidth(string3, font);
            if ((f2 += f4) > f) {
                if (string2.equals("")) {
                    string2 = string3;
                    string3 = "";
                    f4 = 0.0f;
                }
                Element element2 = SVGUtilities.createText(document, 0.0f, (float)n * (f3 + 5.0f), string2);
                element.appendChild(element2);
                string2 = string3;
                f2 = f4;
                ++n;
                continue;
            }
            string2 = string2 + " " + string3;
        }
        return element;
    }
}

