/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.Version;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.PDFDocumentGraphics2DConfigurator;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PDFTranscoder
extends AbstractFOPTranscoder {
    protected PDFDocumentGraphics2D graphics = null;

    public PDFTranscoder() {
        this.handler = new AbstractFOPTranscoder.FOPErrorHandler();
    }

    protected UserAgent createUserAgent() {
        return new AbstractFOPTranscoder.FOPTranscoderUserAgent(){

            public float getPixelUnitToMillimeter() {
                return super.getPixelUnitToMillimeter();
            }
        };
    }

    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        int n;
        Configuration configuration;
        this.graphics = new PDFDocumentGraphics2D(this.isTextStroked());
        this.graphics.getPDFDocument().getInfo().setProducer("Apache FOP Version " + Version.getVersion() + ": PDF Transcoder for Batik");
        if (this.hints.containsKey((Object)KEY_DEVICE_RESOLUTION)) {
            this.graphics.setDeviceDPI(this.getDeviceResolution());
        }
        this.setupImageInfrastructure(string);
        try {
            configuration = this.getEffectiveConfiguration();
            if (configuration != null) {
                PDFDocumentGraphics2DConfigurator pDFDocumentGraphics2DConfigurator = new PDFDocumentGraphics2DConfigurator();
                n = 0;
                pDFDocumentGraphics2DConfigurator.configure(this.graphics, configuration, n != 0);
            } else {
                this.graphics.setupDefaultFontInfo();
            }
        }
        catch (Exception exception) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", exception);
        }
        super.transcode(document, string, transcoderOutput);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("document size: " + this.width + " x " + this.height));
        }
        configuration = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)document.getDocumentElement());
        float f = UnitProcessor.userSpaceToSVG((float)this.width, (short)9, (short)2, (UnitProcessor.Context)configuration);
        n = (int)((double)f + 0.5);
        float f2 = UnitProcessor.userSpaceToSVG((float)this.height, (short)9, (short)2, (UnitProcessor.Context)configuration);
        int n2 = (int)((double)f2 + 0.5);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("document size: " + n + "pt x " + n2 + "pt"));
        }
        try {
            OutputStream outputStream = transcoderOutput.getOutputStream();
            if (!(outputStream instanceof BufferedOutputStream)) {
                outputStream = new BufferedOutputStream(outputStream);
            }
            this.graphics.setupDocument(outputStream, n, n2);
            this.graphics.setSVGDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                this.graphics.setBackgroundColor((Color)this.hints.get((Object)ImageTranscoder.KEY_BACKGROUND_COLOR));
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.preparePainting();
            this.graphics.transform(this.curTxf);
            this.graphics.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Vector");
            this.root.paint((Graphics2D)((Object)this.graphics));
            this.graphics.finish();
        }
        catch (IOException iOException) {
            throw new TranscoderException((Exception)iOException);
        }
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String string) {
        FontInfo fontInfo = this.graphics.getFontInfo();
        if (this.isTextStroked()) {
            fontInfo = null;
        }
        PDFBridgeContext pDFBridgeContext = new PDFBridgeContext(this.userAgent, fontInfo, this.getImageManager(), this.getImageSessionContext());
        return pDFBridgeContext;
    }
}

