/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.LinearGradientPaint;
import org.apache.batik.ext.awt.MultipleGradientPaint;
import org.apache.batik.ext.awt.RadialGradientPaint;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.PatternPaint;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontSetup;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFGState;
import org.apache.fop.pdf.PDFImageXObject;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFResources;
import org.apache.fop.pdf.PDFText;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.fop.render.pdf.ImageRawCCITTFaxAdapter;
import org.apache.fop.render.pdf.ImageRawJPEGAdapter;
import org.apache.fop.render.pdf.ImageRenderedAdapter;
import org.apache.fop.svg.NativeImageHandler;
import org.apache.fop.svg.PDFGraphicsConfiguration;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRawCCITTFax;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFGraphics2D
extends AbstractGraphics2D
implements NativeImageHandler {
    private static final AffineTransform IDENTITY_TRANSFORM = new AffineTransform();
    private static final int DEC = 8;
    static final int OPAQUE = 255;
    protected PDFDocument pdfDoc;
    protected PDFResourceContext resourceContext;
    protected String pageRef;
    protected PDFPaintingState paintingState;
    protected PDFColorHandler colorHandler;
    protected int baseLevel = 0;
    protected int nativeCount = 0;
    protected FontInfo fontInfo;
    protected Font ovFontState = null;
    protected StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected float currentFontSize;
    protected OutputStream outputStream = null;
    private Graphics2D fmg;

    public PDFGraphics2D(boolean bl, FontInfo fontInfo, PDFDocument pDFDocument, PDFResourceContext pDFResourceContext, String string, String string2, float f) {
        this(bl);
        this.pdfDoc = pDFDocument;
        this.colorHandler = new PDFColorHandler(pDFDocument.getResources());
        this.resourceContext = pDFResourceContext;
        this.currentFontName = string2;
        this.currentFontSize = f;
        this.fontInfo = fontInfo;
        this.pageRef = string;
        this.paintingState = new PDFPaintingState();
    }

    protected PDFGraphics2D(boolean bl) {
        super(bl);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
    }

    public PDFGraphics2D(PDFGraphics2D pDFGraphics2D) {
        super((AbstractGraphics2D)pDFGraphics2D);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        this.fmg = bufferedImage.createGraphics();
        this.pdfDoc = pDFGraphics2D.pdfDoc;
        this.colorHandler = pDFGraphics2D.colorHandler;
        this.resourceContext = pDFGraphics2D.resourceContext;
        this.currentFontName = pDFGraphics2D.currentFontName;
        this.currentFontSize = pDFGraphics2D.currentFontSize;
        this.fontInfo = pDFGraphics2D.fontInfo;
        this.pageRef = pDFGraphics2D.pageRef;
        this.paintingState = pDFGraphics2D.paintingState;
        this.currentStream = pDFGraphics2D.currentStream;
        this.nativeCount = pDFGraphics2D.nativeCount;
        this.outputStream = pDFGraphics2D.outputStream;
        this.ovFontState = pDFGraphics2D.ovFontState;
    }

    public Graphics create() {
        return new PDFGraphics2D(this);
    }

    protected void handleIOException(IOException iOException) {
        iOException.printStackTrace();
    }

    protected void preparePainting() {
    }

    public void setPaintingState(PDFPaintingState pDFPaintingState) {
        this.paintingState = pDFPaintingState;
        this.baseLevel = this.paintingState.getStackLevel();
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public String getString() {
        return this.currentStream.toString();
    }

    public StringBuffer getBuffer() {
        return this.currentStream.getBuffer();
    }

    public String getPageReference() {
        return this.pageRef;
    }

    public void setGraphicContext(GraphicContext graphicContext) {
        this.gc = graphicContext;
        this.setPrivateHints();
    }

    private void setPrivateHints() {
        this.setRenderingHint(RenderingHintsKeyExt.KEY_AVOID_TILE_PAINTING, RenderingHintsKeyExt.VALUE_AVOID_TILE_PAINTING_ON);
    }

    public void setOverrideFontState(Font font) {
        this.ovFontState = font;
    }

    private void concatMatrix(double[] dArray) {
        this.currentStream.write(PDFNumber.doubleOut(dArray[0], 8) + " " + PDFNumber.doubleOut(dArray[1], 8) + " " + PDFNumber.doubleOut(dArray[2], 8) + " " + PDFNumber.doubleOut(dArray[3], 8) + " " + PDFNumber.doubleOut(dArray[4], 8) + " " + PDFNumber.doubleOut(dArray[5], 8) + " cm\n");
    }

    private void concatMatrix(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.concatMatrix(dArray);
        }
    }

    protected AffineTransform getBaseTransform() {
        AffineTransform affineTransform = new AffineTransform(this.paintingState.getTransform());
        return affineTransform;
    }

    public void addLink(Rectangle2D rectangle2D, AffineTransform affineTransform, String string, int n) {
        if (!this.pdfDoc.getProfile().isAnnotationAllowed()) {
            return;
        }
        this.preparePainting();
        AffineTransform affineTransform2 = this.getTransform();
        Shape shape = affineTransform2.createTransformedShape(rectangle2D);
        shape = affineTransform.createTransformedShape(shape);
        if (shape != null) {
            Rectangle rectangle = shape.getBounds();
            if (n != 0) {
                String string2 = "/FitR " + string;
                this.resourceContext.addAnnotation(this.pdfDoc.getFactory().makeLink(rectangle, this.getPageReference(), string2));
            } else {
                this.resourceContext.addAnnotation(this.pdfDoc.getFactory().makeLink(rectangle, string, n, 0.0f));
            }
        }
    }

    @Override
    public void addNativeImage(org.apache.xmlgraphics.image.loader.Image image, float f, float f2, float f3, float f4) {
        AbstractImageAdapter abstractImageAdapter;
        this.preparePainting();
        String string = image.getInfo().getOriginalURI();
        if (string == null) {
            string = "__AddNative_" + this.hashCode() + "_" + this.nativeCount;
            ++this.nativeCount;
        }
        if (image instanceof ImageRawJPEG) {
            abstractImageAdapter = new ImageRawJPEGAdapter((ImageRawJPEG)image, string);
        } else if (image instanceof ImageRawCCITTFax) {
            abstractImageAdapter = new ImageRawCCITTFaxAdapter((ImageRawCCITTFax)image, string);
        } else {
            throw new IllegalArgumentException("Unsupported Image subclass: " + image.getClass().getName());
        }
        PDFImageXObject pDFImageXObject = this.pdfDoc.addImage(this.resourceContext, abstractImageAdapter);
        this.flushPDFDocument();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(f, f2);
        this.useXObject(pDFImageXObject, affineTransform, f3, f4);
    }

    private void flushPDFDocument() {
        if (this.outputStream != null) {
            try {
                this.pdfDoc.output(this.outputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.preparePainting();
        int n3 = image.getWidth(imageObserver);
        int n4 = image.getHeight(imageObserver);
        if (n3 == -1 || n4 == -1) {
            return false;
        }
        return this.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    private BufferedImage buildBufferedImage(Dimension dimension) {
        return new BufferedImage(dimension.width, dimension.height, 2);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        Cloneable cloneable;
        this.preparePainting();
        String string = "TempImage:" + image.toString();
        PDFXObject pDFXObject = this.pdfDoc.getXObject(string);
        if (pDFXObject == null) {
            cloneable = new Dimension(n3, n4);
            BufferedImage bufferedImage = this.buildBufferedImage((Dimension)cloneable);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setBackground(new Color(1, 1, 1, 0));
            graphics2D.setPaint(new Color(1, 1, 1, 0));
            graphics2D.fillRect(0, 0, n3, n4);
            int n5 = bufferedImage.getWidth();
            int n6 = bufferedImage.getHeight();
            graphics2D.clip(new Rectangle(0, 0, n5, n6));
            graphics2D.setComposite(this.gc.getComposite());
            boolean bl = graphics2D.drawImage(image, 0, 0, n5, n6, imageObserver);
            if (!bl) {
                return false;
            }
            graphics2D.dispose();
            pDFXObject = this.addRenderedImage(string, bufferedImage);
        } else {
            this.resourceContext.getPDFResources().addXObject(pDFXObject);
        }
        cloneable = new AffineTransform();
        ((AffineTransform)cloneable).translate(n, n2);
        this.useXObject(pDFXObject, (AffineTransform)cloneable, n3, n4);
        return true;
    }

    public void dispose() {
        this.pdfDoc = null;
        this.fontInfo = null;
        this.currentStream = null;
        this.currentFontName = null;
    }

    public void draw(Shape shape) {
        boolean bl;
        this.preparePainting();
        Color color = this.getColor();
        if (color.getAlpha() == 0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        Shape shape2 = this.getClip();
        boolean bl2 = this.paintingState.checkClip(shape2);
        boolean bl3 = bl = this.paintingState.checkTransform(affineTransform) && !affineTransform.isIdentity();
        if (bl2 || bl) {
            this.saveGraphicsState();
            if (bl) {
                this.concatMatrix(dArray);
            }
            if (bl2) {
                this.writeClip(shape2);
            }
        }
        this.applyAlpha(255, color.getAlpha());
        color = this.getColor();
        this.applyColor(color, false);
        color = this.getBackground();
        this.applyColor(color, true);
        Paint paint = this.getPaint();
        if (this.paintingState.setPaint(paint) && !this.applyPaint(paint, false)) {
            Shape shape3 = this.getStroke().createStrokedShape(shape);
            this.applyUnknownPaint(paint, shape3);
            if (bl2 || bl) {
                this.restoreGraphicsState();
            }
            return;
        }
        this.applyStroke(this.getStroke());
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
        this.processPathIterator(pathIterator);
        this.doDrawing(false, true, false);
        if (bl2 || bl) {
            this.restoreGraphicsState();
        }
    }

    protected void writeClip(Shape shape) {
        if (shape == null) {
            return;
        }
        PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
        if (pathIterator.isDone()) {
            return;
        }
        this.preparePainting();
        this.processPathIterator(pathIterator);
        this.currentStream.write("W\n");
        this.currentStream.write("n\n");
    }

    protected void applyColor(Color color, boolean bl) {
        this.preparePainting();
        if (color.getColorSpace().getType() == 9 && this.pdfDoc.getProfile().getPDFAMode().isPDFA1LevelB()) {
            throw new PDFConformanceException("PDF/A-1 does not allow mixing DeviceRGB and DeviceCMYK.");
        }
        boolean bl2 = false;
        if (bl) {
            if (this.paintingState.setBackColor(color)) {
                bl2 = true;
            }
        } else if (this.paintingState.setColor(color)) {
            bl2 = true;
        }
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            this.colorHandler.establishColor(stringBuffer, color, bl);
            this.currentStream.write(stringBuffer.toString());
        }
    }

    protected boolean applyPaint(Paint paint, boolean bl) {
        GradientPaint gradientPaint;
        this.preparePainting();
        if (paint instanceof Color) {
            return true;
        }
        if (paint instanceof GradientPaint) {
            gradientPaint = (GradientPaint)paint;
            paint = new LinearGradientPaint((float)gradientPaint.getPoint1().getX(), (float)gradientPaint.getPoint1().getY(), (float)gradientPaint.getPoint2().getX(), (float)gradientPaint.getPoint2().getY(), new float[]{0.0f, 1.0f}, new Color[]{gradientPaint.getColor1(), gradientPaint.getColor2()}, gradientPaint.isCyclic() ? LinearGradientPaint.REPEAT : LinearGradientPaint.NO_CYCLE);
        }
        if (paint instanceof LinearGradientPaint) {
            Object object;
            gradientPaint = (LinearGradientPaint)paint;
            MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = gradientPaint.getCycleMethod();
            if (cycleMethodEnum != MultipleGradientPaint.NO_CYCLE) {
                return false;
            }
            Color[] colorArray = gradientPaint.getColors();
            float[] fArray = gradientPaint.getFractions();
            AffineTransform affineTransform = new AffineTransform(this.getBaseTransform());
            affineTransform.concatenate(this.getTransform());
            affineTransform.concatenate(gradientPaint.getTransform());
            ArrayList<Double> arrayList = new ArrayList<Double>();
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            for (int i = 0; i < dArray.length; ++i) {
                arrayList.add(new Double(dArray[i]));
            }
            Point2D point2D = gradientPaint.getStartPoint();
            Point2D point2D2 = gradientPaint.getEndPoint();
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            arrayList2.add(new Double(point2D.getX()));
            arrayList2.add(new Double(point2D.getY()));
            arrayList2.add(new Double(point2D2.getX()));
            arrayList2.add(new Double(point2D2.getY()));
            ArrayList<Boolean> arrayList3 = new ArrayList<Boolean>();
            arrayList3.add(Boolean.TRUE);
            arrayList3.add(Boolean.TRUE);
            ArrayList<Double> arrayList4 = new ArrayList<Double>();
            arrayList4.add(new Double(0.0));
            arrayList4.add(new Double(1.0));
            ArrayList<Double> arrayList5 = new ArrayList<Double>();
            arrayList5.add(new Double(0.0));
            arrayList5.add(new Double(1.0));
            arrayList5.add(new Double(0.0));
            arrayList5.add(new Double(1.0));
            ArrayList<Double> arrayList6 = new ArrayList<Double>();
            ArrayList<Color> arrayList7 = new ArrayList<Color>();
            for (int i = 0; i < colorArray.length; ++i) {
                object = colorArray[i];
                if (((Color)object).getAlpha() != 255) {
                    return false;
                }
                arrayList7.add((Color)object);
                if (i <= 0 || i >= colorArray.length - 1) continue;
                arrayList6.add(new Double(fArray[i]));
            }
            PDFDeviceColorSpace pDFDeviceColorSpace = new PDFDeviceColorSpace(2);
            object = this.pdfDoc.getFactory().makeGradient(this.resourceContext, false, pDFDeviceColorSpace, arrayList7, arrayList6, arrayList2, arrayList);
            this.currentStream.write(((PDFPattern)object).getColorSpaceOut(bl));
            return true;
        }
        if (paint instanceof RadialGradientPaint) {
            Serializable serializable;
            double d;
            gradientPaint = (RadialGradientPaint)paint;
            MultipleGradientPaint.CycleMethodEnum cycleMethodEnum = gradientPaint.getCycleMethod();
            if (cycleMethodEnum != MultipleGradientPaint.NO_CYCLE) {
                return false;
            }
            AffineTransform affineTransform = new AffineTransform(this.getBaseTransform());
            affineTransform.concatenate(this.getTransform());
            affineTransform.concatenate(gradientPaint.getTransform());
            ArrayList<Double> arrayList = new ArrayList<Double>();
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            for (int i = 0; i < dArray.length; ++i) {
                arrayList.add(new Double(dArray[i]));
            }
            double d2 = gradientPaint.getRadius();
            Point2D point2D = gradientPaint.getCenterPoint();
            Point2D point2D3 = gradientPaint.getFocusPoint();
            ArrayList<Double> arrayList8 = new ArrayList<Double>();
            double d3 = point2D3.getX() - point2D.getX();
            double d4 = Math.sqrt(d3 * d3 + (d = point2D3.getY() - point2D.getY()) * d);
            if (d4 > d2) {
                double d5 = d2 * 0.9999 / d4;
                d3 *= d5;
                d *= d5;
            }
            arrayList8.add(new Double(point2D.getX() + d3));
            arrayList8.add(new Double(point2D.getY() + d));
            arrayList8.add(new Double(0.0));
            arrayList8.add(new Double(point2D.getX()));
            arrayList8.add(new Double(point2D.getY()));
            arrayList8.add(new Double(d2));
            Color[] colorArray = gradientPaint.getColors();
            ArrayList<Serializable> arrayList9 = new ArrayList<Serializable>();
            for (int i = 0; i < colorArray.length; ++i) {
                serializable = colorArray[i];
                if (((Color)serializable).getAlpha() != 255) {
                    return false;
                }
                arrayList9.add(serializable);
            }
            float[] fArray = gradientPaint.getFractions();
            serializable = new ArrayList();
            for (int i = 1; i < fArray.length - 1; ++i) {
                float f = fArray[i];
                serializable.add(new Double(f));
            }
            PDFDeviceColorSpace pDFDeviceColorSpace = new PDFDeviceColorSpace(2);
            PDFPattern pDFPattern = this.pdfDoc.getFactory().makeGradient(this.resourceContext, true, pDFDeviceColorSpace, arrayList9, (List)((Object)serializable), arrayList8, arrayList);
            this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
            return true;
        }
        if (paint instanceof PatternPaint) {
            gradientPaint = (PatternPaint)paint;
            return this.createPattern((PatternPaint)gradientPaint, bl);
        }
        return false;
    }

    private boolean createPattern(PatternPaint patternPaint, boolean bl) {
        this.preparePainting();
        FontInfo fontInfo = new FontInfo();
        boolean bl2 = false;
        FontSetup.setup(fontInfo, bl2);
        PDFResources pDFResources = this.pdfDoc.getFactory().makeResources();
        PDFResourceContext pDFResourceContext = new PDFResourceContext(pDFResources);
        PDFGraphics2D pDFGraphics2D = new PDFGraphics2D(this.textAsShapes, fontInfo, this.pdfDoc, pDFResourceContext, this.getPageReference(), "", 0.0f);
        pDFGraphics2D.setGraphicContext(new GraphicContext());
        pDFGraphics2D.gc.validateTransformStack();
        pDFGraphics2D.setRenderingHints(this.getRenderingHints());
        pDFGraphics2D.setOutputStream(this.outputStream);
        GraphicsNode graphicsNode = patternPaint.getGraphicsNode();
        Rectangle2D rectangle2D = patternPaint.getPatternRect();
        graphicsNode.paint((Graphics2D)((Object)pDFGraphics2D));
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(rectangle2D.getX()));
        arrayList.add(new Double(rectangle2D.getHeight() + rectangle2D.getY()));
        arrayList.add(new Double(rectangle2D.getWidth() + rectangle2D.getX()));
        arrayList.add(new Double(rectangle2D.getY()));
        AffineTransform affineTransform = new AffineTransform(this.getBaseTransform());
        affineTransform.concatenate(this.getTransform());
        affineTransform.concatenate(patternPaint.getPatternTransform());
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        for (int i = 0; i < dArray.length; ++i) {
            arrayList2.add(new Double(dArray[i]));
        }
        pDFResources.addFonts(this.pdfDoc, fontInfo);
        PDFPattern pDFPattern = this.pdfDoc.getFactory().makePattern(this.resourceContext, 1, pDFResources, 1, 1, arrayList, rectangle2D.getWidth(), rectangle2D.getHeight(), arrayList2, null, pDFGraphics2D.getBuffer());
        this.currentStream.write(pDFPattern.getColorSpaceOut(bl));
        PDFAnnotList pDFAnnotList = pDFResourceContext.getAnnotations();
        if (pDFAnnotList != null) {
            this.pdfDoc.addObject(pDFAnnotList);
        }
        this.flushPDFDocument();
        return true;
    }

    protected boolean applyUnknownPaint(Paint paint, Shape shape) {
        Rectangle rectangle;
        this.preparePainting();
        Shape shape2 = this.getClip();
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (shape2 != null) {
            Rectangle2D rectangle2D2 = shape2.getBounds2D();
            if (!rectangle2D2.intersects(rectangle2D)) {
                return true;
            }
            Rectangle2D.intersect(rectangle2D, rectangle2D2, rectangle2D);
        }
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        AffineTransform affineTransform = this.getTransform();
        Rectangle rectangle2 = affineTransform.createTransformedShape(shape).getBounds();
        if (shape2 != null) {
            Rectangle rectangle3 = affineTransform.createTransformedShape(shape2).getBounds();
            if (!rectangle3.intersects(rectangle2)) {
                return true;
            }
            rectangle = rectangle2.intersection(rectangle3);
        } else {
            rectangle = rectangle2;
        }
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        DirectColorModel directColorModel = new DirectColorModel(colorSpace, 32, 0xFF0000, 65280, 255, -16777216, false, 0);
        PaintContext paintContext = paint.createContext(directColorModel, rectangle, rectangle2D, affineTransform, this.getRenderingHints());
        PDFXObject pDFXObject = this.pdfDoc.getXObject("TempImage:" + paintContext.toString());
        if (pDFXObject != null) {
            this.resourceContext.getPDFResources().addXObject(pDFXObject);
        } else {
            BitmapImage bitmapImage;
            byte[] byArray;
            Raster raster = paintContext.getRaster(n, n2, n3, n4);
            WritableRaster writableRaster = (WritableRaster)raster;
            writableRaster = writableRaster.createWritableTranslatedChild(0, 0);
            ColorModel colorModel = paintContext.getColorModel();
            BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            byte[] byArray2 = new byte[n3 * n4 * 3];
            int[] nArray = new int[n3];
            int n5 = 0;
            if (colorModel.hasAlpha()) {
                byArray = new byte[n3 * n4];
                int n6 = 0;
                for (int i = 0; i < n4; ++i) {
                    bufferedImage.getRGB(0, i, n3, 1, nArray, 0, n3);
                    for (int j = 0; j < n3; ++j) {
                        int n7 = nArray[j];
                        byArray[n6++] = (byte)(n7 >>> 24);
                        byArray2[n5++] = (byte)(n7 >> 16 & 0xFF);
                        byArray2[n5++] = (byte)(n7 >> 8 & 0xFF);
                        byArray2[n5++] = (byte)(n7 & 0xFF);
                    }
                }
            } else {
                byArray = null;
                for (int i = 0; i < n4; ++i) {
                    bufferedImage.getRGB(0, i, n3, 1, nArray, 0, n3);
                    for (int j = 0; j < n3; ++j) {
                        int n8 = nArray[j];
                        byArray2[n5++] = (byte)(n8 >> 16 & 0xFF);
                        byArray2[n5++] = (byte)(n8 >> 8 & 0xFF);
                        byArray2[n5++] = (byte)(n8 & 0xFF);
                    }
                }
            }
            String string = null;
            if (byArray != null) {
                bitmapImage = new BitmapImage("TempImageMask:" + paintContext.toString(), n3, n4, byArray, null);
                bitmapImage.setColorSpace(new PDFDeviceColorSpace(1));
                PDFImageXObject pDFImageXObject = this.pdfDoc.addImage(this.resourceContext, bitmapImage);
                string = pDFImageXObject.referencePDF();
                this.flushPDFDocument();
            }
            bitmapImage = new BitmapImage("TempImage:" + paintContext.toString(), n3, n4, byArray2, string);
            bitmapImage.setTransparent(new PDFColor(255, 255, 255));
            pDFXObject = this.pdfDoc.addImage(this.resourceContext, bitmapImage);
            this.flushPDFDocument();
        }
        this.currentStream.write("q\n");
        this.writeClip(shape);
        this.currentStream.write("" + PDFNumber.doubleOut(d3) + " 0 0 " + PDFNumber.doubleOut(-d4) + " " + PDFNumber.doubleOut(d) + " " + PDFNumber.doubleOut(d2 + d4) + " cm\n" + pDFXObject.getName() + " Do\nQ\n");
        return true;
    }

    protected void applyStroke(Stroke stroke) {
        this.preparePainting();
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            float[] fArray = basicStroke.getDashArray();
            if (fArray != null) {
                this.currentStream.write("[");
                for (int i = 0; i < fArray.length; ++i) {
                    this.currentStream.write(PDFNumber.doubleOut(fArray[i]));
                    if (i >= fArray.length - 1) continue;
                    this.currentStream.write(" ");
                }
                this.currentStream.write("] ");
                float f = basicStroke.getDashPhase();
                this.currentStream.write(PDFNumber.doubleOut(f) + " d\n");
            } else {
                this.currentStream.write("[] 0 d\n");
            }
            int n = basicStroke.getEndCap();
            switch (n) {
                case 0: {
                    this.currentStream.write("0 J\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 J\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 J\n");
                    break;
                }
            }
            int n2 = basicStroke.getLineJoin();
            switch (n2) {
                case 0: {
                    this.currentStream.write("0 j\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 j\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 j\n");
                    break;
                }
            }
            float f = basicStroke.getLineWidth();
            this.currentStream.write(PDFNumber.doubleOut(f) + " w\n");
            float f2 = basicStroke.getMiterLimit();
            this.currentStream.write(PDFNumber.doubleOut(f2) + " M\n");
        }
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        String string = "TempImage:" + renderedImage.toString();
        this.drawInnerRenderedImage(string, renderedImage, affineTransform);
    }

    public void drawInnerRenderedImage(String string, RenderedImage renderedImage, AffineTransform affineTransform) {
        this.preparePainting();
        PDFXObject pDFXObject = this.pdfDoc.getXObject(string);
        if (pDFXObject == null) {
            pDFXObject = this.addRenderedImage(string, renderedImage);
        } else {
            this.resourceContext.getPDFResources().addXObject(pDFXObject);
        }
        this.useXObject(pDFXObject, affineTransform, renderedImage.getWidth(), renderedImage.getHeight());
    }

    private void useXObject(PDFXObject pDFXObject, AffineTransform affineTransform, float f, float f2) {
        this.currentStream.write("q\n");
        this.concatMatrix(this.getTransform());
        Shape shape = this.getClip();
        this.writeClip(shape);
        this.concatMatrix(affineTransform);
        String string = PDFNumber.doubleOut(f, 8);
        String string2 = PDFNumber.doubleOut(f2, 8);
        this.currentStream.write("" + string + " 0 0 -" + string2 + " 0 " + string2 + " cm\n" + pDFXObject.getName() + " Do\nQ\n");
    }

    private PDFXObject addRenderedImage(String string, RenderedImage renderedImage) {
        ImageInfo imageInfo = new ImageInfo(null, "image/unknown");
        ImageSize imageSize = new ImageSize(renderedImage.getWidth(), renderedImage.getHeight(), 72.0);
        imageInfo.setSize(imageSize);
        ImageRendered imageRendered = new ImageRendered(imageInfo, renderedImage, null);
        ImageRenderedAdapter imageRenderedAdapter = new ImageRenderedAdapter(imageRendered, string);
        PDFImageXObject pDFImageXObject = this.pdfDoc.addImage(this.resourceContext, imageRenderedAdapter);
        this.flushPDFDocument();
        return pDFImageXObject;
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.drawRenderedImage(renderableImage.createDefaultRendering(), affineTransform);
    }

    public void drawString(String string, float f, float f2) {
        Font font;
        Serializable serializable;
        this.preparePainting();
        AffineTransform affineTransform = null;
        if (this.ovFontState == null) {
            serializable = this.getFont();
            affineTransform = ((java.awt.Font)serializable).getTransform();
            font = this.fontInfo.getFontInstanceForAWTFont((java.awt.Font)serializable);
        } else {
            font = this.fontInfo.getFontInstance(this.ovFontState.getFontTriplet(), this.ovFontState.getFontSize());
            this.ovFontState = null;
        }
        this.updateCurrentFont(font);
        this.saveGraphicsState();
        serializable = this.getColor();
        this.applyColor((Color)serializable, true);
        this.applyPaint(this.getPaint(), true);
        this.applyAlpha(((Color)serializable).getAlpha(), 255);
        Map<Integer, Map<Integer, Integer>> map = font.getKerning();
        boolean bl = map != null && !map.isEmpty();
        boolean bl2 = this.isMultiByteFont(this.currentFontName);
        String string2 = bl2 ? "<" : "(";
        String string3 = bl2 ? "> " : ") ";
        AffineTransform affineTransform2 = this.getTransform();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        this.concatMatrix(dArray);
        Shape shape = this.getClip();
        this.writeClip(shape);
        this.currentStream.write("BT\n");
        AffineTransform affineTransform3 = new AffineTransform();
        affineTransform3.translate(f, f2);
        if (affineTransform != null) {
            affineTransform3.concatenate(affineTransform);
        }
        affineTransform3.scale(1.0, -1.0);
        double[] dArray2 = new double[6];
        affineTransform3.getMatrix(dArray2);
        this.currentStream.write(PDFNumber.doubleOut(dArray2[0]) + " " + PDFNumber.doubleOut(dArray2[1]) + " " + PDFNumber.doubleOut(dArray2[2]) + " " + PDFNumber.doubleOut(dArray2[3]) + " " + PDFNumber.doubleOut(dArray2[4]) + " " + PDFNumber.doubleOut(dArray2[5]) + " Tm [" + string2);
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = font.mapChar(string.charAt(i));
            if (!bl2) {
                if (c > '\u007f') {
                    this.currentStream.write("\\");
                    this.currentStream.write(Integer.toOctalString(c));
                } else {
                    switch (c) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            this.currentStream.write("\\");
                            break;
                        }
                    }
                    this.currentStream.write(c);
                }
            } else {
                this.currentStream.write(PDFText.toUnicodeHex(c));
            }
            if (!bl || i + 1 >= n) continue;
            this.addKerning(this.currentStream, Integer.valueOf(c), Integer.valueOf(font.mapChar(string.charAt(i + 1))), map, string2, string3);
        }
        this.currentStream.write(string3);
        this.currentStream.write("] TJ\n");
        this.currentStream.write("ET\n");
        this.restoreGraphicsState();
    }

    protected void applyAlpha(int n, int n2) {
        if (n != 255 || n2 != 255) {
            this.checkTransparencyAllowed();
            HashMap<String, Float> hashMap = new HashMap<String, Float>();
            if (n != 255) {
                hashMap.put("ca", new Float((float)n / 255.0f));
            }
            if (n2 != 255) {
                hashMap.put("CA", new Float((float)n2 / 255.0f));
            }
            PDFGState pDFGState = this.pdfDoc.getFactory().makeGState(hashMap, this.paintingState.getGState());
            this.resourceContext.addGState(pDFGState);
            this.currentStream.write("/" + pDFGState.getName() + " gs\n");
        }
    }

    protected void updateCurrentFont(Font font) {
        String string = font.getFontName();
        float f = (float)font.getFontSize() / 1000.0f;
        if (!string.equals(this.currentFontName) || f != this.currentFontSize) {
            this.currentFontName = string;
            this.currentFontSize = f;
            this.currentStream.write("/" + string + " " + f + " Tf\n");
        }
    }

    @Deprecated
    protected Font getInternalFontForAWTFont(java.awt.Font font) {
        return this.fontInfo.getFontInstanceForAWTFont(font);
    }

    protected boolean isMultiByteFont(String string) {
        Typeface typeface = this.fontInfo.getFonts().get(string);
        return typeface.isMultiByte();
    }

    private void addKerning(StringWriter stringWriter, Integer n, Integer n2, Map<Integer, Map<Integer, Integer>> map, String string, String string2) {
        Integer n3;
        this.preparePainting();
        Map<Integer, Integer> map2 = map.get(n);
        if (map2 != null && (n3 = map2.get(n2)) != null) {
            this.currentStream.write(string2 + -n3.intValue() + " " + string);
        }
    }

    public void fill(Shape shape) {
        boolean bl;
        this.preparePainting();
        Color color = this.getBackground();
        if (color.getAlpha() == 0 && (color = this.getColor()).getAlpha() == 0) {
            return;
        }
        AffineTransform affineTransform = this.getTransform();
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        Shape shape2 = this.getClip();
        boolean bl2 = this.paintingState.checkClip(shape2);
        boolean bl3 = bl = this.paintingState.checkTransform(affineTransform) && !affineTransform.isIdentity();
        if (bl2 || bl) {
            this.saveGraphicsState();
            if (bl) {
                this.concatMatrix(dArray);
            }
            if (bl2) {
                this.writeClip(shape2);
            }
        }
        this.applyAlpha(color.getAlpha(), 255);
        color = this.getColor();
        this.applyColor(color, true);
        color = this.getBackground();
        this.applyColor(color, false);
        Paint paint = this.getPaint();
        if (this.paintingState.setPaint(paint) && !this.applyPaint(paint, true)) {
            this.applyUnknownPaint(paint, shape);
            if (bl2 || bl) {
                this.restoreGraphicsState();
            }
            return;
        }
        if (shape instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)shape;
            this.currentStream.write(PDFNumber.doubleOut(rectangle2D.getMinX(), 8) + " " + PDFNumber.doubleOut(rectangle2D.getMinY(), 8) + " ");
            this.currentStream.write(PDFNumber.doubleOut(rectangle2D.getWidth(), 8) + " " + PDFNumber.doubleOut(rectangle2D.getHeight(), 8) + " re ");
            this.doDrawing(true, false, false);
        } else {
            PathIterator pathIterator = shape.getPathIterator(IDENTITY_TRANSFORM);
            this.processPathIterator(pathIterator);
            this.doDrawing(true, false, pathIterator.getWindingRule() == 0);
        }
        if (bl2 || bl) {
            this.restoreGraphicsState();
        }
    }

    void saveGraphicsState() {
        this.currentStream.write("q\n");
        this.paintingState.save();
    }

    void restoreGraphicsState() {
        this.currentStream.write("Q\n");
        this.paintingState.restore();
    }

    protected void checkTransparencyAllowed() {
        this.pdfDoc.getProfile().verifyTransparencyAllowed("Java2D graphics");
    }

    public void processPathIterator(PathIterator pathIterator) {
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n = pathIterator.currentSegment(dArray);
            switch (n) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(dArray[0], 8) + " " + PDFNumber.doubleOut(dArray[1], 8) + " " + PDFNumber.doubleOut(dArray[2], 8) + " " + PDFNumber.doubleOut(dArray[3], 8) + " " + PDFNumber.doubleOut(dArray[4], 8) + " " + PDFNumber.doubleOut(dArray[5], 8) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(dArray[0], 8) + " " + PDFNumber.doubleOut(dArray[1], 8) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(dArray[0], 8) + " " + PDFNumber.doubleOut(dArray[1], 8) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(dArray[0], 8) + " " + PDFNumber.doubleOut(dArray[1], 8) + " " + PDFNumber.doubleOut(dArray[2], 8) + " " + PDFNumber.doubleOut(dArray[3], 8) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            pathIterator.next();
        }
    }

    protected void doDrawing(boolean bl, boolean bl2, boolean bl3) {
        this.preparePainting();
        if (bl) {
            if (bl2) {
                if (bl3) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (bl3) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new PDFGraphicsConfiguration();
    }

    public FontMetrics getFontMetrics(java.awt.Font font) {
        return this.fmg.getFontMetrics(font);
    }

    public void setXORMode(Color color) {
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
    }
}

