/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.text.AttributedCharacterIterator;
import java.util.List;
import org.apache.batik.dom.svg.SVGOMTextElement;
import org.apache.batik.gvt.TextNode;
import org.apache.batik.gvt.TextPainter;
import org.apache.batik.gvt.renderer.StrokingTextPainter;
import org.apache.batik.gvt.text.GVTAttributedCharacterIterator;
import org.apache.batik.gvt.text.Mark;
import org.apache.batik.gvt.text.TextPaintInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPGraphics2D;
import org.apache.fop.fonts.Font;
import org.apache.fop.svg.ACIUtils;
import org.apache.fop.svg.FOPTextHandler;

public abstract class AbstractFOPTextPainter
implements TextPainter {
    protected Log log = LogFactory.getLog(AbstractFOPTextPainter.class);
    private final FOPTextHandler nativeTextHandler;
    protected static final TextPainter PROXY_PAINTER = StrokingTextPainter.getInstance();

    public AbstractFOPTextPainter(FOPTextHandler fOPTextHandler) {
        this.nativeTextHandler = fOPTextHandler;
    }

    public void paint(TextNode textNode, Graphics2D graphics2D) {
        Point2D point2D = textNode.getLocation();
        if (!this.isSupportedGraphics2D(graphics2D) || this.hasUnsupportedAttributes(textNode)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("painting text node " + textNode + " by stroking due to unsupported attributes or an incompatible Graphics2D"));
            }
            PROXY_PAINTER.paint(textNode, graphics2D);
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("painting text node " + textNode + " normally."));
            }
            this.paintTextRuns(textNode.getTextRuns(), graphics2D, point2D);
        }
    }

    protected abstract boolean isSupportedGraphics2D(Graphics2D var1);

    private boolean hasUnsupportedAttributes(TextNode textNode) {
        for (StrokingTextPainter.TextRun textRun : textNode.getTextRuns()) {
            AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
            boolean bl = this.hasUnsupportedAttributes(attributedCharacterIterator);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnsupportedAttributes(AttributedCharacterIterator attributedCharacterIterator) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Paint paint;
        TextPaintInfo textPaintInfo;
        boolean bl = false;
        Font font = this.getFont(attributedCharacterIterator);
        String string = this.getText(attributedCharacterIterator);
        if (this.hasUnsupportedGlyphs(string, font)) {
            this.log.trace((Object)"-> Unsupported glyphs found");
            bl = true;
        }
        if ((textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO)) != null && (textPaintInfo.strokeStroke != null && textPaintInfo.strokePaint != null || textPaintInfo.strikethroughStroke != null || textPaintInfo.underlineStroke != null || textPaintInfo.overlineStroke != null)) {
            this.log.trace((Object)"-> under/overlines etc. found");
            bl = true;
        }
        if ((paint = (Paint)attributedCharacterIterator.getAttribute(TextAttribute.FOREGROUND)) instanceof Color && ((Color)(object6 = (Color)paint)).getAlpha() != 255) {
            this.log.trace((Object)"-> transparency found");
            bl = true;
        }
        if ((object6 = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LETTER_SPACING)) != null) {
            this.log.trace((Object)"-> letter spacing found");
            bl = true;
        }
        if ((object5 = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WORD_SPACING)) != null) {
            this.log.trace((Object)"-> word spacing found");
            bl = true;
        }
        if ((object4 = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.LENGTH_ADJUST)) != null) {
            this.log.trace((Object)"-> length adjustments found");
            bl = true;
        }
        if ((object3 = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE)) != null && !GVTAttributedCharacterIterator.TextAttribute.WRITING_MODE_LTR.equals(object3)) {
            this.log.trace((Object)"-> Unsupported writing modes found");
            bl = true;
        }
        if (GVTAttributedCharacterIterator.TextAttribute.ORIENTATION_ANGLE.equals(object2 = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.VERTICAL_ORIENTATION))) {
            this.log.trace((Object)"-> vertical orientation found");
            bl = true;
        }
        if ((object = attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.TEXT_COMPOUND_DELIMITER)) != null && !(object instanceof SVGOMTextElement)) {
            this.log.trace((Object)"-> spans found");
            bl = true;
        }
        if (bl) {
            this.log.trace((Object)"Unsupported attributes found in ACI, using StrokingTextPainter");
        }
        return bl;
    }

    protected void paintTextRuns(List list, Graphics2D graphics2D, Point2D point2D) {
        Point2D point2D2 = point2D;
        for (StrokingTextPainter.TextRun textRun : list) {
            point2D2 = this.paintTextRun(textRun, graphics2D, point2D2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Point2D paintTextRun(StrokingTextPainter.TextRun textRun, Graphics2D graphics2D, Point2D point2D) {
        Color color;
        TextPaintInfo textPaintInfo;
        AttributedCharacterIterator attributedCharacterIterator = textRun.getACI();
        attributedCharacterIterator.first();
        this.updateLocationFromACI(attributedCharacterIterator, point2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        point2D = affineTransform.transform(point2D, null);
        Font font = this.getFont(attributedCharacterIterator);
        if (font != null) {
            this.nativeTextHandler.setOverrideFont(font);
        }
        if ((textPaintInfo = (TextPaintInfo)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.PAINT_INFO)) == null) {
            return point2D;
        }
        Paint paint = textPaintInfo.fillPaint;
        if (paint instanceof Color) {
            color = (Color)paint;
            graphics2D.setColor(color);
        }
        graphics2D.setPaint(paint);
        color = (TextNode.Anchor)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.ANCHOR_TYPE);
        String string = this.getText(attributedCharacterIterator);
        float f = this.getStringWidth(string, font);
        float f2 = 0.0f;
        if (color != null) {
            switch (color.getType()) {
                case 1: {
                    f2 = -f / 2.0f;
                    break;
                }
                case 2: {
                    f2 = -f;
                    break;
                }
            }
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        try {
            try {
                this.nativeTextHandler.drawString(graphics2D, string, (float)d + f2, (float)d2);
            }
            catch (IOException iOException) {
                if (graphics2D instanceof AFPGraphics2D) {
                    ((AFPGraphics2D)((Object)graphics2D)).handleIOException(iOException);
                }
            }
        }
        finally {
            this.nativeTextHandler.setOverrideFont(null);
        }
        point2D.setLocation(point2D.getX() + (double)f, point2D.getY());
        return point2D;
    }

    protected String getText(AttributedCharacterIterator attributedCharacterIterator) {
        StringBuffer stringBuffer = new StringBuffer(attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private void updateLocationFromACI(AttributedCharacterIterator attributedCharacterIterator, Point2D point2D) {
        Float f = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.X);
        Float f2 = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.Y);
        Float f3 = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DX);
        Float f4 = (Float)attributedCharacterIterator.getAttribute((AttributedCharacterIterator.Attribute)GVTAttributedCharacterIterator.TextAttribute.DY);
        if (f != null) {
            point2D.setLocation(f.doubleValue(), point2D.getY());
        }
        if (f2 != null) {
            point2D.setLocation(point2D.getX(), f2.doubleValue());
        }
        if (f3 != null) {
            point2D.setLocation(point2D.getX() + f3.doubleValue(), point2D.getY());
        }
        if (f4 != null) {
            point2D.setLocation(point2D.getX(), point2D.getY() + f4.doubleValue());
        }
    }

    private Font getFont(AttributedCharacterIterator attributedCharacterIterator) {
        Font[] fontArray = ACIUtils.findFontsForBatikACI(attributedCharacterIterator, this.nativeTextHandler.getFontInfo());
        return fontArray[0];
    }

    private float getStringWidth(String string, Font font) {
        float f = 0.0f;
        float f2 = font.getWidth(font.mapChar(' '));
        for (int i = 0; i < string.length(); ++i) {
            float f3;
            char c = string.charAt(i);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                f3 = font.getWidth(font.mapChar(c));
                if (f3 <= 0.0f) {
                    f3 = f2;
                }
            } else {
                f3 = f2;
            }
            f += f3;
        }
        return f / 1000.0f;
    }

    private boolean hasUnsupportedGlyphs(String string, Font font) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t' || font.hasChar(c)) continue;
            return true;
        }
        return false;
    }

    public Shape getOutline(TextNode textNode) {
        return PROXY_PAINTER.getOutline(textNode);
    }

    public Rectangle2D getBounds2D(TextNode textNode) {
        return PROXY_PAINTER.getBounds2D(textNode);
    }

    public Rectangle2D getGeometryBounds(TextNode textNode) {
        return PROXY_PAINTER.getGeometryBounds(textNode);
    }

    public Mark getMark(TextNode textNode, int n, boolean bl) {
        return null;
    }

    public Mark selectAt(double d, double d2, TextNode textNode) {
        return null;
    }

    public Mark selectTo(double d, double d2, Mark mark) {
        return null;
    }

    public Mark selectFirst(TextNode textNode) {
        return null;
    }

    public Mark selectLast(TextNode textNode) {
        return null;
    }

    public int[] getSelected(Mark mark, Mark mark2) {
        return null;
    }

    public Shape getHighlightShape(Mark mark, Mark mark2) {
        return null;
    }
}

