/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.tools;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.flow.table.Table;
import org.apache.fop.fo.flow.table.TableColumn;
import org.apache.fop.fo.pagination.PageSequence;

public class PercentContext
implements PercentBaseContext {
    private static Log log = LogFactory.getLog(PercentContext.class);
    private Map lengthMap = new HashMap();
    private Map tableUnitMap = new HashMap();
    private boolean baseWidthSet = false;

    public int getBaseLength(int n, FObj fObj) {
        if (fObj == null) {
            return 0;
        }
        if (fObj instanceof TableColumn && fObj.getParent() instanceof FObj) {
            fObj = (FObj)fObj.getParent();
        }
        switch (n) {
            case 3: 
            case 4: 
            case 5: {
                Object v = this.lengthMap.get(fObj);
                if (v != null) {
                    return Integer.parseInt(v.toString());
                }
                if (fObj.getParent() != null && (v = this.lengthMap.get(fObj.getParent())) != null) {
                    return Integer.parseInt(v.toString());
                }
                return 0;
            }
            case 11: {
                Object v = this.tableUnitMap.get(fObj);
                if (v != null) {
                    return (Integer)v;
                }
                if (fObj.getParent() != null && (v = this.tableUnitMap.get(fObj.getParent())) != null) {
                    return (Integer)v;
                }
                return 0;
            }
        }
        log.error((Object)new Exception("Unsupported base type for LengthBase:" + n));
        return 0;
    }

    public void setDimension(FObj fObj, int n) {
        if (fObj instanceof PageSequence) {
            this.baseWidthSet = true;
        }
        this.lengthMap.put(fObj, new Integer(n));
    }

    public void setTableUnit(Table table, int n) {
        this.tableUnitMap.put(table, new Integer(n));
    }

    private Integer findParent(FONode fONode) {
        if (fONode.getRoot() != fONode) {
            if (this.lengthMap.containsKey(fONode)) {
                return new Integer(this.lengthMap.get(fONode).toString());
            }
            return this.findParent(fONode.getParent());
        }
        log.error((Object)("Base Value for element " + fONode.getName() + " not found"));
        return new Integer(-1);
    }

    public void setDimension(FObj fObj) {
        Integer n;
        if (this.baseWidthSet && (n = this.findParent(fObj.getParent())) != -1) {
            this.lengthMap.put(fObj, n);
        }
    }
}

