/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.tools;

import java.util.Stack;
import org.apache.fop.render.rtf.rtflib.exceptions.RtfException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfOptions;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.tools.TableContext;

public class BuilderContext {
    private final Stack containers = new Stack();
    private final Stack tableContexts = new Stack();
    private final Stack builders = new Stack();
    private IRtfOptions options;

    public BuilderContext(IRtfOptions iRtfOptions) {
        this.options = iRtfOptions;
    }

    private Object getObjectFromStack(Stack stack, Class clazz) {
        Object var3_3 = null;
        Stack stack2 = (Stack)stack.clone();
        while (!stack2.isEmpty()) {
            Object e = stack2.pop();
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            var3_3 = e;
            break;
        }
        return var3_3;
    }

    public RtfContainer getContainer(Class clazz, boolean bl, Object object) throws RtfException {
        RtfContainer rtfContainer = (RtfContainer)this.getObjectFromStack(this.containers, clazz);
        if (rtfContainer == null && bl) {
            throw new RtfException("No RtfContainer of class '" + clazz.getName() + "' available for '" + object.getClass().getName() + "' builder");
        }
        return rtfContainer;
    }

    public void pushContainer(RtfContainer rtfContainer) {
        this.containers.push(rtfContainer);
    }

    public void replaceContainer(RtfContainer rtfContainer, RtfContainer rtfContainer2) throws Exception {
        int n = this.containers.indexOf(rtfContainer);
        if (n < 0) {
            throw new Exception("container to replace not found:" + rtfContainer);
        }
        this.containers.setElementAt(rtfContainer2, n);
    }

    public void popContainer() {
        this.containers.pop();
    }

    public TableContext getTableContext() {
        return (TableContext)this.tableContexts.peek();
    }

    public void pushTableContext(TableContext tableContext) {
        this.tableContexts.push(tableContext);
    }

    public void popTableContext() {
        this.tableContexts.pop();
    }
}

