/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.apps.FOPException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTableContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.ITableColumnsInfo;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableCell;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTableRow;

public class RtfTable
extends RtfContainer {
    private RtfTableRow row;
    private int highestRow = 0;
    private Boolean isNestedTable = null;
    private RtfAttributes borderAttributes = null;
    private ITableColumnsInfo tableContext;
    private int nestedTableDepth = 0;
    private RtfAttributes headerAttribs = null;

    RtfTable(IRtfTableContainer iRtfTableContainer, Writer writer, ITableColumnsInfo iTableColumnsInfo) throws IOException {
        super((RtfContainer)((Object)iRtfTableContainer), writer);
        this.tableContext = iTableColumnsInfo;
    }

    RtfTable(IRtfTableContainer iRtfTableContainer, Writer writer, RtfAttributes rtfAttributes, ITableColumnsInfo iTableColumnsInfo) throws IOException {
        super((RtfContainer)((Object)iRtfTableContainer), writer, rtfAttributes);
        this.tableContext = iTableColumnsInfo;
    }

    public RtfTableRow newTableRow() throws IOException {
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, this.attrib, this.highestRow);
        return this.row;
    }

    public RtfTableRow newTableRow(RtfAttributes rtfAttributes) throws IOException, FOPException {
        RtfAttributes rtfAttributes2 = null;
        if (this.attrib != null) {
            try {
                rtfAttributes2 = (RtfAttributes)this.attrib.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new FOPException(cloneNotSupportedException);
            }
            rtfAttributes2.set(rtfAttributes);
        } else {
            rtfAttributes2 = rtfAttributes;
        }
        if (this.row != null) {
            this.row.close();
        }
        ++this.highestRow;
        this.row = new RtfTableRow(this, this.writer, rtfAttributes2, this.highestRow);
        return this.row;
    }

    protected void writeRtfPrefix() throws IOException {
        if (this.isNestedTable()) {
            this.writeControlWordNS("pard");
        }
        this.writeGroupMark(true);
    }

    protected void writeRtfSuffix() throws IOException {
        this.writeGroupMark(false);
        if (this.isNestedTable()) {
            this.getRow().writeRowAndCellsDefintions();
        }
    }

    public boolean isHighestRow(int n) {
        return this.highestRow == n;
    }

    public ITableColumnsInfo getITableColumnsInfo() {
        return this.tableContext;
    }

    public void setHeaderAttribs(RtfAttributes rtfAttributes) {
        this.headerAttribs = rtfAttributes;
    }

    public RtfAttributes getHeaderAttribs() {
        return this.headerAttribs;
    }

    public RtfAttributes getRtfAttributes() {
        if (this.headerAttribs != null) {
            return this.headerAttribs;
        }
        return super.getRtfAttributes();
    }

    public boolean isNestedTable() {
        if (this.isNestedTable == null) {
            RtfContainer rtfContainer = this;
            while (rtfContainer.parent != null) {
                if (rtfContainer.parent instanceof RtfTableCell) {
                    this.isNestedTable = Boolean.TRUE;
                    return true;
                }
                rtfContainer = rtfContainer.parent;
            }
        } else {
            return this.isNestedTable;
        }
        this.isNestedTable = Boolean.FALSE;
        return false;
    }

    public RtfTableRow getRow() {
        RtfContainer rtfContainer = this;
        while (rtfContainer.parent != null) {
            if (rtfContainer.parent instanceof RtfTableRow) {
                return (RtfTableRow)rtfContainer.parent;
            }
            rtfContainer = rtfContainer.parent;
        }
        return null;
    }

    public void setNestedTableDepth(int n) {
        this.nestedTableDepth = n;
    }

    public int getNestedTableDepth() {
        return this.nestedTableDepth;
    }

    public void setBorderAttributes(RtfAttributes rtfAttributes) {
        this.borderAttributes = rtfAttributes;
    }

    public RtfAttributes getBorderAttributes() {
        return this.borderAttributes;
    }
}

