/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListItem;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListStyle;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfStringConverter;

public class RtfListStyleText
extends RtfListStyle {
    private String text;

    public RtfListStyleText(String string) {
        this.text = string;
    }

    public void writeListPrefix(RtfListItem rtfListItem) throws IOException {
        rtfListItem.writeControlWord("pnlvlblt");
        rtfListItem.writeControlWord("ilvl0");
        rtfListItem.writeOneAttribute("ls", new Integer(rtfListItem.getNumber()));
        rtfListItem.writeOneAttribute("pnindent", rtfListItem.getParentList().attrib.getValue("levelindent"));
        rtfListItem.writeControlWord("pnf1");
        rtfListItem.writeGroupMark(true);
        rtfListItem.writeOneAttribute("f", "2");
        rtfListItem.writeControlWord("pntxtb");
        RtfStringConverter.getInstance().writeRtfString(rtfListItem.writer, this.text);
        rtfListItem.writeGroupMark(false);
    }

    public void writeParagraphPrefix(RtfElement rtfElement) throws IOException {
        rtfElement.writeGroupMark(true);
        rtfElement.writeControlWord("pntext");
        rtfElement.writeGroupMark(false);
    }

    public void writeLevelGroup(RtfElement rtfElement) throws IOException {
        String string;
        rtfElement.attrib.set("levelnfc", 23);
        rtfElement.writeGroupMark(true);
        if (this.text.length() < 10) {
            string = "0" + String.valueOf(this.text.length());
        } else {
            string = String.valueOf(Integer.toHexString(this.text.length()));
            if (string.length() == 1) {
                string = "0" + string;
            }
        }
        rtfElement.writeOneAttributeNS("leveltext", "\\'" + string + RtfStringConverter.getInstance().escape(this.text));
        rtfElement.writeGroupMark(false);
        rtfElement.writeGroupMark(true);
        rtfElement.writeOneAttributeNS("levelnumbers", null);
        rtfElement.writeGroupMark(false);
        rtfElement.attrib.set("f", 2);
    }
}

