/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfListContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfParagraphContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.IRtfTextrunContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfList;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListStyle;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListStyleNumber;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfListStyleText;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfParagraph;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfTextrun;

public class RtfListItem
extends RtfContainer
implements IRtfTextrunContainer,
IRtfListContainer,
IRtfParagraphContainer {
    private RtfList parentList;
    private RtfParagraph paragraph;
    private RtfListStyle listStyle;
    private int number = 0;

    RtfListItem(RtfList rtfList, Writer writer) throws IOException {
        super(rtfList, writer);
        this.parentList = rtfList;
    }

    public RtfParagraph newParagraph(RtfAttributes rtfAttributes) throws IOException {
        if (this.paragraph != null) {
            this.paragraph.close();
        }
        this.paragraph = new RtfListItemParagraph(this, rtfAttributes);
        return this.paragraph;
    }

    public RtfParagraph newParagraph() throws IOException {
        return this.newParagraph(null);
    }

    RtfListItem(RtfList rtfList, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfList, writer, rtfAttributes);
        this.parentList = rtfList;
    }

    public RtfTextrun getTextrun() throws IOException {
        RtfTextrun rtfTextrun = RtfTextrun.getTextrun(this, this.writer, null);
        rtfTextrun.setRtfListItem(this);
        return rtfTextrun;
    }

    public RtfList newList(RtfAttributes rtfAttributes) throws IOException {
        RtfList rtfList = new RtfList(this, this.writer, rtfAttributes);
        return rtfList;
    }

    protected void writeRtfPrefix() throws IOException {
        if (!this.parentList.getHasTableParent()) {
            this.writeControlWord("pard");
        }
        this.writeOneAttribute("fi-", "360");
        this.writeOneAttribute("li", this.attrib.getValue("li"));
        this.writeGroupMark(true);
        this.writeStarControlWord("pn");
        this.getRtfListStyle().writeListPrefix(this);
        this.writeGroupMark(false);
        this.writeOneAttribute("ls", new Integer(this.number));
    }

    protected void writeRtfSuffix() throws IOException {
        super.writeRtfSuffix();
        if (!this.parentList.getHasTableParent()) {
            this.writeControlWord("pard");
        }
    }

    public void setRtfListStyle(RtfListStyle rtfListStyle) {
        this.listStyle = rtfListStyle;
        this.listStyle.setRtfListItem(this);
        this.number = this.getRtfFile().getListTable().addRtfListStyle(rtfListStyle);
    }

    public RtfListStyle getRtfListStyle() {
        if (this.listStyle == null) {
            return this.parentList.getRtfListStyle();
        }
        return this.listStyle;
    }

    public RtfList getParentList() {
        return this.parentList;
    }

    public int getNumber() {
        return this.number;
    }

    public class RtfListItemLabel
    extends RtfTextrun
    implements IRtfTextrunContainer {
        private RtfListItem rtfListItem;

        public RtfListItemLabel(RtfListItem rtfListItem2) throws IOException {
            super(null, rtfListItem2.writer, null);
            this.rtfListItem = rtfListItem2;
        }

        public RtfTextrun getTextrun() throws IOException {
            return this;
        }

        public void addString(String string) throws IOException {
            String string2 = string.trim();
            if (string2.length() > 0 && Character.isDigit(string2.charAt(0))) {
                this.rtfListItem.setRtfListStyle(new RtfListStyleNumber());
            } else {
                this.rtfListItem.setRtfListStyle(new RtfListStyleText(string2));
            }
        }
    }

    private class RtfListItemParagraph
    extends RtfParagraph {
        RtfListItemParagraph(RtfListItem rtfListItem2, RtfAttributes rtfAttributes) throws IOException {
            super(rtfListItem2, rtfListItem2.writer, rtfAttributes);
        }

        protected void writeRtfPrefix() throws IOException {
            super.writeRtfPrefix();
            RtfListItem.this.getRtfListStyle().writeParagraphPrefix(this);
        }
    }
}

