/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfHeader;

public final class RtfFontManager {
    private static RtfFontManager instance = null;
    private Hashtable fontIndex = null;
    private Vector fontTable = new Vector();

    private RtfFontManager() {
        this.fontIndex = new Hashtable();
        this.init();
    }

    public static RtfFontManager getInstance() {
        if (instance == null) {
            instance = new RtfFontManager();
        }
        return instance;
    }

    private void init() {
        this.getFontNumber("Arial");
        this.getFontNumber("Symbol");
        this.getFontNumber("Times New Roman");
    }

    public int getFontNumber(String string) {
        int n;
        Object v = this.fontIndex.get(this.getFontKey(string));
        if (v == null) {
            this.addFont(string);
            n = this.fontTable.size() - 1;
        } else {
            n = (Integer)v;
        }
        return n;
    }

    public void writeFonts(RtfHeader rtfHeader) throws IOException {
        if (this.fontTable == null || this.fontTable.size() == 0) {
            return;
        }
        rtfHeader.newLine();
        rtfHeader.writeGroupMark(true);
        rtfHeader.writeControlWord("fonttbl");
        int n = this.fontTable.size();
        for (int i = 0; i < n; ++i) {
            rtfHeader.writeGroupMark(true);
            rtfHeader.newLine();
            rtfHeader.write("\\f" + i);
            rtfHeader.write(" " + (String)this.fontTable.elementAt(i));
            rtfHeader.write(";");
            rtfHeader.writeGroupMark(false);
        }
        rtfHeader.newLine();
        rtfHeader.writeGroupMark(false);
    }

    private String getFontKey(String string) {
        return string.toLowerCase();
    }

    private void addFont(String string) {
        this.fontIndex.put(this.getFontKey(string), new Integer(this.fontTable.size()));
        this.fontTable.addElement(string);
    }
}

