/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfContainer;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfStringConverter;

public abstract class RtfElement {
    protected final Writer writer;
    protected final RtfContainer parent;
    protected final RtfAttributes attrib;
    private boolean written;
    private boolean closed;
    private final int id = idCounter++;
    private static int idCounter;

    RtfElement(RtfContainer rtfContainer, Writer writer) throws IOException {
        this(rtfContainer, writer, null);
    }

    RtfElement(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        this.parent = rtfContainer;
        RtfAttributes rtfAttributes2 = this.attrib = rtfAttributes != null ? rtfAttributes : new RtfAttributes();
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.writer = writer;
        this.written = false;
    }

    public final void close() throws IOException {
        this.closed = true;
    }

    public final void writeRtf() throws IOException {
        if (!this.written) {
            this.written = true;
            if (this.okToWriteRtf()) {
                this.writeRtfPrefix();
                this.writeRtfContent();
                this.writeRtfSuffix();
            }
        }
    }

    public void newLine() throws IOException {
        this.writer.write("\n");
    }

    protected final void writeControlWord(String string) throws IOException {
        this.writer.write(92);
        this.writer.write(string);
        this.writer.write(32);
    }

    protected final void writeStarControlWord(String string) throws IOException {
        this.writer.write("\\*\\");
        this.writer.write(string);
        this.writer.write(32);
    }

    protected final void writeStarControlWordNS(String string) throws IOException {
        this.writer.write("\\*\\");
        this.writer.write(string);
    }

    protected final void writeControlWordNS(String string) throws IOException {
        this.writer.write(92);
        this.writer.write(string);
    }

    protected void writeRtfPrefix() throws IOException {
    }

    protected abstract void writeRtfContent() throws IOException;

    protected void writeRtfSuffix() throws IOException {
    }

    protected final void writeGroupMark(boolean bl) throws IOException {
        this.writer.write(bl ? "{" : "}");
    }

    protected void writeAttributes(RtfAttributes rtfAttributes, String[] stringArray) throws IOException {
        if (rtfAttributes == null) {
            return;
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!rtfAttributes.isSet(string)) continue;
                this.writeOneAttribute(string, rtfAttributes.getValue(string));
            }
        } else {
            Iterator iterator = rtfAttributes.nameIterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!rtfAttributes.isSet(string)) continue;
                this.writeOneAttribute(string, rtfAttributes.getValue(string));
            }
        }
    }

    protected void writeOneAttribute(String string, Object object) throws IOException {
        String string2 = string;
        if (object instanceof Integer) {
            string2 = string2 + object;
        } else if (object instanceof String) {
            string2 = string2 + object;
        } else if (object instanceof RtfAttributes) {
            this.writeControlWord(string2);
            this.writeAttributes((RtfAttributes)object, null);
            return;
        }
        this.writeControlWord(string2);
    }

    protected void writeOneAttributeNS(String string, Object object) throws IOException {
        String string2 = string;
        if (object instanceof Integer) {
            string2 = string2 + object;
        } else if (object instanceof String) {
            string2 = string2 + object;
        } else if (object instanceof RtfAttributes) {
            this.writeControlWord(string2);
            this.writeAttributes((RtfAttributes)object, null);
            return;
        }
        this.writeControlWordNS(string2);
    }

    protected boolean okToWriteRtf() {
        return true;
    }

    void dump(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(32);
        }
        writer.write(this.toString());
        writer.write(10);
        writer.flush();
    }

    public String toString() {
        return this == null ? "null" : this.getClass().getName() + " #" + this.id;
    }

    boolean isClosed() {
        return this.closed;
    }

    RtfFile getRtfFile() {
        RtfElement rtfElement = this;
        while (rtfElement.parent != null) {
            rtfElement = rtfElement.parent;
        }
        return (RtfFile)rtfElement;
    }

    public RtfElement getParentOfClass(Class clazz) {
        RtfElement rtfElement = null;
        RtfElement rtfElement2 = this;
        while (rtfElement2.parent != null) {
            rtfElement2 = rtfElement2.parent;
            if (!clazz.isAssignableFrom(rtfElement2.getClass())) continue;
            rtfElement = rtfElement2;
            break;
        }
        return rtfElement;
    }

    public abstract boolean isEmpty();

    protected void writeExceptionInRtf(Exception exception) throws IOException {
        this.writeGroupMark(true);
        this.writeControlWord("par");
        this.writeControlWord("fs48");
        RtfStringConverter.getInstance().writeRtfString(this.writer, exception.getClass().getName());
        this.writeControlWord("fs20");
        RtfStringConverter.getInstance().writeRtfString(this.writer, " " + exception.toString());
        this.writeControlWord("par");
        this.writeGroupMark(false);
    }

    public RtfAttributes getRtfAttributes() {
        return this.attrib;
    }
}

