/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf;

import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.render.rtf.FOPRtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;

public final class BorderAttributesConverter {
    private BorderAttributesConverter() {
    }

    public static void makeBorder(CommonBorderPaddingBackground commonBorderPaddingBackground, int n, RtfAttributes rtfAttributes, String string) {
        int n2 = commonBorderPaddingBackground.getBorderStyle(n);
        if (n2 != 95) {
            FOPRtfAttributes fOPRtfAttributes = new FOPRtfAttributes();
            fOPRtfAttributes.set("brdrcf", commonBorderPaddingBackground.getBorderColor(n));
            fOPRtfAttributes.set(BorderAttributesConverter.convertAttributetoRtf(n2));
            fOPRtfAttributes.set("brdrw", commonBorderPaddingBackground.getBorderWidth(n, false) / 50);
            rtfAttributes.set(string, fOPRtfAttributes);
        } else {
            double d = (double)commonBorderPaddingBackground.getPadding(n, false, null) / 1000.0;
            int n3 = (int)Math.round(d * 20.0);
            if (n3 != 0) {
                if (n == 0) {
                    rtfAttributes.addIntegerValue(n3, "sb");
                } else if (n == 1) {
                    rtfAttributes.addIntegerValue(n3, "sa");
                }
            }
        }
    }

    public static String convertAttributetoRtf(int n) {
        if (n == 95) {
            return "brdrnil";
        }
        if (n == 133) {
            return "brdrs";
        }
        if (n == 37) {
            return "brdrdb";
        }
        if (n == 36) {
            return "brdrdot";
        }
        if (n == 31) {
            return "brdrdash";
        }
        if (n == 55) {
            return "brdrengrave";
        }
        if (n == 119) {
            return "brdremboss";
        }
        if (n == 67) {
            return "brdrengrave";
        }
        if (n == 101) {
            return "brdremboss";
        }
        return "brdrs";
    }
}

