/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps.fonts;

import java.io.IOException;
import org.apache.fop.fonts.truetype.TTFGlyphOutputStream;
import org.apache.fop.render.ps.fonts.PSTTFGenerator;

public class PSTTFGlyphOutputStream
implements TTFGlyphOutputStream {
    private int byteCounter;
    private int lastStringBoundary;
    private PSTTFGenerator ttfGen;

    public PSTTFGlyphOutputStream(PSTTFGenerator pSTTFGenerator) {
        this.ttfGen = pSTTFGenerator;
    }

    public void startGlyphStream() throws IOException {
        this.ttfGen.startString();
    }

    public void streamGlyph(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 32764) {
            throw new UnsupportedOperationException("The glyph is " + n2 + " bytes. There may be an error in the font file.");
        }
        if (n2 + (this.byteCounter - this.lastStringBoundary) < 32764) {
            this.ttfGen.streamBytes(byArray, n, n2);
        } else {
            this.ttfGen.endString();
            this.lastStringBoundary = this.byteCounter;
            this.ttfGen.startString();
            this.ttfGen.streamBytes(byArray, n, n2);
        }
        this.byteCounter += n2;
    }

    public void endGlyphStream() throws IOException {
        this.ttfGen.endString();
    }
}

