/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.ps.extensions.PSCommentAfter;
import org.apache.fop.render.ps.extensions.PSCommentBefore;
import org.apache.fop.render.ps.extensions.PSExtensionAttachment;
import org.apache.fop.render.ps.extensions.PSPageTrailerCodeBefore;
import org.apache.fop.render.ps.extensions.PSSetPageDevice;
import org.apache.fop.render.ps.extensions.PSSetupCode;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PSExtensionHandler
extends DefaultHandler
implements ContentHandlerFactory.ObjectSource {
    protected static final Log log = LogFactory.getLog(PSExtensionHandler.class);
    private StringBuffer content = new StringBuffer();
    private Attributes lastAttributes;
    private PSExtensionAttachment returnedObject;
    private ContentHandlerFactory.ObjectBuiltListener listener;

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        if ("apache:fop:extensions:postscript".equals(string)) {
            this.lastAttributes = new AttributesImpl(attributes);
            bl = false;
            if (string2.equals("ps-setup-code") || string2.equals("ps-page-trailer-code-before") || string2.equals("ps-setpagedevice") || string2.equals("ps-comment-before") || string2.equals("ps-comment-after")) {
                bl = true;
            }
        }
        if (!bl) {
            if ("apache:fop:extensions:postscript".equals(string)) {
                throw new SAXException("Unhandled element " + string2 + " in namespace: " + string);
            }
            log.warn((Object)("Unhandled element " + string2 + " in namespace: " + string));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("apache:fop:extensions:postscript".equals(string)) {
            if ("ps-setup-code".equals(string2)) {
                String string4 = this.lastAttributes.getValue("name");
                this.returnedObject = new PSSetupCode(string4, this.content.toString());
            } else if ("ps-setpagedevice".equals(string2)) {
                String string5 = this.lastAttributes.getValue("name");
                this.returnedObject = new PSSetPageDevice(string5, this.content.toString());
            } else if ("ps-comment-before".equals(string2)) {
                this.returnedObject = new PSCommentBefore(this.content.toString());
            } else if ("ps-comment-after".equals(string2)) {
                this.returnedObject = new PSCommentAfter(this.content.toString());
            } else if ("ps-page-trailer-code-before".equals(string2)) {
                this.returnedObject = new PSPageTrailerCodeBefore(this.content.toString());
            }
        }
        this.content.setLength(0);
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.content.append(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        if (this.listener != null) {
            this.listener.notifyObjectBuilt(this.getObject());
        }
    }

    public Object getObject() {
        return this.returnedObject;
    }

    public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener objectBuiltListener) {
        this.listener = objectBuiltListener;
    }
}

