/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.ResourceEventProducer;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.ImageHandlerRegistry;
import org.apache.fop.render.ps.PSEventProducer;
import org.apache.fop.render.ps.PSFontUtils;
import org.apache.fop.render.ps.PSImageFormResource;
import org.apache.fop.render.ps.PSImageHandler;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.fop.render.ps.PSSupportedFlavors;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageException;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageManager;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.ps.FormGenerator;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.DSCException;
import org.apache.xmlgraphics.ps.dsc.DSCFilter;
import org.apache.xmlgraphics.ps.dsc.DSCListener;
import org.apache.xmlgraphics.ps.dsc.DSCParser;
import org.apache.xmlgraphics.ps.dsc.DSCParserConstants;
import org.apache.xmlgraphics.ps.dsc.DefaultNestedDocumentHandler;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentBoundingBox;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentNeededResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentDocumentSuppliedResources;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentHiResBoundingBox;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentIncludeResource;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentLanguageLevel;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPage;
import org.apache.xmlgraphics.ps.dsc.events.DSCCommentPages;
import org.apache.xmlgraphics.ps.dsc.events.DSCEvent;
import org.apache.xmlgraphics.ps.dsc.events.DSCHeaderComment;
import org.apache.xmlgraphics.ps.dsc.events.PostScriptLine;
import org.apache.xmlgraphics.ps.dsc.tools.DSCTools;

public class ResourceHandler
implements DSCParserConstants,
PSSupportedFlavors {
    private static Log log = LogFactory.getLog(ResourceHandler.class);
    private FOUserAgent userAgent;
    private FontInfo fontInfo;
    private PSEventProducer eventProducer;
    private ResourceTracker resTracker;
    private Map globalFormResources = new HashMap();
    private Map inlineFormResources = new HashMap();

    public ResourceHandler(FOUserAgent fOUserAgent, PSEventProducer pSEventProducer, FontInfo fontInfo, ResourceTracker resourceTracker, Map map) {
        this.userAgent = fOUserAgent;
        this.eventProducer = pSEventProducer;
        this.fontInfo = fontInfo;
        this.resTracker = resourceTracker;
        this.determineInlineForms(map);
    }

    private void determineInlineForms(Map map) {
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            PSResource pSResource = (PSResource)entry.getValue();
            long l = this.resTracker.getUsageCount(pSResource);
            if (l > 1L) {
                this.globalFormResources.put(entry.getKey(), pSResource);
                continue;
            }
            this.inlineFormResources.put(pSResource, pSResource);
            this.resTracker.declareInlined(pSResource);
        }
    }

    public void process(InputStream inputStream, OutputStream outputStream, int n, Rectangle2D rectangle2D) throws DSCException, IOException {
        DSCCommentLanguageLevel dSCCommentLanguageLevel;
        DSCCommentPages dSCCommentPages;
        DSCEvent dSCEvent;
        DSCParser dSCParser = new DSCParser(inputStream);
        PSGenerator pSGenerator = new PSGenerator(outputStream);
        dSCParser.addListener((DSCListener)new DefaultNestedDocumentHandler(pSGenerator));
        dSCParser.addListener((DSCListener)new IncludeResourceListener(pSGenerator));
        DSCHeaderComment dSCHeaderComment = DSCTools.checkAndSkipDSC30Header((DSCParser)dSCParser);
        dSCHeaderComment.generate(pSGenerator);
        dSCParser.setFilter(new DSCFilter(){
            private final Set filtered = new HashSet();
            {
                this.filtered.add("Pages");
                this.filtered.add("BoundingBox");
                this.filtered.add("HiResBoundingBox");
                this.filtered.add("DocumentNeededResources");
                this.filtered.add("DocumentSuppliedResources");
            }

            public boolean accept(DSCEvent dSCEvent) {
                if (dSCEvent.isDSCComment()) {
                    return !this.filtered.contains(dSCEvent.asDSCComment().getName());
                }
                return true;
            }
        });
        while (true) {
            if ((dSCEvent = dSCParser.nextEvent()) == null) {
                ResourceHandler.reportInvalidDSC();
            }
            if (DSCTools.headerCommentsEndHere((DSCEvent)dSCEvent)) break;
            if (dSCEvent.isDSCComment() && "LanguageLevel".equals((dSCCommentPages = dSCEvent.asDSCComment()).getName())) {
                dSCCommentLanguageLevel = (DSCCommentLanguageLevel)dSCCommentPages;
                pSGenerator.setPSLevel(dSCCommentLanguageLevel.getLanguageLevel());
            }
            dSCEvent.generate(pSGenerator);
        }
        dSCCommentPages = new DSCCommentPages(n);
        dSCCommentPages.generate(pSGenerator);
        new DSCCommentBoundingBox(rectangle2D).generate(pSGenerator);
        new DSCCommentHiResBoundingBox(rectangle2D).generate(pSGenerator);
        PSFontUtils.determineSuppliedFonts(this.resTracker, this.fontInfo, this.fontInfo.getUsedFonts());
        ResourceHandler.registerSuppliedForms(this.resTracker, this.globalFormResources);
        dSCCommentLanguageLevel = new DSCCommentDocumentSuppliedResources((Collection)this.resTracker.getDocumentSuppliedResources());
        dSCCommentLanguageLevel.generate(pSGenerator);
        DSCCommentDocumentNeededResources dSCCommentDocumentNeededResources = new DSCCommentDocumentNeededResources((Collection)this.resTracker.getDocumentNeededResources());
        dSCCommentDocumentNeededResources.generate(pSGenerator);
        dSCEvent.generate(pSGenerator);
        dSCEvent = dSCParser.nextPSComment("FOPFontSetup", pSGenerator);
        if (dSCEvent == null) {
            throw new DSCException("Didn't find %FOPFontSetup comment in stream");
        }
        PSFontUtils.writeFontDict(pSGenerator, this.fontInfo, this.fontInfo.getUsedFonts(), this.eventProducer);
        this.generateForms(this.globalFormResources, pSGenerator);
        dSCCommentPages = dSCParser.nextDSCComment("Page", pSGenerator);
        if (dSCCommentPages == null) {
            throw new DSCException("Page expected, but none found");
        }
        while (true) {
            dSCCommentLanguageLevel = (DSCCommentPage)dSCCommentPages;
            dSCCommentLanguageLevel.generate(pSGenerator);
            dSCCommentPages = DSCTools.nextPageOrTrailer((DSCParser)dSCParser, (PSGenerator)pSGenerator);
            if (dSCCommentPages == null) {
                ResourceHandler.reportInvalidDSC();
                continue;
            }
            if (!"Page".equals(dSCCommentPages.getName())) break;
        }
        dSCCommentPages.generate(pSGenerator);
        while (dSCParser.hasNext()) {
            dSCCommentLanguageLevel = dSCParser.nextEvent();
            dSCCommentLanguageLevel.generate(pSGenerator);
        }
        pSGenerator.flush();
    }

    private static void reportInvalidDSC() throws DSCException {
        throw new DSCException("File is not DSC-compliant: Unexpected end of file");
    }

    private static void registerSuppliedForms(ResourceTracker resourceTracker, Map map) throws IOException {
        if (map == null) {
            return;
        }
        for (PSImageFormResource pSImageFormResource : map.values()) {
            resourceTracker.registerSuppliedResource((PSResource)pSImageFormResource);
        }
    }

    private void generateForms(Map map, PSGenerator pSGenerator) throws IOException {
        if (map == null) {
            return;
        }
        for (PSImageFormResource pSImageFormResource : map.values()) {
            this.generateFormForImage(pSGenerator, pSImageFormResource);
        }
    }

    private void generateFormForImage(PSGenerator pSGenerator, PSImageFormResource pSImageFormResource) throws IOException {
        String string = pSImageFormResource.getImageURI();
        ImageManager imageManager = this.userAgent.getFactory().getImageManager();
        ImageInfo imageInfo = null;
        try {
            ImageSessionContext imageSessionContext = this.userAgent.getImageSessionContext();
            imageInfo = imageManager.getImageInfo(string, imageSessionContext);
            PSRenderingContext pSRenderingContext = new PSRenderingContext(this.userAgent, pSGenerator, this.fontInfo, true);
            ImageHandlerRegistry imageHandlerRegistry = this.userAgent.getFactory().getImageHandlerRegistry();
            ImageFlavor[] imageFlavorArray = imageHandlerRegistry.getSupportedFlavors(pSRenderingContext);
            Map map = ImageUtil.getDefaultHints((ImageSessionContext)imageSessionContext);
            Image image = imageManager.getImage(imageInfo, imageFlavorArray, map, imageSessionContext);
            ImageHandler imageHandler = imageHandlerRegistry.getHandler(pSRenderingContext, image);
            if (imageHandler == null) {
                throw new UnsupportedOperationException("No ImageHandler available for image: " + image.getInfo() + " (" + image.getClass().getName() + ")");
            }
            if (!(imageHandler instanceof PSImageHandler)) {
                throw new IllegalStateException("ImageHandler implementation doesn't behave properly. It should have returned false in isCompatible(). Class: " + imageHandler.getClass().getName());
            }
            PSImageHandler pSImageHandler = (PSImageHandler)imageHandler;
            if (log.isTraceEnabled()) {
                log.trace((Object)("Using ImageHandler: " + pSImageHandler.getClass().getName()));
            }
            pSImageHandler.generateForm(pSRenderingContext, image, pSImageFormResource);
        }
        catch (ImageException imageException) {
            ResourceEventProducer resourceEventProducer = ResourceEventProducer.Provider.get(this.userAgent.getEventBroadcaster());
            resourceEventProducer.imageError(this.resTracker, imageInfo != null ? imageInfo.toString() : string, imageException, null);
        }
    }

    private static FormGenerator createMissingForm(String string, final Dimension2D dimension2D) {
        FormGenerator formGenerator = new FormGenerator(string, null, dimension2D){

            protected void generatePaintProc(PSGenerator pSGenerator) throws IOException {
                pSGenerator.writeln("0 setgray");
                pSGenerator.writeln("0 setlinewidth");
                String string = pSGenerator.formatDouble(dimension2D.getWidth());
                String string2 = pSGenerator.formatDouble(dimension2D.getHeight());
                pSGenerator.writeln(string + " " + string2 + " scale");
                pSGenerator.writeln("0 0 1 1 rectstroke");
                pSGenerator.writeln("newpath");
                pSGenerator.writeln("0 0 moveto");
                pSGenerator.writeln("1 1 lineto");
                pSGenerator.writeln("stroke");
                pSGenerator.writeln("newpath");
                pSGenerator.writeln("0 1 moveto");
                pSGenerator.writeln("1 0 lineto");
                pSGenerator.writeln("stroke");
            }
        };
        return formGenerator;
    }

    private class IncludeResourceListener
    implements DSCListener {
        private PSGenerator gen;

        public IncludeResourceListener(PSGenerator pSGenerator) {
            this.gen = pSGenerator;
        }

        public void processEvent(DSCEvent dSCEvent, DSCParser dSCParser) throws IOException, DSCException {
            DSCCommentIncludeResource dSCCommentIncludeResource;
            PSResource pSResource;
            if (dSCEvent.isDSCComment() && dSCEvent instanceof DSCCommentIncludeResource && (pSResource = (dSCCommentIncludeResource = (DSCCommentIncludeResource)dSCEvent).getResource()).getType().equals("form")) {
                if (ResourceHandler.this.inlineFormResources.containsValue(pSResource)) {
                    PostScriptLine postScriptLine;
                    PSImageFormResource pSImageFormResource = (PSImageFormResource)((Object)ResourceHandler.this.inlineFormResources.get(pSResource));
                    this.gen.writeln("save");
                    ResourceHandler.this.generateFormForImage(this.gen, pSImageFormResource);
                    boolean bl = false;
                    DSCEvent dSCEvent2 = dSCParser.nextEvent();
                    if (dSCEvent2.isLine() && (postScriptLine = dSCEvent2.asLine()).getLine().endsWith(" execform")) {
                        postScriptLine.generate(this.gen);
                        bl = true;
                    }
                    if (!bl) {
                        throw new IOException("Expected a PostScript line in the form: <form> execform");
                    }
                    this.gen.writeln("restore");
                }
                dSCParser.next();
            }
        }
    }
}

