/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.ps.PSConfigurationConstants;
import org.apache.fop.render.ps.PSRenderingMode;
import org.apache.fop.render.ps.extensions.PSCommentAfter;
import org.apache.fop.render.ps.extensions.PSCommentBefore;
import org.apache.fop.render.ps.extensions.PSExtensionAttachment;
import org.apache.fop.render.ps.extensions.PSSetupCode;
import org.apache.xmlgraphics.ps.PSGenerator;

public class PSRenderingUtil
implements PSConfigurationConstants {
    private FOUserAgent userAgent;
    private boolean safeSetPageDevice = false;
    private boolean dscCompliant = true;
    private boolean autoRotateLandscape = false;
    private int languageLevel = 3;
    private boolean optimizeResources = false;
    private PSRenderingMode renderingMode = PSRenderingMode.QUALITY;

    PSRenderingUtil(FOUserAgent fOUserAgent) {
        this.userAgent = fOUserAgent;
        this.initialize();
    }

    private void initialize() {
        Object v = this.userAgent.getRendererOptions().get("auto-rotate-landscape");
        if (v != null) {
            this.setAutoRotateLandscape(this.booleanValueOf(v));
        }
        if ((v = this.userAgent.getRendererOptions().get("language-level")) != null) {
            this.setLanguageLevel(this.intValueOf(v));
        }
        if ((v = this.userAgent.getRendererOptions().get("optimize-resources")) != null) {
            this.setOptimizeResources(this.booleanValueOf(v));
        }
    }

    private boolean booleanValueOf(Object object) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        throw new IllegalArgumentException("Boolean or \"true\" or \"false\" expected.");
    }

    private int intValueOf(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException("Integer or String with a number expected.");
    }

    public static void writeSetupCodeList(PSGenerator pSGenerator, List list, String string) throws IOException {
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2;
                PSSetupCode pSSetupCode = (PSSetupCode)iterator.next();
                pSGenerator.commentln("%FOPBegin" + string + ": (" + (pSSetupCode.getName() != null ? pSSetupCode.getName() : "") + ")");
                LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(pSSetupCode.getContent()));
                while ((string2 = lineNumberReader.readLine()) != null) {
                    if ((string2 = string2.trim()).length() <= 0) continue;
                    pSGenerator.writeln(string2.trim());
                }
                pSGenerator.commentln("%FOPEnd" + string);
                iterator.remove();
            }
        }
    }

    public static void writeEnclosedExtensionAttachments(PSGenerator pSGenerator, Collection collection) throws IOException {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PSExtensionAttachment pSExtensionAttachment = (PSExtensionAttachment)iterator.next();
            if (pSExtensionAttachment != null) {
                PSRenderingUtil.writeEnclosedExtensionAttachment(pSGenerator, pSExtensionAttachment);
            }
            iterator.remove();
        }
    }

    public static void writeEnclosedExtensionAttachment(PSGenerator pSGenerator, PSExtensionAttachment pSExtensionAttachment) throws IOException {
        if (pSExtensionAttachment instanceof PSCommentBefore) {
            pSGenerator.commentln("%" + pSExtensionAttachment.getContent());
        } else if (pSExtensionAttachment instanceof PSCommentAfter) {
            pSGenerator.commentln("%" + pSExtensionAttachment.getContent());
        } else {
            String string;
            Object object;
            Object object2;
            String string2 = "";
            if (pSExtensionAttachment instanceof PSSetupCode && (object2 = ((PSSetupCode)(object = (PSSetupCode)pSExtensionAttachment)).getName()) != null) {
                string2 = string2 + ": (" + (String)object2 + ")";
            }
            object = pSExtensionAttachment.getType();
            pSGenerator.commentln("%FOPBegin" + (String)object + string2);
            object2 = new LineNumberReader(new StringReader(pSExtensionAttachment.getContent()));
            while ((string = ((LineNumberReader)object2).readLine()) != null) {
                if ((string = string.trim()).length() <= 0) continue;
                pSGenerator.writeln(string);
            }
            pSGenerator.commentln("%FOPEnd" + (String)object);
        }
    }

    public void setSafeSetPageDevice(boolean bl) {
        this.safeSetPageDevice = bl;
    }

    public boolean isSafeSetPageDevice() {
        return this.safeSetPageDevice;
    }

    public void setDSCComplianceEnabled(boolean bl) {
        this.dscCompliant = bl;
    }

    public boolean isDSCComplianceEnabled() {
        return this.dscCompliant;
    }

    public void setAutoRotateLandscape(boolean bl) {
        this.autoRotateLandscape = bl;
    }

    public boolean isAutoRotateLandscape() {
        return this.autoRotateLandscape;
    }

    public void setLanguageLevel(int n) {
        if (n != 2 && n != 3) {
            throw new IllegalArgumentException("Only language levels 2 or 3 are allowed/supported");
        }
        this.languageLevel = n;
    }

    public int getLanguageLevel() {
        return this.languageLevel;
    }

    public void setOptimizeResources(boolean bl) {
        this.optimizeResources = bl;
    }

    public boolean isOptimizeResources() {
        return this.optimizeResources;
    }

    public void setRenderingMode(PSRenderingMode pSRenderingMode) {
        this.renderingMode = pSRenderingMode;
    }

    public PSRenderingMode getRenderingMode() {
        return this.renderingMode;
    }
}

