/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.ps.PSRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageRawEPS;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSImageUtils;

public class PSImageHandlerEPS
implements ImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_EPS};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
        PSGenerator pSGenerator = pSRenderingContext.getGenerator();
        ImageRawEPS imageRawEPS = (ImageRawEPS)image;
        float f = (float)rectangle.getX() / 1000.0f;
        float f2 = (float)rectangle.getY() / 1000.0f;
        float f3 = (float)rectangle.getWidth() / 1000.0f;
        float f4 = (float)rectangle.getHeight() / 1000.0f;
        ImageInfo imageInfo = image.getInfo();
        Rectangle2D rectangle2D = imageRawEPS.getBoundingBox();
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Double();
            rectangle2D.setFrame(new Point2D.Double(), imageInfo.getSize().getDimensionPt());
        }
        InputStream inputStream = imageRawEPS.createInputStream();
        try {
            String string = imageInfo.getOriginalURI();
            if (string == null) {
                string = "inline image";
            }
            PSImageUtils.renderEPS((InputStream)inputStream, (String)string, (Rectangle2D)new Rectangle2D.Float(f, f2, f3, f4), (Rectangle2D)rectangle2D, (PSGenerator)pSGenerator);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageRawEPS.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        if (renderingContext instanceof PSRenderingContext) {
            PSRenderingContext pSRenderingContext = (PSRenderingContext)renderingContext;
            return !pSRenderingContext.isCreateForms() && (image == null || image instanceof ImageRawEPS);
        }
        return false;
    }
}

