/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Base14Font;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CIDSubset;
import org.apache.fop.fonts.CMapSegment;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbeddingMode;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SimpleSingleByteEncoding;
import org.apache.fop.fonts.SingleByteEncoding;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFFile;
import org.apache.fop.fonts.truetype.TTFSubSetFile;
import org.apache.fop.render.ps.PSEventProducer;
import org.apache.fop.render.ps.PSFontResource;
import org.apache.fop.render.ps.fonts.PSTTFOutputStream;
import org.apache.fop.util.HexEncoder;
import org.apache.xmlgraphics.fonts.Glyphs;
import org.apache.xmlgraphics.ps.PSGenerator;
import org.apache.xmlgraphics.ps.PSResource;
import org.apache.xmlgraphics.ps.dsc.ResourceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSFontUtils
extends org.apache.xmlgraphics.ps.PSFontUtils {
    protected static final Log log = LogFactory.getLog(PSFontUtils.class);

    public static Map writeFontDict(PSGenerator pSGenerator, FontInfo fontInfo) throws IOException {
        return PSFontUtils.writeFontDict(pSGenerator, fontInfo, null);
    }

    public static Map writeFontDict(PSGenerator pSGenerator, FontInfo fontInfo, PSEventProducer pSEventProducer) throws IOException {
        return PSFontUtils.writeFontDict(pSGenerator, fontInfo, fontInfo.getFonts(), true, pSEventProducer);
    }

    public static Map writeFontDict(PSGenerator pSGenerator, FontInfo fontInfo, Map<String, Typeface> map, PSEventProducer pSEventProducer) throws IOException {
        return PSFontUtils.writeFontDict(pSGenerator, fontInfo, map, false, pSEventProducer);
    }

    private static Map writeFontDict(PSGenerator pSGenerator, FontInfo fontInfo, Map<String, Typeface> map, boolean bl, PSEventProducer pSEventProducer) throws IOException {
        pSGenerator.commentln("%FOPBeginFontDict");
        HashMap<String, PSFontResource> hashMap = new HashMap<String, PSFontResource>();
        for (String string : map.keySet()) {
            Typeface typeface = PSFontUtils.getTypeFace(fontInfo, map, string);
            PSResource pSResource = new PSResource("font", typeface.getEmbedFontName());
            PSFontResource pSFontResource = PSFontUtils.embedFont(pSGenerator, typeface, pSResource, pSEventProducer);
            hashMap.put(string, pSFontResource);
            if (!(typeface instanceof SingleByteFont)) continue;
            SingleByteFont singleByteFont = (SingleByteFont)typeface;
            if (bl) {
                singleByteFont.encodeAllUnencodedCharacters();
            }
            int n = singleByteFont.getAdditionalEncodingCount();
            for (int i = 0; i < n; ++i) {
                SimpleSingleByteEncoding simpleSingleByteEncoding = singleByteFont.getAdditionalEncoding(i);
                PSFontUtils.defineEncoding(pSGenerator, simpleSingleByteEncoding);
                String string2 = "_" + (i + 1);
                PSResource pSResource2 = typeface.getFontType() == FontType.TRUETYPE && singleByteFont.getTrueTypePostScriptVersion() != TTFFile.PostScriptVersion.V2 ? PSFontUtils.defineDerivedTrueTypeFont(pSGenerator, pSEventProducer, typeface.getEmbedFontName(), typeface.getEmbedFontName() + string2, simpleSingleByteEncoding, singleByteFont.getCMap()) : PSFontUtils.defineDerivedFont(pSGenerator, typeface.getEmbedFontName(), typeface.getEmbedFontName() + string2, simpleSingleByteEncoding.getName());
                hashMap.put(string + string2, PSFontResource.createFontResource(pSResource2));
            }
        }
        pSGenerator.commentln("%FOPEndFontDict");
        PSFontUtils.reencodeFonts(pSGenerator, map);
        return hashMap;
    }

    private static void reencodeFonts(PSGenerator pSGenerator, Map<String, Typeface> map) throws IOException {
        ResourceTracker resourceTracker = pSGenerator.getResourceTracker();
        if (!resourceTracker.isResourceSupplied(WINANSI_ENCODING_RESOURCE)) {
            PSFontUtils.defineWinAnsiEncoding((PSGenerator)pSGenerator);
        }
        pSGenerator.commentln("%FOPBeginFontReencode");
        for (String string : map.keySet()) {
            SingleByteFont singleByteFont;
            Typeface typeface = map.get(string);
            if (typeface instanceof LazyFont && (typeface = ((LazyFont)typeface).getRealFont()) == null || null == typeface.getEncodingName() || "SymbolEncoding".equals(typeface.getEncodingName()) || "ZapfDingbatsEncoding".equals(typeface.getEncodingName())) continue;
            if (typeface instanceof Base14Font) {
                PSFontUtils.redefineFontEncoding((PSGenerator)pSGenerator, (String)typeface.getEmbedFontName(), (String)typeface.getEncodingName());
                continue;
            }
            if (!(typeface instanceof SingleByteFont) || (singleByteFont = (SingleByteFont)typeface).isUsingNativeEncoding()) continue;
            PSFontUtils.redefineFontEncoding((PSGenerator)pSGenerator, (String)typeface.getEmbedFontName(), (String)typeface.getEncodingName());
        }
        pSGenerator.commentln("%FOPEndFontReencode");
    }

    private static Typeface getTypeFace(FontInfo fontInfo, Map<String, Typeface> map, String string) {
        Typeface typeface = map.get(string);
        if (typeface instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        if (typeface == null) {
            String string2 = fontInfo.getInternalFontKey(Font.DEFAULT_FONT);
            typeface = map.get(string2);
        }
        return typeface;
    }

    private static PSFontResource embedFont(PSGenerator pSGenerator, Typeface typeface, PSResource pSResource, PSEventProducer pSEventProducer) throws IOException {
        FontType fontType = typeface.getFontType();
        PSFontResource pSFontResource = null;
        if (fontType != FontType.TYPE1 && fontType != FontType.TRUETYPE && fontType != FontType.TYPE0 || !(typeface instanceof CustomFont)) {
            pSGenerator.writeDSCComment("IncludeResource", (Object)pSResource);
            pSFontResource = PSFontResource.createFontResource(pSResource);
            return pSFontResource;
        }
        CustomFont customFont = (CustomFont)typeface;
        if (PSFontUtils.isEmbeddable(customFont)) {
            InputStream inputStream = PSFontUtils.getInputStreamOnFont(pSGenerator, customFont);
            if (inputStream == null) {
                pSGenerator.commentln("%WARNING: Could not embed font: " + customFont.getEmbedFontName());
                log.warn((Object)("Font " + customFont.getEmbedFontName() + " is marked as supplied in the" + " PostScript file but could not be embedded!"));
                pSGenerator.writeDSCComment("IncludeResource", (Object)pSResource);
                pSFontResource = PSFontResource.createFontResource(pSResource);
                return pSFontResource;
            }
            if (fontType == FontType.TYPE0) {
                if (pSGenerator.embedIdentityH()) {
                    PSFontUtils.checkPostScriptLevel3(pSGenerator, pSEventProducer);
                    pSGenerator.includeProcsetCIDInitResource();
                }
                PSResource pSResource2 = PSFontUtils.embedType2CIDFont(pSGenerator, (MultiByteFont)typeface, inputStream);
                pSFontResource = PSFontResource.createFontResource(pSResource, pSGenerator.getProcsetCIDInitResource(), pSGenerator.getIdentityHCMapResource(), pSResource2);
            }
            pSGenerator.writeDSCComment("BeginResource", (Object)pSResource);
            if (fontType == FontType.TYPE1) {
                PSFontUtils.embedType1Font((PSGenerator)pSGenerator, (InputStream)inputStream);
                pSFontResource = PSFontResource.createFontResource(pSResource);
            } else if (fontType == FontType.TRUETYPE) {
                PSFontUtils.embedTrueTypeFont(pSGenerator, (SingleByteFont)typeface, inputStream);
                pSFontResource = PSFontResource.createFontResource(pSResource);
            } else {
                PSFontUtils.composeType0Font(pSGenerator, (MultiByteFont)typeface, inputStream);
            }
            pSGenerator.writeDSCComment("EndResource");
            pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        }
        return pSFontResource;
    }

    private static void checkPostScriptLevel3(PSGenerator pSGenerator, PSEventProducer pSEventProducer) {
        if (pSGenerator.getPSLevel() < 3) {
            if (pSEventProducer != null) {
                pSEventProducer.postscriptLevel3Needed(pSGenerator);
            } else {
                throw new IllegalStateException("PostScript Level 3 is required to use TrueType fonts, configured level is " + pSGenerator.getPSLevel());
            }
        }
    }

    private static void embedTrueTypeFont(PSGenerator pSGenerator, SingleByteFont singleByteFont, InputStream inputStream) throws IOException {
        pSGenerator.commentln("%!PS-TrueTypeFont-65536-65536-1");
        pSGenerator.writeln("11 dict begin");
        if (singleByteFont.getEmbeddingMode() == EmbeddingMode.AUTO) {
            singleByteFont.setEmbeddingMode(EmbeddingMode.SUBSET);
        }
        FontFileReader fontFileReader = new FontFileReader(inputStream);
        TTFFile tTFFile = new TTFFile();
        tTFFile.readFont(fontFileReader, singleByteFont.getFullName());
        PSFontUtils.createType42DictionaryEntries(pSGenerator, singleByteFont, singleByteFont.getCMap(), tTFFile);
        pSGenerator.writeln("FontName currentdict end definefont pop");
    }

    private static void createType42DictionaryEntries(PSGenerator pSGenerator, CustomFont customFont, CMapSegment[] cMapSegmentArray, TTFFile tTFFile) throws IOException {
        boolean bl;
        pSGenerator.write("/FontName /");
        pSGenerator.write(customFont.getEmbedFontName());
        pSGenerator.writeln(" def");
        pSGenerator.writeln("/PaintType 0 def");
        pSGenerator.writeln("/FontMatrix [1 0 0 1 0 0] def");
        PSFontUtils.writeFontBBox(pSGenerator, customFont);
        pSGenerator.writeln("/FontType 42 def");
        pSGenerator.writeln("/Encoding 256 array");
        pSGenerator.writeln("0 1 255{1 index exch/.notdef put}for");
        HashSet<String> hashSet = new HashSet<String>();
        if (customFont.getFontType() == FontType.TYPE0 && customFont.getEmbeddingMode() != EmbeddingMode.FULL) {
            bl = false;
        } else {
            bl = true;
            for (int i = 0; i < Glyphs.WINANSI_ENCODING.length; ++i) {
                pSGenerator.write("dup ");
                pSGenerator.write(i);
                pSGenerator.write(" /");
                String string = Glyphs.charToGlyphName((char)Glyphs.WINANSI_ENCODING[i]);
                if (string.equals("")) {
                    pSGenerator.write(".notdef");
                } else {
                    pSGenerator.write(string);
                    hashSet.add(string);
                }
                pSGenerator.writeln(" put");
            }
        }
        pSGenerator.writeln("readonly def");
        PSTTFOutputStream pSTTFOutputStream = new PSTTFOutputStream(pSGenerator);
        tTFFile.stream(pSTTFOutputStream);
        PSFontUtils.buildCharStrings(pSGenerator, bl, cMapSegmentArray, hashSet, customFont);
    }

    private static void buildCharStrings(PSGenerator pSGenerator, boolean bl, CMapSegment[] cMapSegmentArray, Set<String> set, CustomFont customFont) throws IOException {
        pSGenerator.write("/CharStrings ");
        if (!bl) {
            pSGenerator.write(1);
        } else if (customFont.getEmbeddingMode() != EmbeddingMode.FULL) {
            int n = 1;
            CMapSegment[] object = cMapSegmentArray;
            int n2 = object.length;
            for (int i = 0; i < n2; ++i) {
                CMapSegment cMapSegment = object[i];
                n += cMapSegment.getUnicodeEnd() - cMapSegment.getUnicodeStart() + 1;
            }
            pSGenerator.write(n);
        } else {
            pSGenerator.write(customFont.getCMap().length);
        }
        pSGenerator.writeln(" dict dup begin");
        pSGenerator.write("/");
        pSGenerator.write(".notdef");
        pSGenerator.writeln(" 0 def");
        if (!bl) {
            pSGenerator.writeln("end readonly def");
            return;
        }
        if (customFont.getEmbeddingMode() != EmbeddingMode.FULL) {
            for (CMapSegment cMapSegment : cMapSegmentArray) {
                int n = cMapSegment.getGlyphStartIndex();
                for (int i = cMapSegment.getUnicodeStart(); i <= cMapSegment.getUnicodeEnd(); ++i) {
                    char c = (char)i;
                    String string = Glyphs.charToGlyphName((char)c);
                    if ("".equals(string)) {
                        string = "u" + Integer.toHexString(i).toUpperCase(Locale.ENGLISH);
                    }
                    PSFontUtils.writeGlyphDefs(pSGenerator, string, n);
                    ++n;
                }
            }
        } else {
            for (String string : set) {
                PSFontUtils.writeGlyphDefs(pSGenerator, string, PSFontUtils.getGlyphIndex(Glyphs.getUnicodeSequenceForGlyphName((String)string).charAt(0), customFont.getCMap()));
            }
        }
        pSGenerator.writeln("end readonly def");
    }

    private static void writeGlyphDefs(PSGenerator pSGenerator, String string, int n) throws IOException {
        pSGenerator.write("/");
        pSGenerator.write(string);
        pSGenerator.write(" ");
        pSGenerator.write(n);
        pSGenerator.writeln(" def");
    }

    private static int getGlyphIndex(char c, CMapSegment[] cMapSegmentArray) {
        for (CMapSegment cMapSegment : cMapSegmentArray) {
            if (cMapSegment.getUnicodeStart() > c || c > cMapSegment.getUnicodeEnd()) continue;
            return cMapSegment.getGlyphStartIndex() + c - cMapSegment.getUnicodeStart();
        }
        return 0;
    }

    private static void composeType0Font(PSGenerator pSGenerator, MultiByteFont multiByteFont, InputStream inputStream) throws IOException {
        String string = multiByteFont.getEmbedFontName();
        pSGenerator.write("/");
        pSGenerator.write(string);
        pSGenerator.write(" /Identity-H [/");
        pSGenerator.write(string);
        pSGenerator.writeln("] composefont pop");
    }

    private static PSResource embedType2CIDFont(PSGenerator pSGenerator, MultiByteFont multiByteFont, InputStream inputStream) throws IOException {
        Object object;
        assert (multiByteFont.getCIDType() == CIDFontType.CIDTYPE2);
        String string = multiByteFont.getEmbedFontName();
        pSGenerator.write("%%BeginResource: CIDFont ");
        pSGenerator.writeln(string);
        pSGenerator.write("%%Title: (");
        pSGenerator.write(string);
        pSGenerator.writeln(" Adobe Identity 0)");
        pSGenerator.writeln("%%Version: 1");
        pSGenerator.writeln("/CIDInit /ProcSet findresource begin");
        pSGenerator.writeln("20 dict begin");
        pSGenerator.write("/CIDFontName /");
        pSGenerator.write(string);
        pSGenerator.writeln(" def");
        pSGenerator.writeln("/CIDFontVersion 1 def");
        pSGenerator.write("/CIDFontType ");
        pSGenerator.write(multiByteFont.getCIDType().getValue());
        pSGenerator.writeln(" def");
        pSGenerator.writeln("/CIDSystemInfo 3 dict dup begin");
        pSGenerator.writeln("  /Registry (Adobe) def");
        pSGenerator.writeln("  /Ordering (Identity) def");
        pSGenerator.writeln("  /Supplement 0 def");
        pSGenerator.writeln("end def");
        pSGenerator.write("/CIDCount ");
        CIDSubset cIDSubset = multiByteFont.getCIDSubset();
        int n = cIDSubset.getSubsetSize();
        pSGenerator.write(n);
        pSGenerator.writeln(" def");
        pSGenerator.writeln("/GDBytes 2 def");
        pSGenerator.writeln("/CIDMap [<");
        int n2 = 0;
        int n3 = 1;
        for (int i = 0; i < n; ++i) {
            if (n2++ == 20) {
                pSGenerator.newLine();
                n2 = 1;
                if (n3++ == 800) {
                    pSGenerator.writeln("> <");
                    n3 = 1;
                }
            }
            object = multiByteFont.getEmbeddingMode() != EmbeddingMode.FULL ? HexEncoder.encode(i, 4) : HexEncoder.encode(cIDSubset.getGlyphIndexForSubsetIndex(i), 4);
            pSGenerator.write((String)object);
        }
        pSGenerator.writeln(">] def");
        FontFileReader fontFileReader = new FontFileReader(inputStream);
        if (multiByteFont.getEmbeddingMode() != EmbeddingMode.FULL) {
            object = new TTFSubSetFile();
            ((TTFFile)object).readFont(fontFileReader, multiByteFont.getTTCName(), multiByteFont.getUsedGlyphs());
        } else {
            object = new TTFFile();
            ((TTFFile)object).readFont(fontFileReader, multiByteFont.getTTCName());
        }
        PSFontUtils.createType42DictionaryEntries(pSGenerator, multiByteFont, new CMapSegment[0], (TTFFile)object);
        pSGenerator.writeln("CIDFontName currentdict end /CIDFont defineresource pop");
        pSGenerator.writeln("end");
        pSGenerator.writeln("%%EndResource");
        PSResource pSResource = new PSResource("cidfont", string);
        pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        return pSResource;
    }

    private static void writeFontBBox(PSGenerator pSGenerator, CustomFont customFont) throws IOException {
        int[] nArray = customFont.getFontBBox();
        pSGenerator.write("/FontBBox[");
        for (int i = 0; i < 4; ++i) {
            pSGenerator.write(" ");
            pSGenerator.write(nArray[i]);
        }
        pSGenerator.writeln(" ] def");
    }

    private static boolean isEmbeddable(CustomFont customFont) {
        return customFont.isEmbeddable();
    }

    private static InputStream getInputStreamOnFont(PSGenerator pSGenerator, CustomFont customFont) throws IOException {
        if (PSFontUtils.isEmbeddable(customFont)) {
            Source source = customFont.getEmbedFileSource();
            if (source == null && customFont.getEmbedResourceName() != null) {
                source = new StreamSource(PSFontUtils.class.getResourceAsStream(customFont.getEmbedResourceName()));
            }
            if (source == null) {
                return null;
            }
            InputStream inputStream = null;
            if (source instanceof StreamSource) {
                inputStream = ((StreamSource)source).getInputStream();
            }
            if (inputStream == null && source.getSystemId() != null) {
                try {
                    inputStream = new URL(source.getSystemId()).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    new FileNotFoundException("File not found. URL could not be resolved: " + malformedURLException.getMessage());
                }
            }
            if (inputStream == null) {
                return null;
            }
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            return inputStream;
        }
        return null;
    }

    public static Map determineSuppliedFonts(ResourceTracker resourceTracker, FontInfo fontInfo, Map<String, Typeface> map) {
        HashMap<String, PSResource> hashMap = new HashMap<String, PSResource>();
        for (String string : map.keySet()) {
            Typeface typeface = PSFontUtils.getTypeFace(fontInfo, map, string);
            PSResource pSResource = new PSResource("font", typeface.getEmbedFontName());
            hashMap.put(string, pSResource);
            FontType fontType = typeface.getFontType();
            if (fontType != FontType.TYPE1 && fontType != FontType.TRUETYPE && fontType != FontType.TYPE0 || !(typeface instanceof CustomFont)) continue;
            CustomFont customFont = (CustomFont)typeface;
            if (PSFontUtils.isEmbeddable(customFont)) {
                if (fontType == FontType.TYPE0) {
                    resourceTracker.registerSuppliedResource(new PSResource("cidfont", typeface.getEmbedFontName()));
                    resourceTracker.registerSuppliedResource(new PSResource("cmap", "Identity-H"));
                }
                resourceTracker.registerSuppliedResource(pSResource);
            }
            if (!(typeface instanceof SingleByteFont)) continue;
            SingleByteFont singleByteFont = (SingleByteFont)typeface;
            int n = singleByteFont.getAdditionalEncodingCount();
            for (int i = 0; i < n; ++i) {
                SimpleSingleByteEncoding simpleSingleByteEncoding = singleByteFont.getAdditionalEncoding(i);
                PSResource pSResource2 = new PSResource("encoding", simpleSingleByteEncoding.getName());
                resourceTracker.registerSuppliedResource(pSResource2);
                PSResource pSResource3 = new PSResource("font", typeface.getEmbedFontName() + "_" + (i + 1));
                resourceTracker.registerSuppliedResource(pSResource3);
            }
        }
        return hashMap;
    }

    public static PSResource defineEncoding(PSGenerator pSGenerator, SingleByteEncoding singleByteEncoding) throws IOException {
        PSResource pSResource = new PSResource("encoding", singleByteEncoding.getName());
        pSGenerator.writeDSCComment("BeginResource", (Object)pSResource);
        pSGenerator.writeln("/" + singleByteEncoding.getName() + " [");
        String[] stringArray = singleByteEncoding.getCharNameMap();
        for (int i = 0; i < 256; ++i) {
            if (i > 0) {
                if (i % 5 == 0) {
                    pSGenerator.newLine();
                } else {
                    pSGenerator.write(" ");
                }
            }
            String string = null;
            if (i < stringArray.length) {
                string = stringArray[i];
            }
            if (string == null || "".equals(string)) {
                string = ".notdef";
            }
            pSGenerator.write("/");
            pSGenerator.write(string);
        }
        pSGenerator.newLine();
        pSGenerator.writeln("] def");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        return pSResource;
    }

    public static PSResource defineDerivedFont(PSGenerator pSGenerator, String string, String string2, String string3) throws IOException {
        PSResource pSResource = new PSResource("font", string2);
        pSGenerator.writeDSCComment("BeginResource", (Object)pSResource);
        pSGenerator.commentln("%XGCDependencies: font " + string);
        pSGenerator.commentln("%XGC+ encoding " + string3);
        pSGenerator.writeln("/" + string + " findfont");
        pSGenerator.writeln("dup length dict begin");
        pSGenerator.writeln("  {1 index /FID ne {def} {pop pop} ifelse} forall");
        pSGenerator.writeln("  /Encoding " + string3 + " def");
        pSGenerator.writeln("  currentdict");
        pSGenerator.writeln("end");
        pSGenerator.writeln("/" + string2 + " exch definefont pop");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        return pSResource;
    }

    private static PSResource defineDerivedTrueTypeFont(PSGenerator pSGenerator, PSEventProducer pSEventProducer, String string, String string2, SingleByteEncoding singleByteEncoding, CMapSegment[] cMapSegmentArray) throws IOException {
        PSFontUtils.checkPostScriptLevel3(pSGenerator, pSEventProducer);
        PSResource pSResource = new PSResource("font", string2);
        pSGenerator.writeDSCComment("BeginResource", (Object)pSResource);
        pSGenerator.commentln("%XGCDependencies: font " + string);
        pSGenerator.commentln("%XGC+ encoding " + singleByteEncoding.getName());
        pSGenerator.writeln("/" + string + " findfont");
        pSGenerator.writeln("dup length dict begin");
        pSGenerator.writeln("  {1 index /FID ne {def} {pop pop} ifelse} forall");
        pSGenerator.writeln("  /Encoding " + singleByteEncoding.getName() + " def");
        pSGenerator.writeln("  /CharStrings 256 dict dup begin");
        String[] stringArray = singleByteEncoding.getCharNameMap();
        char[] cArray = singleByteEncoding.getUnicodeCharMap();
        assert (stringArray.length == cArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            pSGenerator.write("    /");
            pSGenerator.write(string3);
            pSGenerator.write(" ");
            if (string3.equals(".notdef")) {
                pSGenerator.write(0);
            } else {
                pSGenerator.write(PSFontUtils.getGlyphIndex(cArray[i], cMapSegmentArray));
            }
            pSGenerator.writeln(" def");
        }
        pSGenerator.writeln("  end readonly def");
        pSGenerator.writeln("  currentdict");
        pSGenerator.writeln("end");
        pSGenerator.writeln("/" + string2 + " exch definefont pop");
        pSGenerator.writeDSCComment("EndResource");
        pSGenerator.getResourceTracker().registerSuppliedResource(pSResource);
        return pSResource;
    }
}

