/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.ps;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.ps.ImageEncoder;

public class ImageEncoderPNG
implements ImageEncoder {
    private final ImageRawPNG image;
    private int numberOfInterleavedComponents;

    public ImageEncoderPNG(ImageRawPNG imageRawPNG) {
        this.image = imageRawPNG;
        ColorModel colorModel = this.image.getColorModel();
        this.numberOfInterleavedComponents = colorModel instanceof IndexColorModel ? 1 : colorModel.getNumComponents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        InputStream inputStream = this.image.createInputStream();
        try {
            if (this.numberOfInterleavedComponents == 1 || this.numberOfInterleavedComponents == 3) {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            } else {
                int n;
                int n2 = this.numberOfInterleavedComponents - 1;
                int n3 = this.image.getSize().getWidthPx();
                InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream, new Inflater());
                DataInputStream dataInputStream = new DataInputStream(inflaterInputStream);
                int n4 = 0;
                int n5 = this.numberOfInterleavedComponents * n3;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater());
                while ((n = dataInputStream.read()) != -1) {
                    byte[] byArray = new byte[n5];
                    dataInputStream.readFully(byArray, 0, n5);
                    deflaterOutputStream.write((byte)n);
                    for (int i = 0; i < n3; ++i) {
                        deflaterOutputStream.write(byArray, n4, n2);
                        n4 += this.numberOfInterleavedComponents;
                    }
                    n4 = 0;
                }
                deflaterOutputStream.close();
                IOUtils.copy((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), (OutputStream)outputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public String getImplicitFilter() {
        String string = "<< /Predictor 15 /Columns " + this.image.getSize().getWidthPx();
        string = string + " /Colors " + (this.numberOfInterleavedComponents > 2 ? 3 : 1);
        string = string + " /BitsPerComponent " + this.image.getBitDepth() + " >> /FlateDecode";
        return string;
    }
}

