/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.print;

import java.awt.Rectangle;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.Map;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.fop.render.print.PagesMode;

public class PageableRenderer
extends Java2DRenderer
implements Pageable {
    public static final String PAGES_MODE = "even-odd";
    public static final String START_PAGE = "start-page";
    public static final String END_PAGE = "end-page";
    protected int startNumber = 0;
    protected int endNumber = -1;
    protected PagesMode mode = PagesMode.ALL;
    private PageFilter pageFilter;

    public PageableRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
        Map map = this.getUserAgent().getRendererOptions();
        this.processOptions(map);
        this.pageFilter = new DefaultPageFilter();
    }

    public String getMimeType() {
        return "application/X-fop-print";
    }

    private void processOptions(Map map) {
        Object v = map.get(PAGES_MODE);
        if (v != null) {
            if (v instanceof PagesMode) {
                this.mode = (PagesMode)v;
            } else if (v instanceof String) {
                this.mode = PagesMode.byName((String)v);
            } else {
                throw new IllegalArgumentException("Renderer option even-odd must be an 'all', 'even', 'odd' or a PagesMode instance.");
            }
        }
        if ((v = map.get(START_PAGE)) != null) {
            this.startNumber = this.getPositiveInteger(v);
        }
        if ((v = map.get(END_PAGE)) != null) {
            this.endNumber = this.getPositiveInteger(v);
        }
        if (this.endNumber >= 0 && this.endNumber < this.endNumber) {
            this.endNumber = this.startNumber;
        }
    }

    protected int getPositiveInteger(Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            if (n < 1) {
                throw new IllegalArgumentException("Value must be a positive Integer");
            }
            return n;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        throw new IllegalArgumentException("Value must be a positive integer");
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        if (this.endNumber == -1) {
            this.endNumber = this.getNumberOfPages();
        }
    }

    protected void rememberPage(PageViewport pageViewport) {
        if (this.pageFilter.isValid(pageViewport)) {
            super.rememberPage(pageViewport);
        }
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        try {
            double d;
            if (n >= this.getNumberOfPages()) {
                return null;
            }
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            Rectangle rectangle = this.getPageViewport(n).getViewArea();
            double d2 = ((RectangularShape)rectangle).getWidth();
            if (d2 > (d = ((RectangularShape)rectangle).getHeight())) {
                paper.setImageableArea(0.0, 0.0, d / 1000.0, d2 / 1000.0);
                paper.setSize(d / 1000.0, d2 / 1000.0);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, d2 / 1000.0, d / 1000.0);
                paper.setSize(d2 / 1000.0, d / 1000.0);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        catch (FOPException fOPException) {
            throw new IndexOutOfBoundsException(fOPException.getMessage());
        }
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        return this;
    }

    private class DefaultPageFilter
    implements PageFilter {
        private DefaultPageFilter() {
        }

        public boolean isValid(PageViewport pageViewport) {
            int n = pageViewport.getPageIndex() + 1;
            assert (n >= 0);
            if (n < PageableRenderer.this.startNumber || PageableRenderer.this.endNumber >= 0 && n > PageableRenderer.this.endNumber) {
                return false;
            }
            if (PageableRenderer.this.mode != PagesMode.ALL) {
                if (PageableRenderer.this.mode == PagesMode.EVEN && n % 2 != 0) {
                    return false;
                }
                if (PageableRenderer.this.mode == PagesMode.ODD && n % 2 == 0) {
                    return false;
                }
            }
            return true;
        }
    }

    private static interface PageFilter {
        public boolean isValid(PageViewport var1);
    }
}

