/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFTextUtil;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractIFPainter;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.pdf.PDFBorderPainter;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.render.pdf.PDFDocumentHandler;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.fop.render.pdf.PDFRenderingUtil;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.Direction;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.CharUtilities;
import org.w3c.dom.Document;

public class PDFPainter
extends AbstractIFPainter {
    private final PDFDocumentHandler documentHandler;
    protected PDFContentGenerator generator;
    private final PDFBorderPainter borderPainter;
    private boolean accessEnabled;
    private PDFLogicalStructureHandler.MarkedContentInfo imageMCI;
    private PDFLogicalStructureHandler logicalStructureHandler;
    private static int[] paZero = new int[4];

    public PDFPainter(PDFDocumentHandler pDFDocumentHandler, PDFLogicalStructureHandler pDFLogicalStructureHandler) {
        this.documentHandler = pDFDocumentHandler;
        this.logicalStructureHandler = pDFLogicalStructureHandler;
        this.generator = pDFDocumentHandler.generator;
        this.borderPainter = new PDFBorderPainter(this.generator);
        this.state = IFState.create();
        this.accessEnabled = this.getUserAgent().isAccessibilityEnabled();
    }

    protected IFContext getContext() {
        return this.documentHandler.getContext();
    }

    PDFRenderingUtil getPDFUtil() {
        return this.documentHandler.pdfUtil;
    }

    PDFDocument getPDFDoc() {
        return this.documentHandler.pdfDoc;
    }

    FontInfo getFontInfo() {
        return this.documentHandler.getFontInfo();
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        this.generator.saveGraphicsState();
        this.generator.concatenate(PDFPainter.toPoints(affineTransform));
        if (rectangle != null) {
            this.clipRect(rectangle);
        }
    }

    public void endViewport() throws IFException {
        this.generator.restoreGraphicsState();
    }

    public void startGroup(AffineTransform affineTransform) throws IFException {
        this.generator.saveGraphicsState();
        this.generator.concatenate(PDFPainter.toPoints(affineTransform));
    }

    public void endGroup() throws IFException {
        this.generator.restoreGraphicsState();
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        PDFXObject pDFXObject = this.getPDFDoc().getXObject(string);
        if (pDFXObject != null) {
            if (this.accessEnabled) {
                PDFStructElem pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement();
                this.prepareImageMCID(pDFStructElem);
                this.placeImageAccess(rectangle, pDFXObject);
            } else {
                this.placeImage(rectangle, pDFXObject);
            }
        } else {
            if (this.accessEnabled) {
                PDFStructElem pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement();
                this.prepareImageMCID(pDFStructElem);
            }
            this.drawImageUsingURI(string, rectangle);
            this.flushPDFDoc();
        }
    }

    private void prepareImageMCID(PDFStructElem pDFStructElem) {
        this.imageMCI = this.logicalStructureHandler.addImageContentItem(pDFStructElem);
    }

    protected RenderingContext createRenderingContext() {
        PDFRenderingContext pDFRenderingContext = new PDFRenderingContext(this.getUserAgent(), this.generator, this.documentHandler.currentPage, this.getFontInfo());
        pDFRenderingContext.setMarkedContentInfo(this.imageMCI);
        return pDFRenderingContext;
    }

    private void placeImage(Rectangle rectangle, PDFXObject pDFXObject) {
        this.generator.saveGraphicsState();
        this.generator.add(PDFPainter.format(rectangle.width) + " 0 0 " + PDFPainter.format(-rectangle.height) + " " + PDFPainter.format(rectangle.x) + " " + PDFPainter.format(rectangle.y + rectangle.height) + " cm " + pDFXObject.getName() + " Do\n");
        this.generator.restoreGraphicsState();
    }

    private void placeImageAccess(Rectangle rectangle, PDFXObject pDFXObject) {
        this.generator.saveGraphicsState(this.imageMCI.tag, this.imageMCI.mcid);
        this.generator.add(PDFPainter.format(rectangle.width) + " 0 0 " + PDFPainter.format(-rectangle.height) + " " + PDFPainter.format(rectangle.x) + " " + PDFPainter.format(rectangle.y + rectangle.height) + " cm " + pDFXObject.getName() + " Do\n");
        this.generator.restoreGraphicsStateAccess();
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        if (this.accessEnabled) {
            PDFStructElem pDFStructElem = (PDFStructElem)this.getContext().getStructureTreeElement();
            this.prepareImageMCID(pDFStructElem);
        }
        this.drawImageUsingDocument(document, rectangle);
        this.flushPDFDoc();
    }

    private void flushPDFDoc() throws IFException {
        try {
            this.generator.flushPDFDoc();
        }
        catch (IOException iOException) {
            throw new IFException("I/O error flushing the PDF document", iOException);
        }
    }

    protected static String format(int n) {
        return PDFNumber.doubleOut((float)n / 1000.0f);
    }

    public void clipRect(Rectangle rectangle) throws IFException {
        this.generator.endTextObject();
        this.generator.clipRect(rectangle);
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        if (rectangle.width != 0 && rectangle.height != 0) {
            this.generator.endTextObject();
            if (paint != null) {
                if (paint instanceof Color) {
                    this.generator.updateColor((Color)paint, true, null);
                } else {
                    throw new UnsupportedOperationException("Non-Color paints NYI");
                }
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(PDFPainter.format(rectangle.x)).append(' ');
            stringBuffer.append(PDFPainter.format(rectangle.y)).append(' ');
            stringBuffer.append(PDFPainter.format(rectangle.width)).append(' ');
            stringBuffer.append(PDFPainter.format(rectangle.height)).append(" re");
            if (paint != null) {
                stringBuffer.append(" f");
            }
            stringBuffer.append('\n');
            this.generator.add(stringBuffer.toString());
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        if (borderProps != null || borderProps2 != null || borderProps3 != null || borderProps4 != null) {
            this.generator.endTextObject();
            try {
                this.borderPainter.drawBorders(rectangle, borderProps, borderProps2, borderProps3, borderProps4);
            }
            catch (IOException iOException) {
                throw new IFException("I/O error while drawing borders", iOException);
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IFException {
        this.generator.endTextObject();
        this.borderPainter.drawLine(point, point2, n, color, ruleStyle);
    }

    private Typeface getTypeface(String string) {
        if (string == null) {
            throw new NullPointerException("fontName must not be null");
        }
        Typeface typeface = this.getFontInfo().getFonts().get(string);
        if (typeface instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        return typeface;
    }

    public void drawText(int n, int n2, int n3, int n4, int[][] nArray, String string) throws IFException {
        Object object;
        if (this.accessEnabled) {
            object = (PDFStructElem)this.getContext().getStructureTreeElement();
            PDFLogicalStructureHandler.MarkedContentInfo markedContentInfo = this.logicalStructureHandler.addTextContentItem((PDFStructElem)object);
            if (this.generator.getTextUtil().isInTextObject()) {
                this.generator.separateTextElements(markedContentInfo.tag, markedContentInfo.mcid);
            }
            this.generator.updateColor(this.state.getTextColor(), true, null);
            this.generator.beginTextObject(markedContentInfo.tag, markedContentInfo.mcid);
        } else {
            this.generator.updateColor(this.state.getTextColor(), true, null);
            this.generator.beginTextObject();
        }
        object = new FontTriplet(this.state.getFontFamily(), this.state.getFontStyle(), this.state.getFontWeight());
        if (nArray == null || IFUtil.isDPOnlyDX(nArray)) {
            this.drawTextWithDX(n, n2, string, (FontTriplet)object, n3, n4, IFUtil.convertDPToDX(nArray));
        } else {
            this.drawTextWithDP(n, n2, string, (FontTriplet)object, n3, n4, nArray);
        }
    }

    private void drawTextWithDX(int n, int n2, String string, FontTriplet fontTriplet, int n3, int n4, int[] nArray) {
        int n5;
        String string2 = this.getFontInfo().getInternalFontKey(fontTriplet);
        int n6 = this.state.getFontSize();
        float f = (float)n6 / 1000.0f;
        Typeface typeface = this.getTypeface(string2);
        SingleByteFont singleByteFont = null;
        if (typeface instanceof SingleByteFont) {
            singleByteFont = (SingleByteFont)typeface;
        }
        Font font = this.getFontInfo().getFontInstance(fontTriplet, n6);
        String string3 = font.getFontName();
        PDFTextUtil pDFTextUtil = this.generator.getTextUtil();
        pDFTextUtil.updateTf(string2, f, typeface.isMultiByte());
        this.generator.updateCharacterSpacing((float)n3 / 1000.0f);
        pDFTextUtil.writeTextMatrix(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, (float)n / 1000.0f, (float)n2 / 1000.0f));
        int n7 = string.length();
        int n8 = n5 = nArray != null ? nArray.length : 0;
        if (nArray != null && n5 > 0 && nArray[0] != 0) {
            pDFTextUtil.adjustGlyphTJ((float)(-nArray[0]) / f);
        }
        for (int i = 0; i < n7; ++i) {
            char c;
            char c2 = string.charAt(i);
            float f2 = 0.0f;
            if (font.hasChar(c2)) {
                c = font.mapChar(c2);
                c = this.selectAndMapSingleByteFont(singleByteFont, string3, f, pDFTextUtil, c);
                if (n4 != 0 && CharUtilities.isAdjustableSpace(c2)) {
                    f2 += (float)n4;
                }
            } else {
                if (CharUtilities.isFixedWidthSpace(c2)) {
                    c = font.mapChar(' ');
                    int n9 = font.getCharWidth(c) - font.getCharWidth(c2);
                    f2 = -n9;
                } else {
                    c = font.mapChar(c2);
                    if (n4 != 0 && CharUtilities.isAdjustableSpace(c2)) {
                        f2 += (float)n4;
                    }
                }
                c = this.selectAndMapSingleByteFont(singleByteFont, string3, f, pDFTextUtil, c);
            }
            pDFTextUtil.writeTJMappedChar(c);
            if (nArray != null && i < n5 - 1) {
                f2 += (float)nArray[i + 1];
            }
            if (f2 == 0.0f) continue;
            pDFTextUtil.adjustGlyphTJ(-f2 / f);
        }
        pDFTextUtil.writeTJ();
    }

    private void drawTextWithDP(int n, int n2, String string, FontTriplet fontTriplet, int n3, int n4, int[][] nArray) {
        assert (string != null);
        assert (fontTriplet != null);
        assert (nArray != null);
        String string2 = this.getFontInfo().getInternalFontKey(fontTriplet);
        Typeface typeface = this.getTypeface(string2);
        if (typeface.isMultiByte()) {
            int n5 = this.state.getFontSize();
            float f = (float)n5 / 1000.0f;
            Font font = this.getFontInfo().getFontInstance(fontTriplet, n5);
            PDFTextUtil pDFTextUtil = this.generator.getTextUtil();
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = n4;
            pDFTextUtil.writeTextMatrix(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, (float)n / 1000.0f, (float)n2 / 1000.0f));
            pDFTextUtil.updateTf(string2, f, true);
            this.generator.updateCharacterSpacing((float)n3 / 1000.0f);
            int n6 = string.length();
            for (int i = 0; i < n6; ++i) {
                char c = string.charAt(i);
                int[] nArray2 = i < nArray.length ? nArray[i] : paZero;
                double d6 = d + (double)nArray2[0];
                double d7 = d2 + (double)nArray2[1];
                double d8 = (double)font.getCharWidth(c) + this.maybeWordOffsetX(d5, c, null);
                double d9 = 0.0;
                double d10 = (d6 - d3) / 1000.0;
                double d11 = (d7 - d4) / 1000.0;
                pDFTextUtil.writeTd(d10, d11);
                pDFTextUtil.writeTj(font.mapChar(c));
                d += d8 + (double)nArray2[2];
                d2 += d9 + (double)nArray2[3];
                d3 = d6;
                d4 = d7;
            }
        }
    }

    private double maybeWordOffsetX(double d, char c, Direction direction) {
        if (d != 0.0 && CharUtilities.isAdjustableSpace(c) && (direction == null || direction.isHorizontal())) {
            return d;
        }
        return 0.0;
    }

    private char selectAndMapSingleByteFont(SingleByteFont singleByteFont, String string, float f, PDFTextUtil pDFTextUtil, char c) {
        if (singleByteFont != null && singleByteFont.hasAdditionalEncodings()) {
            int n = c / 256;
            if (n == 0) {
                pDFTextUtil.updateTf(string, f, singleByteFont.isMultiByte());
            } else {
                pDFTextUtil.updateTf(string + "_" + Integer.toString(n), f, singleByteFont.isMultiByte());
                c = (char)(c % 256);
            }
        }
        return c;
    }
}

