/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import org.apache.fop.pdf.PDFArray;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFLink;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFPage;
import org.apache.fop.pdf.PDFParentTree;
import org.apache.fop.pdf.PDFStructElem;

class PDFLogicalStructureHandler {
    private static final PDFName MCR = new PDFName("MCR");
    private static final PDFName OBJR = new PDFName("OBJR");
    private static final MarkedContentInfo ARTIFACT = new MarkedContentInfo(null, -1, null);
    private final PDFDocument pdfDoc;
    private final PDFParentTree parentTree = new PDFParentTree();
    private int parentTreeKey;
    private PDFPage currentPage;
    private PDFArray pageParentTreeArray;

    PDFLogicalStructureHandler(PDFDocument pDFDocument) {
        this.pdfDoc = pDFDocument;
    }

    PDFParentTree getParentTree() {
        return this.parentTree;
    }

    private int getNextParentTreeKey() {
        return this.parentTreeKey++;
    }

    void startPage(PDFPage pDFPage) {
        this.currentPage = pDFPage;
        this.currentPage.setStructParents(this.getNextParentTreeKey());
        this.pageParentTreeArray = new PDFArray();
    }

    void endPage() {
        this.pdfDoc.registerObject(this.pageParentTreeArray);
        this.parentTree.getNums().put(this.currentPage.getStructParents(), (Object)this.pageParentTreeArray);
    }

    private MarkedContentInfo addToParentTree(PDFStructElem pDFStructElem) {
        PDFStructElem pDFStructElem2 = pDFStructElem instanceof PDFStructElem.Placeholder ? pDFStructElem.getParentStructElem() : pDFStructElem;
        this.pageParentTreeArray.add(pDFStructElem2);
        String string = pDFStructElem2.getStructureType().toString();
        int n = this.pageParentTreeArray.length() - 1;
        return new MarkedContentInfo(string, n, pDFStructElem);
    }

    MarkedContentInfo addTextContentItem(PDFStructElem pDFStructElem) {
        if (pDFStructElem == null) {
            return ARTIFACT;
        }
        MarkedContentInfo markedContentInfo = this.addToParentTree(pDFStructElem);
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("Type", MCR);
        pDFDictionary.put("Pg", this.currentPage);
        pDFDictionary.put("MCID", markedContentInfo.mcid);
        markedContentInfo.parent.addKid(pDFDictionary);
        return markedContentInfo;
    }

    MarkedContentInfo addImageContentItem(PDFStructElem pDFStructElem) {
        if (pDFStructElem == null) {
            return ARTIFACT;
        }
        MarkedContentInfo markedContentInfo = this.addToParentTree(pDFStructElem);
        markedContentInfo.parent.setMCIDKid(markedContentInfo.mcid);
        markedContentInfo.parent.setPage(this.currentPage);
        return markedContentInfo;
    }

    void addLinkContentItem(PDFLink pDFLink, PDFStructElem pDFStructElem) {
        int n = this.getNextParentTreeKey();
        pDFLink.setStructParent(n);
        PDFDictionary pDFDictionary = new PDFDictionary();
        pDFDictionary.put("Type", OBJR);
        pDFDictionary.put("Pg", this.currentPage);
        pDFDictionary.put("Obj", pDFLink);
        this.parentTree.getNums().put(n, (Object)pDFStructElem);
        pDFStructElem.addKid(pDFDictionary);
    }

    static final class MarkedContentInfo {
        final String tag;
        final int mcid;
        private final PDFStructElem parent;

        private MarkedContentInfo(String string, int n, PDFStructElem pDFStructElem) {
            this.tag = string;
            this.mcid = n;
            this.parent = pDFStructElem;
        }
    }
}

