/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.PDFColorHandler;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPaintingState;
import org.apache.fop.pdf.PDFResourceContext;
import org.apache.fop.pdf.PDFStream;
import org.apache.fop.pdf.PDFTextUtil;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.render.pdf.CTMHelper;

public class PDFContentGenerator {
    protected static final boolean WRITE_COMMENTS = true;
    private PDFDocument document;
    private OutputStream outputStream;
    private PDFResourceContext resourceContext;
    private PDFStream currentStream;
    private PDFColorHandler colorHandler;
    protected PDFPaintingState currentState = null;
    protected PDFTextUtil textutil;
    private boolean inMarkedContentSequence;
    private boolean inArtifactMode;

    public PDFContentGenerator(PDFDocument pDFDocument, OutputStream outputStream, PDFResourceContext pDFResourceContext) {
        this.document = pDFDocument;
        this.outputStream = outputStream;
        this.resourceContext = pDFResourceContext;
        this.currentStream = pDFDocument.getFactory().makeStream("content", false);
        this.textutil = new PDFTextUtil(){

            protected void write(String string) {
                PDFContentGenerator.this.currentStream.add(string);
            }
        };
        this.currentState = new PDFPaintingState();
        this.colorHandler = new PDFColorHandler(pDFDocument.getResources());
    }

    public PDFDocument getDocument() {
        return this.document;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public PDFResourceContext getResourceContext() {
        return this.resourceContext;
    }

    public PDFStream getStream() {
        return this.currentStream;
    }

    public PDFPaintingState getState() {
        return this.currentState;
    }

    public PDFTextUtil getTextUtil() {
        return this.textutil;
    }

    public void flushPDFDoc() throws IOException {
        this.document.output(this.outputStream);
    }

    protected void comment(String string) {
        this.currentStream.add("% " + string + "\n");
    }

    protected void saveGraphicsState() {
        this.endTextObject();
        this.currentState.save();
        this.currentStream.add("q\n");
    }

    protected void saveGraphicsState(String string, int n) {
        this.endTextObject();
        this.currentState.save();
        this.beginMarkedContentSequence(string, n);
        this.currentStream.add("q\n");
    }

    protected void beginMarkedContentSequence(String string, int n) {
        assert (!this.inMarkedContentSequence);
        assert (!this.inArtifactMode);
        if (string != null) {
            this.currentStream.add(string + " <</MCID " + String.valueOf(n) + ">>\n" + "BDC\n");
        } else {
            this.currentStream.add("/Artifact\nBMC\n");
            this.inArtifactMode = true;
        }
        this.inMarkedContentSequence = true;
    }

    void endMarkedContentSequence() {
        this.currentStream.add("EMC\n");
        this.inMarkedContentSequence = false;
        this.inArtifactMode = false;
    }

    protected void restoreGraphicsState(boolean bl) {
        this.endTextObject();
        this.currentStream.add("Q\n");
        if (bl) {
            this.currentState.restore();
        }
    }

    protected void restoreGraphicsState() {
        this.restoreGraphicsState(true);
    }

    protected void restoreGraphicsStateAccess() {
        this.endTextObject();
        this.currentStream.add("Q\n");
        if (this.inMarkedContentSequence) {
            this.endMarkedContentSequence();
        }
        this.currentState.restore();
    }

    protected void separateTextElements(String string, int n) {
        this.textutil.endTextObject();
        this.endMarkedContentSequence();
        this.beginMarkedContentSequence(string, n);
        this.textutil.beginTextObject();
    }

    protected void beginTextObject() {
        if (!this.textutil.isInTextObject()) {
            this.textutil.beginTextObject();
        }
    }

    protected void beginTextObject(String string, int n) {
        if (!this.textutil.isInTextObject()) {
            this.beginMarkedContentSequence(string, n);
            this.textutil.beginTextObject();
        }
    }

    protected void endTextObject() {
        if (this.textutil.isInTextObject()) {
            this.textutil.endTextObject();
            if (this.inMarkedContentSequence) {
                this.endMarkedContentSequence();
            }
        }
    }

    public void concatenate(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.currentState.concatenate(affineTransform);
            this.currentStream.add(CTMHelper.toPDFString(affineTransform, false) + " cm\n");
        }
    }

    public void clipRect(Rectangle rectangle) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.x / 1000.0f)).append(' ');
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.y / 1000.0f)).append(' ');
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.width / 1000.0f)).append(' ');
        stringBuffer.append(PDFContentGenerator.format((float)rectangle.height / 1000.0f)).append(" re W n\n");
        this.add(stringBuffer.toString());
    }

    public void add(String string) {
        this.currentStream.add(string);
    }

    public static final String format(float f) {
        return PDFNumber.doubleOut(f);
    }

    public void updateLineWidth(float f) {
        if (this.currentState.setLineWidth(f)) {
            this.currentStream.add(PDFContentGenerator.format(f) + " w\n");
        }
    }

    public void updateCharacterSpacing(float f) {
        if (this.getState().setCharacterSpacing(f)) {
            this.currentStream.add(PDFContentGenerator.format(f) + " Tc\n");
        }
    }

    public void setColor(Color color, boolean bl, PDFStream pDFStream) {
        assert (pDFStream != null);
        StringBuffer stringBuffer = new StringBuffer();
        this.setColor(color, bl, stringBuffer);
        pDFStream.add(stringBuffer.toString());
    }

    public void setColor(Color color, boolean bl) {
        this.setColor(color, bl, this.getStream());
    }

    protected void setColor(Color color, boolean bl, StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            this.colorHandler.establishColor(stringBuffer, color, bl);
        } else {
            this.setColor(color, bl, this.currentStream);
        }
    }

    public void updateColor(Color color, boolean bl, StringBuffer stringBuffer) {
        if (color == null) {
            return;
        }
        boolean bl2 = false;
        bl2 = bl ? this.getState().setBackColor(color) : this.getState().setColor(color);
        if (bl2) {
            this.setColor(color, bl, stringBuffer);
        }
    }

    public void placeImage(float f, float f2, float f3, float f4, PDFXObject pDFXObject) {
        this.saveGraphicsState();
        this.add(PDFContentGenerator.format(f3) + " 0 0 " + PDFContentGenerator.format(-f4) + " " + PDFContentGenerator.format(f) + " " + PDFContentGenerator.format(f2 + f4) + " cm\n" + pDFXObject.getName() + " Do\n");
        this.restoreGraphicsState();
    }

    public void placeImage(float f, float f2, float f3, float f4, PDFXObject pDFXObject, String string, int n) {
        this.saveGraphicsState(string, n);
        this.add(PDFContentGenerator.format(f3) + " 0 0 " + PDFContentGenerator.format(-f4) + " " + PDFContentGenerator.format(f) + " " + PDFContentGenerator.format(f2 + f4) + " cm\n" + pDFXObject.getName() + " Do\n");
        this.restoreGraphicsStateAccess();
    }
}

