/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.intermediate.BorderPainter;
import org.apache.fop.render.pdf.PDFContentGenerator;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.ColorUtil;

public class PDFBorderPainter
extends BorderPainter {
    private static final Log LOG = LogFactory.getLog(PDFBorderPainter.class);
    private PDFContentGenerator generator;

    public PDFBorderPainter(PDFContentGenerator pDFContentGenerator) {
        this.generator = pDFContentGenerator;
    }

    protected void drawBorderLine(int n, int n2, int n3, int n4, boolean bl, boolean bl2, int n5, Color color) {
        PDFBorderPainter.drawBorderLine(this.generator, (float)n / 1000.0f, (float)n2 / 1000.0f, (float)n3 / 1000.0f, (float)n4 / 1000.0f, bl, bl2, n5, color);
    }

    public static void drawBorderLine(PDFContentGenerator pDFContentGenerator, float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n, Color color) {
        float f5 = f3 - f;
        float f6 = f4 - f2;
        if (f5 < 0.0f || f6 < 0.0f) {
            LOG.error((Object)("Negative extent received (w=" + f5 + ", h=" + f6 + "). Border won't be painted."));
            return;
        }
        switch (n) {
            case 31: {
                pDFContentGenerator.setColor(color, false);
                if (bl) {
                    float f7 = Math.abs(2.0f * f6);
                    int n2 = (int)(f5 / f7);
                    if (n2 % 2 == 0) {
                        ++n2;
                    }
                    f7 = f5 / (float)n2;
                    pDFContentGenerator.add("[" + PDFBorderPainter.format(f7) + "] 0 d ");
                    pDFContentGenerator.add(PDFBorderPainter.format(f6) + " w\n");
                    float f8 = f2 + f6 / 2.0f;
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f8) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f8) + " l S\n");
                    break;
                }
                float f9 = Math.abs(2.0f * f5);
                int n3 = (int)(f6 / f9);
                if (n3 % 2 == 0) {
                    ++n3;
                }
                f9 = f6 / (float)n3;
                pDFContentGenerator.add("[" + PDFBorderPainter.format(f9) + "] 0 d ");
                pDFContentGenerator.add(PDFBorderPainter.format(f5) + " w\n");
                float f10 = f + f5 / 2.0f;
                pDFContentGenerator.add(PDFBorderPainter.format(f10) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f10) + " " + PDFBorderPainter.format(f4) + " l S\n");
                break;
            }
            case 36: {
                pDFContentGenerator.setColor(color, false);
                pDFContentGenerator.add("1 J ");
                if (bl) {
                    float f11 = Math.abs(2.0f * f6);
                    int n4 = (int)(f5 / f11);
                    if (n4 % 2 == 0) {
                        ++n4;
                    }
                    f11 = f5 / (float)n4;
                    pDFContentGenerator.add("[0 " + PDFBorderPainter.format(f11) + "] 0 d ");
                    pDFContentGenerator.add(PDFBorderPainter.format(f6) + " w\n");
                    float f12 = f2 + f6 / 2.0f;
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f12) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f12) + " l S\n");
                    break;
                }
                float f13 = Math.abs(2.0f * f5);
                int n5 = (int)(f6 / f13);
                if (n5 % 2 == 0) {
                    ++n5;
                }
                f13 = f6 / (float)n5;
                pDFContentGenerator.add("[0 " + PDFBorderPainter.format(f13) + " ] 0 d ");
                pDFContentGenerator.add(PDFBorderPainter.format(f5) + " w\n");
                float f14 = f + f5 / 2.0f;
                pDFContentGenerator.add(PDFBorderPainter.format(f14) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f14) + " " + PDFBorderPainter.format(f4) + " l S\n");
                break;
            }
            case 37: {
                pDFContentGenerator.setColor(color, false);
                pDFContentGenerator.add("[] 0 d ");
                if (bl) {
                    float f15 = f6 / 3.0f;
                    pDFContentGenerator.add(PDFBorderPainter.format(f15) + " w\n");
                    float f16 = f2 + f15 / 2.0f;
                    float f17 = f16 + f15 + f15;
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f16) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f16) + " l S\n");
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f17) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f17) + " l S\n");
                    break;
                }
                float f18 = f5 / 3.0f;
                pDFContentGenerator.add(PDFBorderPainter.format(f18) + " w\n");
                float f19 = f + f18 / 2.0f;
                float f20 = f19 + f18 + f18;
                pDFContentGenerator.add(PDFBorderPainter.format(f19) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f19) + " " + PDFBorderPainter.format(f4) + " l S\n");
                pDFContentGenerator.add(PDFBorderPainter.format(f20) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f20) + " " + PDFBorderPainter.format(f4) + " l S\n");
                break;
            }
            case 55: 
            case 119: {
                float f21 = n == 55 ? 0.4f : -0.4f;
                pDFContentGenerator.add("[] 0 d ");
                if (bl) {
                    Color color2 = ColorUtil.lightenColor(color, -f21);
                    Color color3 = ColorUtil.lightenColor(color, f21);
                    float f22 = f6 / 3.0f;
                    pDFContentGenerator.add(PDFBorderPainter.format(f22) + " w\n");
                    float f23 = f2 + f22 / 2.0f;
                    pDFContentGenerator.setColor(color2, false);
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f23) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f23) + " l S\n");
                    pDFContentGenerator.setColor(color, false);
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f23 + f22) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f23 + f22) + " l S\n");
                    pDFContentGenerator.setColor(color3, false);
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f23 + f22 + f22) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f23 + f22 + f22) + " l S\n");
                    break;
                }
                Color color4 = ColorUtil.lightenColor(color, -f21);
                Color color5 = ColorUtil.lightenColor(color, f21);
                float f24 = f5 / 3.0f;
                pDFContentGenerator.add(PDFBorderPainter.format(f24) + " w\n");
                float f25 = f + f24 / 2.0f;
                pDFContentGenerator.setColor(color4, false);
                pDFContentGenerator.add(PDFBorderPainter.format(f25) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f25) + " " + PDFBorderPainter.format(f4) + " l S\n");
                pDFContentGenerator.setColor(color, false);
                pDFContentGenerator.add(PDFBorderPainter.format(f25 + f24) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f25 + f24) + " " + PDFBorderPainter.format(f4) + " l S\n");
                pDFContentGenerator.setColor(color5, false);
                pDFContentGenerator.add(PDFBorderPainter.format(f25 + f24 + f24) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f25 + f24 + f24) + " " + PDFBorderPainter.format(f4) + " l S\n");
                break;
            }
            case 67: 
            case 101: {
                float f26 = n == 101 ? 0.4f : -0.4f;
                pDFContentGenerator.add("[] 0 d ");
                Color color6 = color;
                if (bl) {
                    color6 = ColorUtil.lightenColor(color6, (float)(bl2 ? 1 : -1) * f26);
                    pDFContentGenerator.add(PDFBorderPainter.format(f6) + " w\n");
                    float f27 = f2 + f6 / 2.0f;
                    pDFContentGenerator.setColor(color6, false);
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f27) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f27) + " l S\n");
                    break;
                }
                color6 = ColorUtil.lightenColor(color6, (float)(bl2 ? 1 : -1) * f26);
                pDFContentGenerator.add(PDFBorderPainter.format(f5) + " w\n");
                float f28 = f + f5 / 2.0f;
                pDFContentGenerator.setColor(color6, false);
                pDFContentGenerator.add(PDFBorderPainter.format(f28) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f28) + " " + PDFBorderPainter.format(f4) + " l S\n");
                break;
            }
            case 57: {
                break;
            }
            default: {
                pDFContentGenerator.setColor(color, false);
                pDFContentGenerator.add("[] 0 d ");
                if (bl) {
                    pDFContentGenerator.add(PDFBorderPainter.format(f6) + " w\n");
                    float f29 = f2 + f6 / 2.0f;
                    pDFContentGenerator.add(PDFBorderPainter.format(f) + " " + PDFBorderPainter.format(f29) + " m " + PDFBorderPainter.format(f3) + " " + PDFBorderPainter.format(f29) + " l S\n");
                    break;
                }
                pDFContentGenerator.add(PDFBorderPainter.format(f5) + " w\n");
                float f30 = f + f5 / 2.0f;
                pDFContentGenerator.add(PDFBorderPainter.format(f30) + " " + PDFBorderPainter.format(f2) + " m " + PDFBorderPainter.format(f30) + " " + PDFBorderPainter.format(f4) + " l S\n");
            }
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) {
        if (point.y != point2.y) {
            throw new UnsupportedOperationException("Can only deal with horizontal lines right now");
        }
        this.saveGraphicsState();
        int n2 = n / 2;
        int n3 = point.y - n2;
        Rectangle rectangle = new Rectangle(point.x, point.y - n2, point2.x - point.x, n);
        switch (ruleStyle.getEnumValue()) {
            case 31: 
            case 37: 
            case 133: {
                this.drawBorderLine(point.x, point.y - n2, point2.x, point2.y + n2, true, true, ruleStyle.getEnumValue(), color);
                break;
            }
            case 36: {
                this.generator.clipRect(rectangle);
                this.generator.add("1 0 0 1 " + PDFBorderPainter.format(n2) + " 0 cm\n");
                this.drawBorderLine(point.x, point.y - n2, point2.x, point2.y + n2, true, true, ruleStyle.getEnumValue(), color);
                break;
            }
            case 55: 
            case 119: {
                this.generator.setColor(ColorUtil.lightenColor(color, 0.6f), true);
                this.generator.add(PDFBorderPainter.format(point.x) + " " + PDFBorderPainter.format(n3) + " m\n");
                this.generator.add(PDFBorderPainter.format(point2.x) + " " + PDFBorderPainter.format(n3) + " l\n");
                this.generator.add(PDFBorderPainter.format(point2.x) + " " + PDFBorderPainter.format(n3 + 2 * n2) + " l\n");
                this.generator.add(PDFBorderPainter.format(point.x) + " " + PDFBorderPainter.format(n3 + 2 * n2) + " l\n");
                this.generator.add("h\n");
                this.generator.add("f\n");
                this.generator.setColor(color, true);
                if (ruleStyle == RuleStyle.GROOVE) {
                    this.generator.add(PDFBorderPainter.format(point.x) + " " + PDFBorderPainter.format(n3) + " m\n");
                    this.generator.add(PDFBorderPainter.format(point2.x) + " " + PDFBorderPainter.format(n3) + " l\n");
                    this.generator.add(PDFBorderPainter.format(point2.x) + " " + PDFBorderPainter.format(n3 + n2) + " l\n");
                    this.generator.add(PDFBorderPainter.format(point.x + n2) + " " + PDFBorderPainter.format(n3 + n2) + " l\n");
                    this.generator.add(PDFBorderPainter.format(point.x) + " " + PDFBorderPainter.format(n3 + 2 * n2) + " l\n");
                } else {
                    this.generator.add(PDFBorderPainter.format(point2.x) + " " + PDFBorderPainter.format(n3) + " m\n");
                    this.generator.add(PDFBorderPainter.format(point2.x) + " " + PDFBorderPainter.format(n3 + 2 * n2) + " l\n");
                    this.generator.add(PDFBorderPainter.format(point.x) + " " + PDFBorderPainter.format(n3 + 2 * n2) + " l\n");
                    this.generator.add(PDFBorderPainter.format(point.x) + " " + PDFBorderPainter.format(n3 + n2) + " l\n");
                    this.generator.add(PDFBorderPainter.format(point2.x - n2) + " " + PDFBorderPainter.format(n3 + n2) + " l\n");
                }
                this.generator.add("h\n");
                this.generator.add("f\n");
                break;
            }
            default: {
                throw new UnsupportedOperationException("rule style not supported");
            }
        }
        this.restoreGraphicsState();
    }

    static final String format(int n) {
        return PDFBorderPainter.format((float)n / 1000.0f);
    }

    static final String format(float f) {
        return PDFContentGenerator.format(f);
    }

    protected void moveTo(int n, int n2) {
        this.generator.add(PDFBorderPainter.format(n) + " " + PDFBorderPainter.format(n2) + " m ");
    }

    protected void lineTo(int n, int n2) {
        this.generator.add(PDFBorderPainter.format(n) + " " + PDFBorderPainter.format(n2) + " l ");
    }

    protected void closePath() {
        this.generator.add("h ");
    }

    protected void clip() {
        this.generator.add("W\nn\n");
    }

    protected void saveGraphicsState() {
        this.generator.add("q\n");
    }

    protected void restoreGraphicsState() {
        this.generator.add("Q\n");
    }
}

