/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.FlateFilter;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDictionary;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFilterException;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFReference;
import org.apache.fop.render.pdf.AbstractImageAdapter;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public class ImageRawPNGAdapter
extends AbstractImageAdapter {
    private static Log log = LogFactory.getLog(ImageRawPNGAdapter.class);
    private PDFICCStream pdfICCStream;
    private PDFFilter pdfFilter;
    private String maskRef;
    private PDFReference softMask;
    private int numberOfInterleavedComponents;

    public ImageRawPNGAdapter(ImageRawPNG imageRawPNG, String string) {
        super((Image)imageRawPNG, string);
    }

    public void setup(PDFDocument pDFDocument) {
        FlateFilter flateFilter;
        super.setup(pDFDocument);
        ColorModel colorModel = ((ImageRawPNG)this.image).getColorModel();
        this.numberOfInterleavedComponents = colorModel instanceof IndexColorModel ? 1 : colorModel.getNumComponents();
        try {
            flateFilter = new FlateFilter();
            flateFilter.setApplied(true);
            flateFilter.setPredictor(15);
            if (this.numberOfInterleavedComponents < 3) {
                flateFilter.setColors(1);
            } else {
                flateFilter.setColors(3);
            }
            flateFilter.setColumns(this.image.getSize().getWidthPx());
            flateFilter.setBitsPerComponent(this.getBitsPerComponent());
        }
        catch (PDFFilterException pDFFilterException) {
            throw new RuntimeException("FlateFilter configuration error", pDFFilterException);
        }
        this.pdfFilter = flateFilter;
        this.disallowMultipleFilters();
        if (colorModel.hasAlpha() && colorModel.getTransparency() == 3) {
            Object object;
            Object object2;
            pDFDocument.getProfile().verifyTransparencyAllowed(this.image.getInfo().getOriginalURI());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater());
            InputStream inputStream = ((ImageRawStream)this.image).createInputStream();
            try {
                int n;
                object2 = new InflaterInputStream(inputStream, new Inflater());
                object = new DataInputStream((InputStream)object2);
                int n2 = this.numberOfInterleavedComponents - 1;
                int n3 = this.image.getSize().getWidthPx();
                int n4 = this.numberOfInterleavedComponents * n3;
                while ((n = ((FilterInputStream)object).read()) != -1) {
                    byte[] byArray = new byte[n4];
                    ((DataInputStream)object).readFully(byArray, 0, n4);
                    deflaterOutputStream.write((byte)n);
                    for (int i = 0; i < n3; ++i) {
                        deflaterOutputStream.write(byArray, n2, 1);
                        n2 += this.numberOfInterleavedComponents;
                    }
                    n2 = this.numberOfInterleavedComponents - 1;
                }
                deflaterOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error processing transparency channel:", iOException);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            try {
                object2 = new FlateFilter();
                ((PDFFilter)object2).setApplied(true);
                ((FlateFilter)object2).setPredictor(15);
                ((FlateFilter)object2).setColors(1);
                ((FlateFilter)object2).setColumns(this.image.getSize().getWidthPx());
                ((FlateFilter)object2).setBitsPerComponent(this.getBitsPerComponent());
            }
            catch (PDFFilterException pDFFilterException) {
                throw new RuntimeException("FlateFilter configuration error", pDFFilterException);
            }
            object = new BitmapImage("Mask:" + this.getKey(), this.image.getSize().getWidthPx(), this.image.getSize().getHeightPx(), byteArrayOutputStream.toByteArray(), null);
            ((BitmapImage)object).setPDFFilter((PDFFilter)object2);
            ((BitmapImage)object).disallowMultipleFilters();
            ((BitmapImage)object).setColorSpace(new PDFDeviceColorSpace(1));
            this.softMask = pDFDocument.addImage(null, (PDFImage)object).makeReference();
        }
    }

    public PDFDeviceColorSpace getColorSpace() {
        return ImageRawPNGAdapter.toPDFColorSpace(this.image.getColorSpace());
    }

    public int getBitsPerComponent() {
        return ((ImageRawPNG)this.image).getBitDepth();
    }

    public boolean isTransparent() {
        return ((ImageRawPNG)this.image).isTransparent();
    }

    public PDFColor getTransparentColor() {
        return new PDFColor(((ImageRawPNG)this.image).getTransparentColor());
    }

    public String getMask() {
        return this.maskRef;
    }

    public String getSoftMask() {
        return this.softMask.toString();
    }

    public PDFReference getSoftMaskReference() {
        return this.softMask;
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputContents(OutputStream outputStream) throws IOException {
        InputStream inputStream = ((ImageRawStream)this.image).createInputStream();
        try {
            if (this.numberOfInterleavedComponents == 1 || this.numberOfInterleavedComponents == 3) {
                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            } else {
                int n;
                int n2 = this.numberOfInterleavedComponents - 1;
                int n3 = this.image.getSize().getWidthPx();
                InflaterInputStream inflaterInputStream = new InflaterInputStream(inputStream, new Inflater());
                DataInputStream dataInputStream = new DataInputStream(inflaterInputStream);
                int n4 = 0;
                int n5 = this.numberOfInterleavedComponents * n3;
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(outputStream, new Deflater());
                while ((n = dataInputStream.read()) != -1) {
                    byte[] byArray = new byte[n5];
                    dataInputStream.readFully(byArray, 0, n5);
                    deflaterOutputStream.write((byte)n);
                    for (int i = 0; i < n3; ++i) {
                        deflaterOutputStream.write(byArray, n4, n2);
                        n4 += this.numberOfInterleavedComponents;
                    }
                    n4 = 0;
                }
                deflaterOutputStream.close();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public PDFICCStream getICCStream() {
        return this.pdfICCStream;
    }

    public String getFilterHint() {
        return "precompressed";
    }

    public void populateXObjectDictionary(PDFDictionary pDFDictionary) {
        ColorModel colorModel = ((ImageRawPNG)this.image).getColorModel();
        if (colorModel instanceof IndexColorModel) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            super.populateXObjectDictionaryForIndexColorModel(pDFDictionary, indexColorModel);
        }
    }
}

