/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.Map;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.loader.batik.BatikUtil;
import org.apache.fop.render.AbstractGenericSVGHandler;
import org.apache.fop.render.ImageHandlerUtil;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererContext;
import org.apache.fop.render.java2d.Java2DGraphicsState;
import org.apache.fop.render.java2d.Java2DRenderer;
import org.apache.fop.render.java2d.Java2DRendererContextConstants;
import org.apache.fop.svg.SVGEventProducer;
import org.apache.fop.svg.SVGUserAgent;
import org.w3c.dom.Document;

public class Java2DSVGHandler
extends AbstractGenericSVGHandler
implements Java2DRendererContextConstants {
    private static Log log = LogFactory.getLog(Java2DSVGHandler.class);

    public static Java2DInfo getJava2DInfo(RendererContext rendererContext) {
        Java2DInfo java2DInfo = new Java2DInfo();
        java2DInfo.state = (Java2DGraphicsState)rendererContext.getProperty("state");
        java2DInfo.width = (Integer)rendererContext.getProperty("width");
        java2DInfo.height = (Integer)rendererContext.getProperty("height");
        java2DInfo.currentXPosition = (Integer)rendererContext.getProperty("xpos");
        java2DInfo.currentYPosition = (Integer)rendererContext.getProperty("ypos");
        Map map = (Map)rendererContext.getProperty("foreign-attributes");
        java2DInfo.paintAsBitmap = ImageHandlerUtil.isConversionModeBitmap(map);
        return java2DInfo;
    }

    protected void renderSVGDocument(RendererContext rendererContext, Document document) {
        GraphicsNode graphicsNode;
        Java2DInfo java2DInfo = Java2DSVGHandler.getJava2DInfo(rendererContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderSVGDocument(" + rendererContext + ", " + document + ", " + java2DInfo + ")"));
        }
        if (java2DInfo.paintAsBitmap) {
            try {
                super.renderSVGDocument(rendererContext, document);
            }
            catch (IOException iOException) {
                SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
                sVGEventProducer.svgRenderingError(this, iOException, this.getDocumentURI(document));
            }
            return;
        }
        int n = java2DInfo.currentXPosition;
        int n2 = java2DInfo.currentYPosition;
        SVGUserAgent sVGUserAgent = new SVGUserAgent(rendererContext.getUserAgent(), new AffineTransform());
        BridgeContext bridgeContext = new BridgeContext((UserAgent)sVGUserAgent);
        Document document2 = BatikUtil.cloneSVGDocument(document);
        try {
            GVTBuilder gVTBuilder = new GVTBuilder();
            graphicsNode = gVTBuilder.build(bridgeContext, document2);
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgNotBuilt(this, exception, this.getDocumentURI(document));
            return;
        }
        float f = (float)bridgeContext.getDocumentSize().getWidth() * 1000.0f;
        float f2 = (float)bridgeContext.getDocumentSize().getHeight() * 1000.0f;
        float f3 = java2DInfo.width;
        float f4 = java2DInfo.height;
        AffineTransform affineTransform = java2DInfo.state.getGraph().getTransform();
        java2DInfo.state.getGraph().translate((float)n / 1000.0f, (float)n2 / 1000.0f);
        AffineTransform affineTransform2 = AffineTransform.getScaleInstance(f3 / f, f4 / f2);
        if (!affineTransform2.isIdentity()) {
            java2DInfo.state.getGraph().transform(affineTransform2);
        }
        try {
            graphicsNode.paint(java2DInfo.state.getGraph());
        }
        catch (Exception exception) {
            SVGEventProducer sVGEventProducer = SVGEventProducer.Provider.get(rendererContext.getUserAgent().getEventBroadcaster());
            sVGEventProducer.svgRenderingError(this, exception, this.getDocumentURI(document));
        }
        java2DInfo.state.getGraph().setTransform(affineTransform);
    }

    public boolean supportsRenderer(Renderer renderer) {
        return renderer instanceof Java2DRenderer;
    }

    public static class Java2DInfo {
        public Java2DGraphicsState state;
        public int width;
        public int height;
        public int currentXPosition;
        public int currentYPosition;
        public boolean paintAsBitmap;

        public String toString() {
            return "Java2DInfo {state = " + this.state + ", " + "width = " + this.width + ", " + "height = " + this.height + ", " + "currentXPosition = " + this.currentXPosition + ", " + "currentYPosition = " + this.currentYPosition + ", " + "paintAsBitmap = " + this.paintAsBitmap + "}";
        }
    }
}

