/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.apache.fop.render.ImageHandler;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.java2d.Java2DRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.impl.ImageGraphics2D;

public class Java2DImageHandlerGraphics2D
implements ImageHandler {
    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageGraphics2D.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return new ImageFlavor[]{ImageFlavor.GRAPHICS2D};
    }

    public void handleImage(RenderingContext renderingContext, Image image, Rectangle rectangle) throws IOException {
        Java2DRenderingContext java2DRenderingContext = (Java2DRenderingContext)renderingContext;
        ImageInfo imageInfo = image.getInfo();
        ImageGraphics2D imageGraphics2D = (ImageGraphics2D)image;
        Dimension dimension = imageInfo.getSize().getDimensionMpt();
        Graphics2D graphics2D = (Graphics2D)java2DRenderingContext.getGraphics2D().create();
        graphics2D.translate(rectangle.x, rectangle.y);
        double d = (double)rectangle.width / dimension.getWidth();
        double d2 = (double)rectangle.height / dimension.getHeight();
        graphics2D.scale(d, d2);
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, dimension.getWidth(), dimension.getHeight());
        imageGraphics2D.getGraphics2DImagePainter().paint(graphics2D, (Rectangle2D)double_);
        graphics2D.dispose();
    }

    public boolean isCompatible(RenderingContext renderingContext, Image image) {
        return (image == null || image instanceof ImageGraphics2D) && renderingContext instanceof Java2DRenderingContext;
    }
}

