/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.xmlgraphics.java2d.color.ColorUtil;

public class Java2DGraphicsState {
    private Graphics2D currentGraphics;
    private BasicStroke currentStroke;
    private float currentStrokeWidth;
    private int currentStrokeStyle;
    private FontInfo fontInfo;
    private AffineTransform initialTransform;

    public Java2DGraphicsState(Graphics2D graphics2D, FontInfo fontInfo, AffineTransform affineTransform) {
        this.fontInfo = fontInfo;
        this.currentGraphics = graphics2D;
        this.initialTransform = affineTransform;
        this.currentGraphics.setTransform(affineTransform);
    }

    public Java2DGraphicsState(Java2DGraphicsState java2DGraphicsState) {
        this.currentGraphics = (Graphics2D)java2DGraphicsState.currentGraphics.create();
        this.fontInfo = java2DGraphicsState.fontInfo;
        this.initialTransform = java2DGraphicsState.initialTransform;
        this.currentStroke = java2DGraphicsState.currentStroke;
        this.currentStrokeStyle = java2DGraphicsState.currentStrokeStyle;
        this.currentStrokeWidth = java2DGraphicsState.currentStrokeWidth;
    }

    public Graphics2D getGraph() {
        return this.currentGraphics;
    }

    public void dispose() {
        this.currentGraphics.dispose();
        this.currentGraphics = null;
    }

    public boolean updateColor(Color color) {
        if (!ColorUtil.isSameColor((Color)color, (Color)this.getGraph().getColor())) {
            this.getGraph().setColor(color);
            return true;
        }
        return false;
    }

    public Color getColor() {
        return this.currentGraphics.getColor();
    }

    public boolean updateFont(String string, int n) {
        boolean bl;
        FontMetricsMapper fontMetricsMapper = (FontMetricsMapper)this.fontInfo.getMetricsFor(string);
        boolean bl2 = !fontMetricsMapper.getFontName().equals(this.getGraph().getFont().getFontName());
        boolean bl3 = bl = n != this.getGraph().getFont().getSize() * 1000;
        if (bl2 || bl) {
            Font font = fontMetricsMapper.getFont(n);
            this.currentGraphics.setFont(font);
            return true;
        }
        return false;
    }

    public Font getFont() {
        return this.currentGraphics.getFont();
    }

    public boolean updateStroke(float f, int n) {
        boolean bl = false;
        if (f != this.currentStrokeWidth || n != this.currentStrokeStyle) {
            bl = true;
            switch (n) {
                case 36: {
                    this.currentStroke = new BasicStroke(f, 1, 2, 0.0f, new float[]{0.0f, 2.0f * f}, f);
                    this.currentGraphics.setStroke(this.currentStroke);
                    this.currentStrokeWidth = f;
                    this.currentStrokeStyle = n;
                    break;
                }
                case 31: {
                    this.currentStroke = new BasicStroke(f, 0, 2, 0.0f, new float[]{8.0f, 2.0f}, 0.0f);
                    this.currentGraphics.setStroke(this.currentStroke);
                    this.currentStrokeWidth = f;
                    this.currentStrokeStyle = n;
                    break;
                }
                default: {
                    this.currentStroke = new BasicStroke(f);
                    this.currentGraphics.setStroke(this.currentStroke);
                    this.currentStrokeWidth = f;
                    this.currentStrokeStyle = n;
                }
            }
        }
        return bl;
    }

    public BasicStroke getStroke() {
        return (BasicStroke)this.currentGraphics.getStroke();
    }

    public boolean updatePaint(Paint paint) {
        Paint paint2 = this.getGraph().getPaint();
        if (paint2 == null) {
            if (paint != null) {
                this.getGraph().setPaint(paint);
                return true;
            }
        } else if (paint instanceof Color && paint2 instanceof Color) {
            if (!ColorUtil.isSameColor((Color)((Color)paint), (Color)((Color)paint2))) {
                this.getGraph().setPaint(paint);
                return true;
            }
        } else if (!paint.equals(paint2)) {
            this.getGraph().setPaint(paint);
            return true;
        }
        return false;
    }

    public boolean updateClip(Shape shape) {
        if (this.getGraph().getClip() != null) {
            Area area = new Area(this.getGraph().getClip());
            area.intersect(new Area(shape));
            this.getGraph().setClip(new GeneralPath(area));
        } else {
            this.getGraph().setClip(shape);
        }
        return true;
    }

    public void transform(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.getGraph().transform(affineTransform);
        }
    }

    public AffineTransform getTransform() {
        return this.getGraph().getTransform();
    }

    public String toString() {
        String string = "Java2DGraphicsState " + this.currentGraphics.toString() + ", Stroke (width: " + this.currentStrokeWidth + " style: " + this.currentStrokeStyle + "), " + this.getTransform();
        return string;
    }
}

