/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate.extensions;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.apache.fop.render.intermediate.extensions.GoToXYAction;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.render.intermediate.extensions.URIAction;
import org.apache.fop.util.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentNavigationHandler
extends DefaultHandler
implements DocumentNavigationExtensionConstants {
    protected static final Log log = LogFactory.getLog(DocumentNavigationHandler.class);
    private StringBuffer content = new StringBuffer();
    private Stack objectStack = new Stack();
    private IFDocumentNavigationHandler navHandler;
    private StructureTreeElement structureTreeElement;
    private Map<String, StructureTreeElement> structureTreeElements;

    public DocumentNavigationHandler(IFDocumentNavigationHandler iFDocumentNavigationHandler, Map<String, StructureTreeElement> map) {
        this.navHandler = iFDocumentNavigationHandler;
        assert (map != null);
        this.structureTreeElements = map;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        boolean bl = false;
        if ("http://xmlgraphics.apache.org/fop/intermediate/document-navigation".equals(string)) {
            if (BOOKMARK_TREE.getLocalName().equals(string2)) {
                if (!this.objectStack.isEmpty()) {
                    throw new SAXException(string2 + " must be the root element!");
                }
                BookmarkTree bookmarkTree = new BookmarkTree();
                this.objectStack.push(bookmarkTree);
            } else if (BOOKMARK.getLocalName().equals(string2)) {
                String string4 = attributes.getValue("title");
                String string5 = attributes.getValue("starting-state");
                boolean bl2 = !"hide".equals(string5);
                Bookmark bookmark = new Bookmark(string4, bl2, null);
                Object e = this.objectStack.peek();
                if (e instanceof AbstractAction) {
                    AbstractAction abstractAction = (AbstractAction)this.objectStack.pop();
                    e = this.objectStack.peek();
                    ((Bookmark)e).setAction(abstractAction);
                }
                if (e instanceof BookmarkTree) {
                    ((BookmarkTree)e).addBookmark(bookmark);
                } else {
                    ((Bookmark)e).addChildBookmark(bookmark);
                }
                this.objectStack.push(bookmark);
            } else if (NAMED_DESTINATION.getLocalName().equals(string2)) {
                if (!this.objectStack.isEmpty()) {
                    throw new SAXException(string2 + " must be the root element!");
                }
                String string6 = attributes.getValue("name");
                NamedDestination namedDestination = new NamedDestination(string6, null);
                this.objectStack.push(namedDestination);
            } else if (LINK.getLocalName().equals(string2)) {
                if (!this.objectStack.isEmpty()) {
                    throw new SAXException(string2 + " must be the root element!");
                }
                Rectangle rectangle = XMLUtil.getAttributeAsRectangle(attributes, "rect");
                this.structureTreeElement = this.structureTreeElements.get(attributes.getValue("http://xmlgraphics.apache.org/fop/internal", "struct-ref"));
                Link link = new Link(null, rectangle);
                this.objectStack.push(link);
            } else if (GOTO_XY.getLocalName().equals(string2)) {
                GoToXYAction goToXYAction;
                String string7 = attributes.getValue("idref");
                if (string7 != null) {
                    goToXYAction = new GoToXYAction(string7);
                } else {
                    Point point;
                    String string8 = attributes.getValue("id");
                    int n = XMLUtil.getAttributeAsInt(attributes, "page-index");
                    if (n < 0) {
                        point = null;
                    } else {
                        int n2 = XMLUtil.getAttributeAsInt(attributes, "x");
                        int n3 = XMLUtil.getAttributeAsInt(attributes, "y");
                        point = new Point(n2, n3);
                    }
                    goToXYAction = new GoToXYAction(string8, n, point);
                }
                if (this.structureTreeElement != null) {
                    goToXYAction.setStructureTreeElement(this.structureTreeElement);
                }
                this.objectStack.push(goToXYAction);
            } else if (GOTO_URI.getLocalName().equals(string2)) {
                String string9 = attributes.getValue("id");
                String string10 = attributes.getValue("uri");
                String string11 = attributes.getValue("show-destination");
                boolean bl3 = "new".equals(string11);
                URIAction uRIAction = new URIAction(string10, bl3);
                if (string9 != null) {
                    uRIAction.setID(string9);
                }
                if (this.structureTreeElement != null) {
                    uRIAction.setStructureTreeElement(this.structureTreeElement);
                }
                this.objectStack.push(uRIAction);
            } else {
                throw new SAXException("Invalid element '" + string2 + "' in namespace: " + string);
            }
            bl = true;
        }
        if (!bl) {
            if ("http://xmlgraphics.apache.org/fop/intermediate/document-navigation".equals(string)) {
                throw new SAXException("Unhandled element '" + string2 + "' in namespace: " + string);
            }
            log.warn((Object)("Unhandled element '" + string2 + "' in namespace: " + string));
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("http://xmlgraphics.apache.org/fop/intermediate/document-navigation".equals(string)) {
            try {
                if (BOOKMARK_TREE.getLocalName().equals(string2)) {
                    BookmarkTree bookmarkTree = (BookmarkTree)this.objectStack.pop();
                    if (this.hasNavigation()) {
                        this.navHandler.renderBookmarkTree(bookmarkTree);
                    }
                } else if (BOOKMARK.getLocalName().equals(string2)) {
                    if (this.objectStack.peek() instanceof AbstractAction) {
                        AbstractAction abstractAction = (AbstractAction)this.objectStack.pop();
                        Bookmark bookmark = (Bookmark)this.objectStack.pop();
                        bookmark.setAction(abstractAction);
                    } else {
                        this.objectStack.pop();
                    }
                } else if (NAMED_DESTINATION.getLocalName().equals(string2)) {
                    AbstractAction abstractAction = (AbstractAction)this.objectStack.pop();
                    NamedDestination namedDestination = (NamedDestination)this.objectStack.pop();
                    namedDestination.setAction(abstractAction);
                    if (this.hasNavigation()) {
                        this.navHandler.renderNamedDestination(namedDestination);
                    }
                } else if (LINK.getLocalName().equals(string2)) {
                    AbstractAction abstractAction = (AbstractAction)this.objectStack.pop();
                    Link link = (Link)this.objectStack.pop();
                    link.setAction(abstractAction);
                    if (this.hasNavigation()) {
                        this.navHandler.renderLink(link);
                    }
                } else if (string2.startsWith("goto-") && this.objectStack.size() == 1) {
                    AbstractAction abstractAction = (AbstractAction)this.objectStack.pop();
                    if (this.hasNavigation()) {
                        this.navHandler.addResolvedAction(abstractAction);
                    }
                }
            }
            catch (IFException iFException) {
                throw new SAXException(iFException);
            }
        }
        this.content.setLength(0);
    }

    private boolean hasNavigation() {
        return this.navHandler != null;
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.content.append(cArray, n, n2);
    }

    @Override
    public void endDocument() throws SAXException {
        assert (this.objectStack.isEmpty());
    }
}

