/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.PrintRendererConfigurator;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.intermediate.AbstractXMLWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFConstants;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFState;
import org.apache.fop.render.intermediate.IFStructureTreeBuilder;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.DocumentNavigationExtensionConstants;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.fop.util.DOM2SAX;
import org.apache.fop.util.LanguageTags;
import org.apache.fop.util.XMLConstants;
import org.apache.fop.util.XMLUtil;
import org.apache.xmlgraphics.java2d.color.ColorUtil;
import org.apache.xmlgraphics.util.QName;
import org.apache.xmlgraphics.util.XMLizable;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class IFSerializer
extends AbstractXMLWritingIFDocumentHandler
implements IFConstants,
IFPainter,
IFDocumentNavigationHandler {
    public static final String VERSION = "2.0";
    private IFDocumentHandler mimicHandler;
    private int pageSequenceIndex;
    private IFState state;
    private String currentID = "";
    private IFStructureTreeBuilder structureTreeBuilder;
    private Map incompleteActions = new HashMap();
    private List completeActions = new LinkedList();

    protected String getMainNamespace() {
        return "http://xmlgraphics.apache.org/fop/intermediate";
    }

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "application/X-fop-intermediate-format";
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        if (this.mimicHandler != null) {
            return this.getMimickedDocumentHandler().getConfigurator();
        }
        return new PrintRendererConfigurator(this.getUserAgent());
    }

    public IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this;
    }

    public void mimicDocumentHandler(IFDocumentHandler iFDocumentHandler) {
        this.mimicHandler = iFDocumentHandler;
    }

    public IFDocumentHandler getMimickedDocumentHandler() {
        return this.mimicHandler;
    }

    public FontInfo getFontInfo() {
        if (this.mimicHandler != null) {
            return this.mimicHandler.getFontInfo();
        }
        return null;
    }

    public void setFontInfo(FontInfo fontInfo) {
        if (this.mimicHandler != null) {
            this.mimicHandler.setFontInfo(fontInfo);
        }
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        if (this.mimicHandler != null) {
            this.mimicHandler.setDefaultFontInfo(fontInfo);
        }
    }

    public StructureTreeEventHandler getStructureTreeEventHandler() {
        if (this.structureTreeBuilder == null) {
            this.structureTreeBuilder = new IFStructureTreeBuilder();
        }
        return this.structureTreeBuilder;
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.handler.startDocument();
            this.handler.startPrefixMapping("", "http://xmlgraphics.apache.org/fop/intermediate");
            this.handler.startPrefixMapping("xlink", "http://www.w3.org/1999/xlink");
            this.handler.startPrefixMapping("nav", "http://xmlgraphics.apache.org/fop/intermediate/document-navigation");
            this.handler.startPrefixMapping("foi", "http://xmlgraphics.apache.org/fop/internal");
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "version", VERSION);
            this.handler.startElement("document", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startDocument()", sAXException);
        }
    }

    public void setDocumentLocale(Locale locale) {
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", LanguageTags.toLanguageTag(locale));
        try {
            this.handler.startElement("locale", (Attributes)attributesImpl);
            this.handler.endElement("locale");
        }
        catch (SAXException sAXException) {
            throw new RuntimeException("Unable to create the locale element.", sAXException);
        }
    }

    public void startDocumentHeader() throws IFException {
        try {
            this.handler.startElement("header");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startDocumentHeader()", sAXException);
        }
    }

    public void endDocumentHeader() throws IFException {
        try {
            this.handler.endElement("header");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startDocumentHeader()", sAXException);
        }
    }

    public void startDocumentTrailer() throws IFException {
        try {
            this.handler.startElement("trailer");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startDocumentTrailer()", sAXException);
        }
    }

    public void endDocumentTrailer() throws IFException {
        try {
            this.handler.endElement("trailer");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endDocumentTrailer()", sAXException);
        }
    }

    public void endDocument() throws IFException {
        try {
            this.handler.endElement("document");
            this.handler.endDocument();
            this.finishDocumentNavigation();
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endDocument()", sAXException);
        }
    }

    public void startPageSequence(String string) throws IFException {
        try {
            Locale locale;
            AttributesImpl attributesImpl = new AttributesImpl();
            if (string != null) {
                attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "id", "xml:id", "CDATA", string);
            }
            if ((locale = this.getContext().getLanguage()) != null) {
                attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "lang", "xml:lang", "CDATA", LanguageTags.toLanguageTag(locale));
            }
            XMLUtil.addAttribute(attributesImpl, XMLConstants.XML_SPACE, "preserve");
            this.addForeignAttributes(attributesImpl);
            this.handler.startElement("page-sequence", (Attributes)attributesImpl);
            if (this.getUserAgent().isAccessibilityEnabled()) {
                assert (this.structureTreeBuilder != null);
                this.structureTreeBuilder.replayEventsForPageSequence(this.handler, this.pageSequenceIndex++);
            }
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startPageSequence()", sAXException);
        }
    }

    public void endPageSequence() throws IFException {
        try {
            this.handler.endElement("page-sequence");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endPageSequence()", sAXException);
        }
    }

    public void startPage(int n, String string, String string2, Dimension dimension) throws IFException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "index", Integer.toString(n));
            this.addAttribute(attributesImpl, "name", string);
            this.addAttribute(attributesImpl, "page-master-name", string2);
            this.addAttribute(attributesImpl, "width", Integer.toString(dimension.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(dimension.height));
            this.addForeignAttributes(attributesImpl);
            this.handler.startElement("page", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startPage()", sAXException);
        }
    }

    public void startPageHeader() throws IFException {
        try {
            this.handler.startElement("page-header");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startPageHeader()", sAXException);
        }
    }

    public void endPageHeader() throws IFException {
        try {
            this.handler.endElement("page-header");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endPageHeader()", sAXException);
        }
    }

    public IFPainter startPageContent() throws IFException {
        try {
            this.handler.startElement("content");
            this.state = IFState.create();
            return this;
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startPageContent()", sAXException);
        }
    }

    public void endPageContent() throws IFException {
        try {
            this.state = null;
            this.currentID = "";
            this.handler.endElement("content");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endPageContent()", sAXException);
        }
    }

    public void startPageTrailer() throws IFException {
        try {
            this.handler.startElement("page-trailer");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startPageTrailer()", sAXException);
        }
    }

    public void endPageTrailer() throws IFException {
        try {
            this.commitNavigation();
            this.handler.endElement("page-trailer");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endPageTrailer()", sAXException);
        }
    }

    public void endPage() throws IFException {
        try {
            this.handler.endElement("page");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endPage()", sAXException);
        }
    }

    public void startViewport(AffineTransform affineTransform, Dimension dimension, Rectangle rectangle) throws IFException {
        this.startViewport(IFUtil.toString(affineTransform), dimension, rectangle);
    }

    public void startViewport(AffineTransform[] affineTransformArray, Dimension dimension, Rectangle rectangle) throws IFException {
        this.startViewport(IFUtil.toString(affineTransformArray), dimension, rectangle);
    }

    private void startViewport(String string, Dimension dimension, Rectangle rectangle) throws IFException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            if (string != null && string.length() > 0) {
                this.addAttribute(attributesImpl, "transform", string);
            }
            this.addAttribute(attributesImpl, "width", Integer.toString(dimension.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(dimension.height));
            if (rectangle != null) {
                this.addAttribute(attributesImpl, "clip-rect", IFUtil.toString(rectangle));
            }
            this.handler.startElement("viewport", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startViewport()", sAXException);
        }
    }

    public void endViewport() throws IFException {
        try {
            this.handler.endElement("viewport");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endViewport()", sAXException);
        }
    }

    public void startGroup(AffineTransform[] affineTransformArray) throws IFException {
        this.startGroup(IFUtil.toString(affineTransformArray));
    }

    public void startGroup(AffineTransform affineTransform) throws IFException {
        this.startGroup(IFUtil.toString(affineTransform));
    }

    private void startGroup(String string) throws IFException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            if (string != null && string.length() > 0) {
                this.addAttribute(attributesImpl, "transform", string);
            }
            this.handler.startElement("g", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startGroup()", sAXException);
        }
    }

    public void endGroup() throws IFException {
        try {
            this.handler.endElement("g");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in endGroup()", sAXException);
        }
    }

    public void drawImage(String string, Rectangle rectangle) throws IFException {
        try {
            this.addID();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, XLINK_HREF, string);
            this.addAttribute(attributesImpl, "x", Integer.toString(rectangle.x));
            this.addAttribute(attributesImpl, "y", Integer.toString(rectangle.y));
            this.addAttribute(attributesImpl, "width", Integer.toString(rectangle.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(rectangle.height));
            this.addForeignAttributes(attributesImpl);
            this.addStructureReference(attributesImpl);
            this.handler.element("image", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startGroup()", sAXException);
        }
    }

    private void addForeignAttributes(AttributesImpl attributesImpl) throws SAXException {
        Map map = this.getContext().getForeignAttributes();
        if (!map.isEmpty()) {
            for (Map.Entry entry : map.entrySet()) {
                this.addAttribute(attributesImpl, (QName)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    public void drawImage(Document document, Rectangle rectangle) throws IFException {
        try {
            this.addID();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "x", Integer.toString(rectangle.x));
            this.addAttribute(attributesImpl, "y", Integer.toString(rectangle.y));
            this.addAttribute(attributesImpl, "width", Integer.toString(rectangle.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(rectangle.height));
            this.addForeignAttributes(attributesImpl);
            this.addStructureReference(attributesImpl);
            this.handler.startElement("image", (Attributes)attributesImpl);
            new DOM2SAX(this.handler).writeDocument(document, true);
            this.handler.endElement("image");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in startGroup()", sAXException);
        }
    }

    private static String toString(Paint paint) {
        if (paint instanceof Color) {
            return org.apache.fop.util.ColorUtil.colorToString((Color)paint);
        }
        throw new UnsupportedOperationException("Paint not supported: " + paint);
    }

    public void clipRect(Rectangle rectangle) throws IFException {
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "x", Integer.toString(rectangle.x));
            this.addAttribute(attributesImpl, "y", Integer.toString(rectangle.y));
            this.addAttribute(attributesImpl, "width", Integer.toString(rectangle.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(rectangle.height));
            this.handler.element("clip-rect", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in clipRect()", sAXException);
        }
    }

    public void fillRect(Rectangle rectangle, Paint paint) throws IFException {
        if (paint == null) {
            return;
        }
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "x", Integer.toString(rectangle.x));
            this.addAttribute(attributesImpl, "y", Integer.toString(rectangle.y));
            this.addAttribute(attributesImpl, "width", Integer.toString(rectangle.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(rectangle.height));
            this.addAttribute(attributesImpl, "fill", IFSerializer.toString(paint));
            this.handler.element("rect", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in fillRect()", sAXException);
        }
    }

    public void drawBorderRect(Rectangle rectangle, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4) throws IFException {
        if (borderProps == null && borderProps2 == null && borderProps3 == null && borderProps4 == null) {
            return;
        }
        try {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "x", Integer.toString(rectangle.x));
            this.addAttribute(attributesImpl, "y", Integer.toString(rectangle.y));
            this.addAttribute(attributesImpl, "width", Integer.toString(rectangle.width));
            this.addAttribute(attributesImpl, "height", Integer.toString(rectangle.height));
            if (borderProps != null) {
                this.addAttribute(attributesImpl, "top", borderProps.toString());
            }
            if (borderProps2 != null) {
                this.addAttribute(attributesImpl, "bottom", borderProps2.toString());
            }
            if (borderProps3 != null) {
                this.addAttribute(attributesImpl, "left", borderProps3.toString());
            }
            if (borderProps4 != null) {
                this.addAttribute(attributesImpl, "right", borderProps4.toString());
            }
            this.handler.element("border-rect", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in drawBorderRect()", sAXException);
        }
    }

    public void drawLine(Point point, Point point2, int n, Color color, RuleStyle ruleStyle) throws IFException {
        try {
            this.addID();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "x1", Integer.toString(point.x));
            this.addAttribute(attributesImpl, "y1", Integer.toString(point.y));
            this.addAttribute(attributesImpl, "x2", Integer.toString(point2.x));
            this.addAttribute(attributesImpl, "y2", Integer.toString(point2.y));
            this.addAttribute(attributesImpl, "stroke-width", Integer.toString(n));
            this.addAttribute(attributesImpl, "color", org.apache.fop.util.ColorUtil.colorToString(color));
            this.addAttribute(attributesImpl, "style", ruleStyle.getName());
            this.handler.element("line", (Attributes)attributesImpl);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in drawLine()", sAXException);
        }
    }

    public void drawText(int n, int n2, int n3, int n4, int[][] nArray, String string) throws IFException {
        try {
            Object[] objectArray;
            this.addID();
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "x", Integer.toString(n));
            this.addAttribute(attributesImpl, "y", Integer.toString(n2));
            if (n3 != 0) {
                this.addAttribute(attributesImpl, "letter-spacing", Integer.toString(n3));
            }
            if (n4 != 0) {
                this.addAttribute(attributesImpl, "word-spacing", Integer.toString(n4));
            }
            if (nArray != null && !IFUtil.isDPIdentity(nArray)) {
                if (IFUtil.isDPOnlyDX(nArray)) {
                    objectArray = IFUtil.convertDPToDX(nArray);
                    this.addAttribute(attributesImpl, "dx", IFUtil.toString(objectArray));
                } else {
                    this.addAttribute(attributesImpl, "dp", XMLUtil.encodePositionAdjustments(nArray));
                }
            }
            this.addStructureReference(attributesImpl);
            this.handler.startElement("text", (Attributes)attributesImpl);
            objectArray = string.toCharArray();
            this.handler.characters((char[])objectArray, 0, objectArray.length);
            this.handler.endElement("text");
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in setFont()", sAXException);
        }
    }

    public void setFont(String string, String string2, Integer n, String string3, Integer n2, Color color) throws IFException {
        try {
            boolean bl;
            AttributesImpl attributesImpl = new AttributesImpl();
            if (string != null) {
                boolean bl2 = bl = !string.equals(this.state.getFontFamily());
                if (bl) {
                    this.state.setFontFamily(string);
                    this.addAttribute(attributesImpl, "family", string);
                }
            }
            if (string2 != null) {
                boolean bl3 = bl = !string2.equals(this.state.getFontStyle());
                if (bl) {
                    this.state.setFontStyle(string2);
                    this.addAttribute(attributesImpl, "style", string2);
                }
            }
            if (n != null) {
                boolean bl4 = bl = n.intValue() != this.state.getFontWeight();
                if (bl) {
                    this.state.setFontWeight(n);
                    this.addAttribute(attributesImpl, "weight", n.toString());
                }
            }
            if (string3 != null) {
                boolean bl5 = bl = !string3.equals(this.state.getFontVariant());
                if (bl) {
                    this.state.setFontVariant(string3);
                    this.addAttribute(attributesImpl, "variant", string3);
                }
            }
            if (n2 != null) {
                boolean bl6 = bl = n2.intValue() != this.state.getFontSize();
                if (bl) {
                    this.state.setFontSize(n2);
                    this.addAttribute(attributesImpl, "size", n2.toString());
                }
            }
            if (color != null) {
                boolean bl7 = bl = !ColorUtil.isSameColor((Color)color, (Color)this.state.getTextColor());
                if (bl) {
                    this.state.setTextColor(color);
                    this.addAttribute(attributesImpl, "color", IFSerializer.toString(color));
                }
            }
            if (attributesImpl.getLength() > 0) {
                this.handler.element("font", (Attributes)attributesImpl);
            }
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error in setFont()", sAXException);
        }
    }

    public void handleExtensionObject(Object object) throws IFException {
        if (object instanceof XMLizable) {
            try {
                ((XMLizable)object).toSAX((ContentHandler)this.handler);
            }
            catch (SAXException sAXException) {
                throw new IFException("SAX error while handling extension object", sAXException);
            }
        } else {
            throw new UnsupportedOperationException("Extension must implement XMLizable: " + object + " (" + object.getClass().getName() + ")");
        }
    }

    protected RenderingContext createRenderingContext() throws IllegalStateException {
        throw new IllegalStateException("Should never be called!");
    }

    private void addAttribute(AttributesImpl attributesImpl, QName qName, String string) throws SAXException {
        this.handler.startPrefixMapping(qName.getPrefix(), qName.getNamespaceURI());
        XMLUtil.addAttribute(attributesImpl, qName, string);
    }

    private void addAttribute(AttributesImpl attributesImpl, String string, String string2) {
        XMLUtil.addAttribute(attributesImpl, string, string2);
    }

    private void addStructureReference(AttributesImpl attributesImpl) {
        IFStructureTreeBuilder.IFStructureTreeElement iFStructureTreeElement = (IFStructureTreeBuilder.IFStructureTreeElement)this.getContext().getStructureTreeElement();
        if (iFStructureTreeElement != null) {
            this.addStructRefAttribute(attributesImpl, iFStructureTreeElement.getId());
        }
    }

    private void addStructRefAttribute(AttributesImpl attributesImpl, String string) {
        attributesImpl.addAttribute("http://xmlgraphics.apache.org/fop/internal", "struct-ref", "foi:struct-ref", "CDATA", string);
    }

    private void addID() throws SAXException {
        String string = this.getContext().getID();
        if (!this.currentID.equals(string)) {
            AttributesImpl attributesImpl = new AttributesImpl();
            this.addAttribute(attributesImpl, "name", string);
            this.handler.startElement("id", (Attributes)attributesImpl);
            this.handler.endElement("id");
            this.currentID = string;
        }
    }

    private void noteAction(AbstractAction abstractAction) {
        if (abstractAction == null) {
            throw new NullPointerException("action must not be null");
        }
        if (!abstractAction.isComplete()) {
            assert (abstractAction.hasID());
            this.incompleteActions.put(abstractAction.getID(), abstractAction);
        }
    }

    public void renderNamedDestination(NamedDestination namedDestination) throws IFException {
        this.noteAction(namedDestination.getAction());
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(null, "name", "name", "CDATA", namedDestination.getName());
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.NAMED_DESTINATION, (Attributes)attributesImpl);
            this.serializeXMLizable(namedDestination.getAction());
            this.handler.endElement(DocumentNavigationExtensionConstants.NAMED_DESTINATION);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error serializing named destination", sAXException);
        }
    }

    public void renderBookmarkTree(BookmarkTree bookmarkTree) throws IFException {
        AttributesImpl attributesImpl = new AttributesImpl();
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.BOOKMARK_TREE, (Attributes)attributesImpl);
            for (Bookmark bookmark : bookmarkTree.getBookmarks()) {
                if (bookmark.getAction() == null) continue;
                this.serializeBookmark(bookmark);
            }
            this.handler.endElement(DocumentNavigationExtensionConstants.BOOKMARK_TREE);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error serializing bookmark tree", sAXException);
        }
    }

    private void serializeBookmark(Bookmark bookmark) throws SAXException, IFException {
        this.noteAction(bookmark.getAction());
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(null, "title", "title", "CDATA", bookmark.getTitle());
        attributesImpl.addAttribute(null, "starting-state", "starting-state", "CDATA", bookmark.isShown() ? "show" : "hide");
        this.handler.startElement(DocumentNavigationExtensionConstants.BOOKMARK, (Attributes)attributesImpl);
        this.serializeXMLizable(bookmark.getAction());
        for (Bookmark bookmark2 : bookmark.getChildBookmarks()) {
            if (bookmark2.getAction() == null) continue;
            this.serializeBookmark(bookmark2);
        }
        this.handler.endElement(DocumentNavigationExtensionConstants.BOOKMARK);
    }

    public void renderLink(Link link) throws IFException {
        this.noteAction(link.getAction());
        AttributesImpl attributesImpl = new AttributesImpl();
        attributesImpl.addAttribute(null, "rect", "rect", "CDATA", IFUtil.toString(link.getTargetRect()));
        if (this.getUserAgent().isAccessibilityEnabled()) {
            this.addStructRefAttribute(attributesImpl, ((IFStructureTreeBuilder.IFStructureTreeElement)link.getAction().getStructureTreeElement()).getId());
        }
        try {
            this.handler.startElement(DocumentNavigationExtensionConstants.LINK, (Attributes)attributesImpl);
            this.serializeXMLizable(link.getAction());
            this.handler.endElement(DocumentNavigationExtensionConstants.LINK);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error serializing link", sAXException);
        }
    }

    public void addResolvedAction(AbstractAction abstractAction) throws IFException {
        assert (abstractAction.isComplete());
        assert (abstractAction.hasID());
        AbstractAction abstractAction2 = (AbstractAction)this.incompleteActions.remove(abstractAction.getID());
        if (abstractAction2 != null) {
            this.completeActions.add(abstractAction);
        }
    }

    private void commitNavigation() throws IFException {
        Iterator iterator = this.completeActions.iterator();
        while (iterator.hasNext()) {
            AbstractAction abstractAction = (AbstractAction)iterator.next();
            iterator.remove();
            this.serializeXMLizable(abstractAction);
        }
        assert (this.completeActions.size() == 0);
    }

    private void finishDocumentNavigation() {
        assert (this.incompleteActions.size() == 0) : "Still holding incomplete actions!";
    }

    private void serializeXMLizable(XMLizable xMLizable) throws IFException {
        try {
            xMLizable.toSAX((ContentHandler)this.handler);
        }
        catch (SAXException sAXException) {
            throw new IFException("SAX error serializing object", sAXException);
        }
    }
}

