/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.parser.AWTTransformProducer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.Version;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.AreaTreeObject;
import org.apache.fop.area.Block;
import org.apache.fop.area.BlockViewport;
import org.apache.fop.area.BookmarkData;
import org.apache.fop.area.CTM;
import org.apache.fop.area.DestinationData;
import org.apache.fop.area.OffDocumentExtensionAttachment;
import org.apache.fop.area.OffDocumentItem;
import org.apache.fop.area.PageSequence;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.AbstractTextArea;
import org.apache.fop.area.inline.ForeignObject;
import org.apache.fop.area.inline.Image;
import org.apache.fop.area.inline.InlineArea;
import org.apache.fop.area.inline.InlineParent;
import org.apache.fop.area.inline.InlineViewport;
import org.apache.fop.area.inline.Leader;
import org.apache.fop.area.inline.SpaceArea;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.area.inline.WordArea;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.extensions.xmp.XMPMetadata;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.AbstractPathOrientedRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandler;
import org.apache.fop.render.intermediate.IFDocumentNavigationHandler;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFGraphicContext;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.intermediate.IFSerializer;
import org.apache.fop.render.intermediate.IFUtil;
import org.apache.fop.render.intermediate.extensions.AbstractAction;
import org.apache.fop.render.intermediate.extensions.ActionSet;
import org.apache.fop.render.intermediate.extensions.Bookmark;
import org.apache.fop.render.intermediate.extensions.BookmarkTree;
import org.apache.fop.render.intermediate.extensions.GoToXYAction;
import org.apache.fop.render.intermediate.extensions.Link;
import org.apache.fop.render.intermediate.extensions.NamedDestination;
import org.apache.fop.render.intermediate.extensions.URIAction;
import org.apache.fop.render.pdf.PDFEventProducer;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;
import org.apache.xmlgraphics.xmp.Metadata;
import org.apache.xmlgraphics.xmp.schemas.DublinCoreAdapter;
import org.apache.xmlgraphics.xmp.schemas.DublinCoreSchema;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicAdapter;
import org.apache.xmlgraphics.xmp.schemas.XMPBasicSchema;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class IFRenderer
extends AbstractPathOrientedRenderer {
    protected static final Log log = LogFactory.getLog(IFRenderer.class);
    public static final String IF_MIME_TYPE = "application/X-fop-intermediate-format";
    private IFDocumentHandler documentHandler;
    private IFPainter painter;
    protected Renderer mimic;
    private boolean inPageSequence = false;
    private Stack graphicContextStack = new Stack();
    private Stack viewportDimensionStack = new Stack();
    private IFGraphicContext graphicContext = new IFGraphicContext();
    private Metadata documentMetadata;
    private Map idPositions = new HashMap();
    private List unfinishedGoTos = new ArrayList();
    protected Map pageIndices = new HashMap();
    private BookmarkTree bookmarkTree;
    private List deferredDestinations = new ArrayList();
    private List deferredLinks = new ArrayList();
    private ActionSet actionSet = new ActionSet();
    private TextUtil textUtil = new TextUtil();
    private Stack<String> ids = new Stack();

    public IFRenderer(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public String getMimeType() {
        return IF_MIME_TYPE;
    }

    public void setDocumentHandler(IFDocumentHandler iFDocumentHandler) {
        this.documentHandler = iFDocumentHandler;
    }

    public void setupFontInfo(FontInfo fontInfo) throws FOPException {
        if (this.documentHandler == null) {
            this.documentHandler = this.createDefaultDocumentHandler();
        }
        IFUtil.setupFonts(this.documentHandler, fontInfo);
        this.fontInfo = fontInfo;
    }

    private void handleIFException(IFException iFException) {
        if (iFException.getCause() instanceof SAXException) {
            throw new RuntimeException(iFException.getCause());
        }
        throw new RuntimeException(iFException);
    }

    private void handleIFExceptionWithIOException(IFException iFException) throws IOException {
        if (iFException.getCause() instanceof IOException) {
            throw (IOException)iFException.getCause();
        }
        this.handleIFException(iFException);
    }

    public boolean supportsOutOfOrder() {
        return this.documentHandler != null ? this.documentHandler.supportsPagesOutOfOrder() : false;
    }

    protected IFDocumentNavigationHandler getDocumentNavigationHandler() {
        return this.documentHandler.getDocumentNavigationHandler();
    }

    protected boolean hasDocumentNavigation() {
        return this.getDocumentNavigationHandler() != null;
    }

    protected IFDocumentHandler createDefaultDocumentHandler() {
        IFSerializer iFSerializer = new IFSerializer();
        FOUserAgent fOUserAgent = this.getUserAgent();
        iFSerializer.setContext(new IFContext(fOUserAgent));
        if (fOUserAgent.isAccessibilityEnabled()) {
            fOUserAgent.setStructureTreeEventHandler(iFSerializer.getStructureTreeEventHandler());
        }
        return iFSerializer;
    }

    public void startRenderer(OutputStream outputStream) throws IOException {
        try {
            if (outputStream != null) {
                StreamResult streamResult = new StreamResult(outputStream);
                if (this.getUserAgent().getOutputFile() != null) {
                    streamResult.setSystemId(this.getUserAgent().getOutputFile().toURI().toURL().toExternalForm());
                }
                if (this.documentHandler == null) {
                    this.documentHandler = this.createDefaultDocumentHandler();
                }
                this.documentHandler.setResult(streamResult);
            }
            super.startRenderer(null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rendering areas via IF document handler (" + this.documentHandler.getClass().getName() + ")..."));
            }
            this.documentHandler.startDocument();
            this.documentHandler.startDocumentHeader();
        }
        catch (IFException iFException) {
            this.handleIFExceptionWithIOException(iFException);
        }
    }

    public void stopRenderer() throws IOException {
        try {
            if (this.inPageSequence) {
                this.documentHandler.endPageSequence();
                this.inPageSequence = false;
            }
            this.documentHandler.startDocumentTrailer();
            if (this.hasDocumentNavigation()) {
                this.finishOpenGoTos();
                Iterator iterator = this.deferredDestinations.iterator();
                while (iterator.hasNext()) {
                    NamedDestination namedDestination = (NamedDestination)iterator.next();
                    iterator.remove();
                    this.getDocumentNavigationHandler().renderNamedDestination(namedDestination);
                }
                if (this.bookmarkTree != null) {
                    this.getDocumentNavigationHandler().renderBookmarkTree(this.bookmarkTree);
                }
            }
            this.documentHandler.endDocumentTrailer();
            this.documentHandler.endDocument();
        }
        catch (IFException iFException) {
            this.handleIFExceptionWithIOException(iFException);
        }
        this.pageIndices.clear();
        this.idPositions.clear();
        this.actionSet.clear();
        super.stopRenderer();
        log.debug((Object)"Rendering finished.");
    }

    public void setDocumentLocale(Locale locale) {
        this.documentHandler.setDocumentLocale(locale);
    }

    public void processOffDocumentItem(OffDocumentItem offDocumentItem) {
        if (offDocumentItem instanceof DestinationData) {
            this.renderDestination((DestinationData)offDocumentItem);
        } else if (offDocumentItem instanceof BookmarkData) {
            this.renderBookmarkTree((BookmarkData)offDocumentItem);
        } else if (offDocumentItem instanceof OffDocumentExtensionAttachment) {
            ExtensionAttachment extensionAttachment = ((OffDocumentExtensionAttachment)offDocumentItem).getAttachment();
            if ("adobe:ns:meta/".equals(extensionAttachment.getCategory())) {
                this.renderXMPMetadata((XMPMetadata)extensionAttachment);
            } else {
                try {
                    this.documentHandler.handleExtensionObject(extensionAttachment);
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
        }
    }

    private void renderDestination(DestinationData destinationData) {
        if (!this.hasDocumentNavigation()) {
            return;
        }
        String string = destinationData.getIDRef();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("DestinationData must contain a ID reference");
        }
        PageViewport pageViewport = destinationData.getPageViewport();
        if (pageViewport != null) {
            GoToXYAction goToXYAction = this.getGoToActionForID(string, pageViewport.getPageIndex());
            NamedDestination namedDestination = new NamedDestination(string, goToXYAction);
            this.deferredDestinations.add(namedDestination);
        } else {
            log.debug((Object)("Unresolved destination item received: " + destinationData.getIDRef()));
        }
    }

    protected void renderBookmarkTree(BookmarkData bookmarkData) {
        assert (this.bookmarkTree == null);
        if (!this.hasDocumentNavigation()) {
            return;
        }
        this.bookmarkTree = new BookmarkTree();
        for (int i = 0; i < bookmarkData.getCount(); ++i) {
            BookmarkData bookmarkData2 = bookmarkData.getSubData(i);
            Bookmark bookmark = this.renderBookmarkItem(bookmarkData2);
            this.bookmarkTree.addBookmark(bookmark);
        }
    }

    private Bookmark renderBookmarkItem(BookmarkData bookmarkData) {
        String string = bookmarkData.getIDRef();
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("DestinationData must contain a ID reference");
        }
        GoToXYAction goToXYAction = null;
        PageViewport pageViewport = bookmarkData.getPageViewport();
        if (pageViewport != null) {
            goToXYAction = this.getGoToActionForID(string, pageViewport.getPageIndex());
        } else {
            log.debug((Object)("Bookmark with IDRef \"" + string + "\" has a null PageViewport."));
        }
        Bookmark bookmark = new Bookmark(bookmarkData.getBookmarkTitle(), bookmarkData.showChildItems(), goToXYAction);
        for (int i = 0; i < bookmarkData.getCount(); ++i) {
            bookmark.addChildBookmark(this.renderBookmarkItem(bookmarkData.getSubData(i)));
        }
        return bookmark;
    }

    private void renderXMPMetadata(XMPMetadata xMPMetadata) {
        this.documentMetadata = xMPMetadata.getMetadata();
    }

    private GoToXYAction getGoToActionForID(String string, int n) {
        GoToXYAction goToXYAction = (GoToXYAction)this.actionSet.get(string);
        if (goToXYAction == null) {
            if (n < 0) {
                // empty if block
            }
            Point point = (Point)this.idPositions.get(string);
            if (n >= 0 && point != null) {
                goToXYAction = new GoToXYAction(string, n, point);
            } else {
                goToXYAction = new GoToXYAction(string, n, null);
                this.unfinishedGoTos.add(goToXYAction);
            }
            goToXYAction = (GoToXYAction)this.actionSet.put(goToXYAction);
        }
        return goToXYAction;
    }

    private void finishOpenGoTos() {
        int n = this.unfinishedGoTos.size();
        if (n > 0) {
            Object object;
            Point point = new Point(0, 0);
            while (!this.unfinishedGoTos.isEmpty()) {
                object = (GoToXYAction)this.unfinishedGoTos.get(0);
                this.noteGoToPosition((GoToXYAction)object, point);
            }
            object = PDFEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
            object.nonFullyResolvedLinkTargets(this, n);
        }
    }

    private void noteGoToPosition(GoToXYAction goToXYAction, Point point) {
        goToXYAction.setTargetLocation(point);
        try {
            this.getDocumentNavigationHandler().addResolvedAction(goToXYAction);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
        this.unfinishedGoTos.remove(goToXYAction);
    }

    private void noteGoToPosition(GoToXYAction goToXYAction, PageViewport pageViewport, Point point) {
        goToXYAction.setPageIndex(pageViewport.getPageIndex());
        this.noteGoToPosition(goToXYAction, point);
    }

    private void saveAbsolutePosition(String string, PageViewport pageViewport, int n, int n2, AffineTransform affineTransform) {
        Point point = new Point(n, n2);
        affineTransform.transform(point, point);
        this.idPositions.put(string, point);
        GoToXYAction goToXYAction = (GoToXYAction)this.actionSet.get(string);
        if (goToXYAction != null) {
            this.noteGoToPosition(goToXYAction, pageViewport, point);
        }
    }

    private void saveAbsolutePosition(String string, int n, int n2) {
        this.saveAbsolutePosition(string, this.currentPageViewport, n, n2, this.graphicContext.getTransform());
    }

    private void saveBlockPosIfTargetable(Block block) {
        String string = this.getTargetableID(block);
        if (this.hasDocumentNavigation() && string != null) {
            int n = block.getXOffset();
            int n2 = block.getYOffset() + block.getSpaceBefore();
            int n3 = block.getPositioning();
            if (n3 != 3 && n3 != 2) {
                n += this.currentIPPosition;
                n2 += this.currentBPPosition;
            }
            this.saveAbsolutePosition(string, this.currentPageViewport, n, n2, this.graphicContext.getTransform());
        }
    }

    private void saveInlinePosIfTargetable(InlineArea inlineArea) {
        String string = this.getTargetableID(inlineArea);
        if (this.hasDocumentNavigation() && string != null) {
            int n = 5000;
            int n2 = this.currentIPPosition;
            int n3 = this.currentBPPosition + inlineArea.getBlockProgressionOffset() - n;
            this.saveAbsolutePosition(string, n2, n3);
        }
    }

    private String getTargetableID(Area area) {
        String string = (String)area.getTrait(Trait.PROD_ID);
        if (string == null || string.length() == 0 || !this.currentPageViewport.isFirstWithID(string) || this.idPositions.containsKey(string)) {
            return null;
        }
        return string;
    }

    public void startPageSequence(PageSequence pageSequence) {
        try {
            if (this.inPageSequence) {
                this.documentHandler.endPageSequence();
                this.documentHandler.getContext().setLanguage(null);
            } else {
                if (this.documentMetadata == null) {
                    this.documentMetadata = this.createDefaultDocumentMetadata();
                }
                this.documentHandler.handleExtensionObject(this.documentMetadata);
                this.documentHandler.endDocumentHeader();
                this.inPageSequence = true;
            }
            this.establishForeignAttributes(pageSequence.getForeignAttributes());
            this.documentHandler.getContext().setLanguage(this.toLocale(pageSequence));
            this.documentHandler.startPageSequence(null);
            this.resetForeignAttributes();
            this.processExtensionAttachments(pageSequence);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    private Locale toLocale(PageSequence pageSequence) {
        if (pageSequence.getLanguage() != null) {
            if (pageSequence.getCountry() != null) {
                return new Locale(pageSequence.getLanguage(), pageSequence.getCountry());
            }
            return new Locale(pageSequence.getLanguage());
        }
        return null;
    }

    private Metadata createDefaultDocumentMetadata() {
        Metadata metadata = new Metadata();
        DublinCoreAdapter dublinCoreAdapter = DublinCoreSchema.getAdapter((Metadata)metadata);
        if (this.getUserAgent().getTitle() != null) {
            dublinCoreAdapter.setTitle(this.getUserAgent().getTitle());
        }
        if (this.getUserAgent().getAuthor() != null) {
            dublinCoreAdapter.addCreator(this.getUserAgent().getAuthor());
        }
        if (this.getUserAgent().getKeywords() != null) {
            dublinCoreAdapter.addSubject(this.getUserAgent().getKeywords());
        }
        XMPBasicAdapter xMPBasicAdapter = XMPBasicSchema.getAdapter((Metadata)metadata);
        if (this.getUserAgent().getProducer() != null) {
            xMPBasicAdapter.setCreatorTool(this.getUserAgent().getProducer());
        } else {
            xMPBasicAdapter.setCreatorTool(Version.getVersion());
        }
        xMPBasicAdapter.setMetadataDate(new Date());
        if (this.getUserAgent().getCreationDate() != null) {
            xMPBasicAdapter.setCreateDate(this.getUserAgent().getCreationDate());
        } else {
            xMPBasicAdapter.setCreateDate(xMPBasicAdapter.getMetadataDate());
        }
        return metadata;
    }

    public void preparePage(PageViewport pageViewport) {
        super.preparePage(pageViewport);
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderPage() " + pageViewport));
        }
        try {
            this.pageIndices.put(pageViewport.getKey(), new Integer(pageViewport.getPageIndex()));
            Rectangle rectangle = pageViewport.getViewArea();
            Dimension dimension = new Dimension(rectangle.width, rectangle.height);
            this.establishForeignAttributes(pageViewport.getForeignAttributes());
            this.documentHandler.startPage(pageViewport.getPageIndex(), pageViewport.getPageNumberString(), pageViewport.getSimplePageMasterName(), dimension);
            this.resetForeignAttributes();
            this.documentHandler.startPageHeader();
            this.processExtensionAttachments(pageViewport);
            this.documentHandler.endPageHeader();
            this.painter = this.documentHandler.startPageContent();
            super.renderPage(pageViewport);
            this.painter = null;
            this.documentHandler.endPageContent();
            this.documentHandler.startPageTrailer();
            if (this.hasDocumentNavigation()) {
                Iterator iterator = this.deferredLinks.iterator();
                while (iterator.hasNext()) {
                    Link link = (Link)iterator.next();
                    iterator.remove();
                    this.getDocumentNavigationHandler().renderLink(link);
                }
            }
            this.documentHandler.endPageTrailer();
            this.establishForeignAttributes(pageViewport.getForeignAttributes());
            this.documentHandler.endPage();
            this.resetForeignAttributes();
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    private void processExtensionAttachments(AreaTreeObject areaTreeObject) throws IFException {
        if (areaTreeObject.hasExtensionAttachments()) {
            for (ExtensionAttachment extensionAttachment : areaTreeObject.getExtensionAttachments()) {
                this.documentHandler.handleExtensionObject(extensionAttachment);
            }
        }
    }

    private void establishForeignAttributes(Map map) {
        this.documentHandler.getContext().setForeignAttributes(map);
    }

    private void resetForeignAttributes() {
        this.documentHandler.getContext().resetForeignAttributes();
    }

    private void establishStructureTreeElement(StructureTreeElement structureTreeElement) {
        this.documentHandler.getContext().setStructureTreeElement(structureTreeElement);
    }

    private void resetStructurePointer() {
        this.documentHandler.getContext().resetStructureTreeElement();
    }

    protected void saveGraphicsState() {
        this.graphicContextStack.push(this.graphicContext);
        this.graphicContext = (IFGraphicContext)((Object)this.graphicContext.clone());
    }

    protected void restoreGraphicsState() {
        while (this.graphicContext.getGroupStackSize() > 0) {
            IFGraphicContext.Group[] groupArray = this.graphicContext.dropGroups();
            for (int i = groupArray.length - 1; i >= 0; --i) {
                try {
                    groupArray[i].end(this.painter);
                    continue;
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
        }
        this.graphicContext = (IFGraphicContext)((Object)this.graphicContextStack.pop());
    }

    private void pushGroup(IFGraphicContext.Group group) {
        this.graphicContext.pushGroup(group);
        try {
            group.start(this.painter);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected List breakOutOfStateStack() {
        log.debug((Object)"Block.FIXED --> break out");
        ArrayList<IFGraphicContext> arrayList = new ArrayList<IFGraphicContext>();
        while (!this.graphicContextStack.empty()) {
            IFGraphicContext.Group[] groupArray = this.graphicContext.getGroups();
            for (int i = groupArray.length - 1; i >= 0; --i) {
                try {
                    groupArray[i].end(this.painter);
                    continue;
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
            arrayList.add(0, this.graphicContext);
            this.graphicContext = (IFGraphicContext)((Object)this.graphicContextStack.pop());
        }
        return arrayList;
    }

    protected void restoreStateStackAfterBreakOut(List list) {
        log.debug((Object)"Block.FIXED --> restoring context after break-out");
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            this.graphicContextStack.push(this.graphicContext);
            this.graphicContext = (IFGraphicContext)((Object)list.get(i));
            IFGraphicContext.Group[] groupArray = this.graphicContext.getGroups();
            int n2 = groupArray.length;
            for (int j = 0; j < n2; ++j) {
                try {
                    groupArray[j].start(this.painter);
                    continue;
                }
                catch (IFException iFException) {
                    this.handleIFException(iFException);
                }
            }
        }
        log.debug((Object)"restored.");
    }

    protected void concatenateTransformationMatrix(AffineTransform affineTransform) {
        if (!affineTransform.isIdentity()) {
            this.concatenateTransformationMatrixMpt(this.ptToMpt(affineTransform), false);
        }
    }

    private void concatenateTransformationMatrixMpt(AffineTransform affineTransform, boolean bl) {
        if (bl || !affineTransform.isIdentity()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("-----concatenateTransformationMatrix: " + affineTransform));
            }
            IFGraphicContext.Group group = new IFGraphicContext.Group(affineTransform);
            this.pushGroup(group);
        }
    }

    protected void beginTextObject() {
    }

    protected void endTextObject() {
    }

    protected void renderRegionViewport(RegionViewport regionViewport) {
        Dimension dimension = new Dimension(regionViewport.getIPD(), regionViewport.getBPD());
        this.viewportDimensionStack.push(dimension);
        super.renderRegionViewport(regionViewport);
        this.viewportDimensionStack.pop();
    }

    protected void renderBlockViewport(BlockViewport blockViewport, List list) {
        Dimension dimension = new Dimension(blockViewport.getIPD(), blockViewport.getBPD());
        this.viewportDimensionStack.push(dimension);
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition;
        CTM cTM = blockViewport.getCTM();
        int n3 = blockViewport.getBorderAndPaddingWidthStart();
        int n4 = blockViewport.getBorderAndPaddingWidthBefore();
        if (blockViewport.getPositioning() == 2 || blockViewport.getPositioning() == 3) {
            List list2 = null;
            if (blockViewport.getPositioning() == 3) {
                list2 = this.breakOutOfStateStack();
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(blockViewport.getXOffset(), blockViewport.getYOffset());
            affineTransform.translate(-n3, -n4);
            String string = blockViewport.getForeignAttributeValue(FOX_TRANSFORM);
            if (string != null) {
                AffineTransform affineTransform2 = AWTTransformProducer.createAffineTransform((String)string);
                affineTransform.concatenate(affineTransform2);
            }
            this.saveGraphicsState();
            this.concatenateTransformationMatrixMpt(affineTransform, false);
            float f = n3 + blockViewport.getBorderAndPaddingWidthEnd();
            float f2 = n4 + blockViewport.getBorderAndPaddingWidthAfter();
            this.drawBackAndBorders(blockViewport, 0.0f, 0.0f, ((float)dimension.width + f) / 1000.0f, ((float)dimension.height + f2) / 1000.0f);
            AffineTransform affineTransform3 = new AffineTransform();
            affineTransform3.translate(n3, n4);
            this.concatenateTransformationMatrixMpt(affineTransform3, false);
            AffineTransform affineTransform4 = cTM.toAffineTransform();
            this.startViewport(affineTransform4, blockViewport.getClipRectangle());
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(blockViewport, list);
            this.endViewport();
            this.restoreGraphicsState();
            if (list2 != null) {
                this.restoreStateStackAfterBreakOut(list2);
            }
            this.currentIPPosition = n;
            this.currentBPPosition = n2;
        } else {
            this.currentBPPosition += blockViewport.getSpaceBefore();
            this.handleBlockTraits(blockViewport);
            this.currentIPPosition += blockViewport.getStartIndent();
            CTM cTM2 = new CTM(this.containingIPPosition, this.currentBPPosition);
            cTM = cTM2.multiply(cTM);
            this.currentBPPosition += n4;
            this.startVParea(cTM, blockViewport.getClipRectangle());
            this.currentIPPosition = 0;
            this.currentBPPosition = 0;
            this.renderBlocks(blockViewport, list);
            this.endVParea();
            this.currentIPPosition = n;
            this.currentBPPosition = n2;
            this.currentBPPosition += blockViewport.getAllocBPD();
        }
        this.viewportDimensionStack.pop();
    }

    public void renderInlineViewport(InlineViewport inlineViewport) {
        StructureTreeElement structureTreeElement = (StructureTreeElement)inlineViewport.getTrait(Trait.STRUCTURE_TREE_ELEMENT);
        this.establishStructureTreeElement(structureTreeElement);
        this.pushdID(inlineViewport);
        Dimension dimension = new Dimension(inlineViewport.getIPD(), inlineViewport.getBPD());
        this.viewportDimensionStack.push(dimension);
        super.renderInlineViewport(inlineViewport);
        this.viewportDimensionStack.pop();
        this.resetStructurePointer();
        this.popID(inlineViewport);
    }

    protected void startVParea(CTM cTM, Rectangle rectangle) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("startVParea() ctm=" + cTM + ", clippingRect=" + rectangle));
        }
        AffineTransform affineTransform = new AffineTransform(cTM.toArray());
        this.startViewport(affineTransform, rectangle);
        if (log.isTraceEnabled()) {
            log.trace((Object)("startVPArea: " + affineTransform + " --> " + this.graphicContext.getTransform()));
        }
    }

    private void startViewport(AffineTransform affineTransform, Rectangle rectangle) {
        this.saveGraphicsState();
        try {
            IFGraphicContext.Viewport viewport = new IFGraphicContext.Viewport(affineTransform, (Dimension)this.viewportDimensionStack.peek(), rectangle);
            this.graphicContext.pushGroup(viewport);
            viewport.start(this.painter);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void endVParea() {
        log.trace((Object)"endVParea()");
        this.endViewport();
        if (log.isTraceEnabled()) {
            log.trace((Object)("endVPArea() --> " + this.graphicContext.getTransform()));
        }
    }

    private void endViewport() {
        this.restoreGraphicsState();
    }

    protected void renderInlineArea(InlineArea inlineArea) {
        this.saveInlinePosIfTargetable(inlineArea);
        this.pushdID(inlineArea);
        super.renderInlineArea(inlineArea);
        this.popID(inlineArea);
    }

    public void renderInlineParent(InlineParent inlineParent) {
        Object object;
        Object object2;
        Rectangle rectangle = null;
        AbstractAction abstractAction = null;
        int n = this.currentIPPosition;
        int n2 = this.currentBPPosition + inlineParent.getBlockProgressionOffset();
        rectangle = new Rectangle(n, n2, inlineParent.getIPD(), inlineParent.getBPD());
        AffineTransform affineTransform = this.graphicContext.getTransform();
        rectangle = affineTransform.createTransformedShape(rectangle).getBounds();
        super.renderInlineParent(inlineParent);
        boolean bl = false;
        Trait.InternalLink internalLink = (Trait.InternalLink)inlineParent.getTrait(Trait.INTERNAL_LINK);
        if (internalLink != null) {
            boolean bl2;
            bl = true;
            object2 = internalLink.getPVKey();
            object = internalLink.getIDRef();
            boolean bl3 = object2 != null && ((String)object2).length() > 0;
            boolean bl4 = bl2 = object != null && ((String)object).length() > 0;
            if (bl3 && bl2) {
                Integer n3 = (Integer)this.pageIndices.get(object2);
                abstractAction = this.getGoToActionForID((String)object, n3 != null ? n3 : -1);
            }
        }
        if (!bl && (object2 = (Trait.ExternalLink)inlineParent.getTrait(Trait.EXTERNAL_LINK)) != null && (object = ((Trait.ExternalLink)object2).getDestination()) != null && ((String)object).length() > 0) {
            bl = true;
            abstractAction = new URIAction((String)object, ((Trait.ExternalLink)object2).newWindow());
            abstractAction = this.actionSet.put(abstractAction);
        }
        if (bl) {
            object2 = (StructureTreeElement)inlineParent.getTrait(Trait.STRUCTURE_TREE_ELEMENT);
            abstractAction.setStructureTreeElement((StructureTreeElement)object2);
            object = new Link(abstractAction, rectangle);
            this.deferredLinks.add(object);
        }
    }

    protected void renderBlock(Block block) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderBlock() " + block));
        }
        this.saveBlockPosIfTargetable(block);
        this.pushdID(block);
        super.renderBlock(block);
        this.popID(block);
    }

    private void pushdID(Area area) {
        String string = (String)area.getTrait(Trait.PROD_ID);
        if (string != null) {
            this.ids.push(string);
            this.documentHandler.getContext().setID(string);
        }
    }

    private void popID(Area area) {
        String string = (String)area.getTrait(Trait.PROD_ID);
        if (string != null) {
            this.ids.pop();
            this.documentHandler.getContext().setID(this.ids.empty() ? "" : this.ids.peek());
        }
    }

    private Typeface getTypeface(String string) {
        Typeface typeface = this.fontInfo.getFonts().get(string);
        if (typeface instanceof LazyFont) {
            typeface = ((LazyFont)typeface).getRealFont();
        }
        return typeface;
    }

    protected void renderText(TextArea textArea) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("renderText() " + textArea));
        }
        this.renderInlineAreaBackAndBorders(textArea);
        Color color = (Color)textArea.getTrait(Trait.COLOR);
        this.beginTextObject();
        String string = this.getInternalFontNameForArea(textArea);
        int n = (Integer)textArea.getTrait(Trait.FONT_SIZE);
        StructureTreeElement structureTreeElement = (StructureTreeElement)textArea.getTrait(Trait.STRUCTURE_TREE_ELEMENT);
        this.establishStructureTreeElement(structureTreeElement);
        Typeface typeface = this.getTypeface(string);
        FontTriplet fontTriplet = (FontTriplet)textArea.getTrait(Trait.FONT);
        try {
            this.painter.setFont(fontTriplet.getName(), fontTriplet.getStyle(), new Integer(fontTriplet.getWeight()), "normal", new Integer(n), color);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
        int n2 = this.currentIPPosition + textArea.getBorderAndPaddingWidthStart();
        int n3 = this.currentBPPosition + textArea.getBlockProgressionOffset() + textArea.getBaselineOffset();
        this.textUtil.flush();
        this.textUtil.setStartPosition(n2, n3);
        this.textUtil.setSpacing(textArea.getTextLetterSpaceAdjust(), textArea.getTextWordSpaceAdjust());
        super.renderText(textArea);
        this.textUtil.flush();
        this.renderTextDecoration(typeface, n, textArea, n3, n2);
        this.resetStructurePointer();
    }

    protected void renderWord(WordArea wordArea) {
        Font font = this.getFontFromArea(wordArea.getParentArea());
        String string = wordArea.getWord();
        int[][] nArray = wordArea.getGlyphPositionAdjustments();
        if (nArray == null) {
            nArray = IFUtil.convertDXToDP(wordArea.getLetterAdjustArray());
        }
        this.renderText(string, nArray, wordArea.isReversed(), font, (AbstractTextArea)wordArea.getParentArea());
        super.renderWord(wordArea);
    }

    protected void renderSpace(SpaceArea spaceArea) {
        Font font = this.getFontFromArea(spaceArea.getParentArea());
        String string = spaceArea.getSpace();
        AbstractTextArea abstractTextArea = (AbstractTextArea)spaceArea.getParentArea();
        this.renderText(string, null, false, font, abstractTextArea);
        super.renderSpace(spaceArea);
    }

    private void renderText(String string, int[][] nArray, boolean bl, Font font, AbstractTextArea abstractTextArea) {
        if (nArray == null || IFUtil.isDPOnlyDX(nArray)) {
            int[] nArray2 = IFUtil.convertDPToDX(nArray);
            this.renderTextWithAdjustments(string, nArray2, bl, font, abstractTextArea);
        } else {
            this.renderTextWithAdjustments(string, nArray, bl, font, abstractTextArea);
        }
    }

    private void renderTextWithAdjustments(String string, int[] nArray, boolean bl, Font font, AbstractTextArea abstractTextArea) {
        int n = string.length();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.textUtil.addChar(c);
            int n2 = 0;
            if (nArray != null && i < n) {
                n2 += nArray[i];
            }
            this.textUtil.adjust(n2);
        }
    }

    private void renderTextWithAdjustments(String string, int[][] nArray, boolean bl, Font font, AbstractTextArea abstractTextArea) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.textUtil.addChar(string.charAt(i));
            if (nArray == null) continue;
            this.textUtil.adjust(nArray[i]);
        }
    }

    public void renderImage(Image image, Rectangle2D rectangle2D) {
        this.drawImage(image.getURL(), rectangle2D, image.getForeignAttributes());
    }

    protected void drawImage(String string, Rectangle2D rectangle2D, Map map) {
        Rectangle rectangle = new Rectangle(this.currentIPPosition + (int)rectangle2D.getX(), this.currentBPPosition + (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        string = URISpecification.getURL(string);
        try {
            this.establishForeignAttributes(map);
            this.painter.drawImage(string, rectangle);
            this.resetForeignAttributes();
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    public void renderForeignObject(ForeignObject foreignObject, Rectangle2D rectangle2D) {
        this.endTextObject();
        Rectangle rectangle = new Rectangle(this.currentIPPosition + (int)rectangle2D.getX(), this.currentBPPosition + (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
        Document document = foreignObject.getDocument();
        try {
            this.establishForeignAttributes(foreignObject.getForeignAttributes());
            this.painter.drawImage(document, rectangle);
            this.resetForeignAttributes();
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    public void renderLeader(Leader leader) {
        this.renderInlineAreaBackAndBorders(leader);
        int n = leader.getRuleStyle();
        int n2 = leader.getRuleThickness();
        int n3 = this.currentIPPosition + leader.getBorderAndPaddingWidthStart();
        int n4 = this.currentBPPosition + leader.getBlockProgressionOffset() + n2 / 2;
        int n5 = this.currentIPPosition + leader.getBorderAndPaddingWidthStart() + leader.getIPD();
        Color color = (Color)leader.getTrait(Trait.COLOR);
        Point point = new Point(n3, n4);
        Point point2 = new Point(n5, n4);
        try {
            this.painter.drawLine(point, point2, n2, color, RuleStyle.valueOf(n));
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
        super.renderLeader(leader);
    }

    protected void clip() {
        throw new IllegalStateException("Not used");
    }

    protected void clipRect(float f, float f2, float f3, float f4) {
        this.pushGroup(new IFGraphicContext.Group());
        try {
            this.painter.clipRect(this.toMillipointRectangle(f, f2, f3, f4));
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void closePath() {
        throw new IllegalStateException("Not used");
    }

    protected void drawBorders(float f, float f2, float f3, float f4, BorderProps borderProps, BorderProps borderProps2, BorderProps borderProps3, BorderProps borderProps4, int n) {
        Rectangle rectangle = this.toMillipointRectangle(f, f2, f3, f4);
        try {
            BorderProps borderProps5;
            BorderProps borderProps6;
            BorderProps borderProps7 = borderProps;
            BorderProps borderProps8 = borderProps2;
            if (n == -1 || (n & 1) == 0) {
                borderProps6 = borderProps3;
                borderProps5 = borderProps4;
            } else {
                borderProps6 = borderProps4;
                borderProps5 = borderProps3;
            }
            this.painter.drawBorderRect(rectangle, borderProps7, borderProps8, borderProps6, borderProps5);
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void drawBorderLine(float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n, Color color) {
        this.updateColor(color, true);
        this.fillRect(f, f2, f3 - f, f4 - f2);
    }

    private int toMillipoints(float f) {
        return Math.round(f * 1000.0f);
    }

    private Rectangle toMillipointRectangle(float f, float f2, float f3, float f4) {
        return new Rectangle(this.toMillipoints(f), this.toMillipoints(f2), this.toMillipoints(f3), this.toMillipoints(f4));
    }

    protected void fillRect(float f, float f2, float f3, float f4) {
        try {
            this.painter.fillRect(this.toMillipointRectangle(f, f2, f3, f4), this.graphicContext.getPaint());
        }
        catch (IFException iFException) {
            this.handleIFException(iFException);
        }
    }

    protected void moveTo(float f, float f2) {
        throw new IllegalStateException("Not used");
    }

    protected void lineTo(float f, float f2) {
        throw new IllegalStateException("Not used");
    }

    protected void updateColor(Color color, boolean bl) {
        if (bl) {
            this.graphicContext.setPaint(color);
        } else {
            this.graphicContext.setColor(color);
        }
    }

    private class TextUtil {
        private static final int INITIAL_BUFFER_SIZE = 16;
        private int[][] dp = new int[16][4];
        private final StringBuffer text = new StringBuffer();
        private int startx;
        private int starty;
        private int tls;
        private int tws;
        private final boolean combined = false;

        private TextUtil() {
        }

        void addChar(char c) {
            this.text.append(c);
        }

        void adjust(int n) {
            this.adjust(new int[]{n, 0, n, 0});
        }

        void adjust(int[] nArray) {
            if (!IFUtil.isPAIdentity(nArray)) {
                int n = this.text.length();
                if (n > this.dp.length - 1) {
                    int n2 = Math.max(this.dp.length, n + 1) + 16;
                    int[][] nArrayArray = new int[n2][];
                    System.arraycopy(this.dp, 0, nArrayArray, 0, this.dp.length);
                    int n3 = nArrayArray.length;
                    for (int i = this.dp.length; i < n3; ++i) {
                        nArrayArray[i] = new int[4];
                    }
                    this.dp = nArrayArray;
                }
                IFUtil.adjustPA(this.dp[n - 1], nArray);
            }
        }

        void reset() {
            if (this.text.length() > 0) {
                this.text.setLength(0);
                int n = this.dp.length;
                for (int i = 0; i < n; ++i) {
                    Arrays.fill(this.dp[i], 0);
                }
            }
        }

        void setStartPosition(int n, int n2) {
            this.startx = n;
            this.starty = n2;
        }

        void setSpacing(int n, int n2) {
            this.tls = n;
            this.tws = n2;
        }

        void flush() {
            if (this.text.length() > 0) {
                try {
                    IFRenderer.this.painter.drawText(this.startx, this.starty, this.tls, this.tws, this.trimAdjustments(this.dp, this.text.length()), this.text.toString());
                }
                catch (IFException iFException) {
                    IFRenderer.this.handleIFException(iFException);
                }
                this.reset();
            }
        }

        private int[][] trimAdjustments(int[][] nArray, int n) {
            if (nArray != null) {
                int[] nArray2;
                int n2;
                int n3 = n;
                int n4 = nArray.length;
                int n5 = n2 = n3 < n4 ? n3 : n4;
                while (n2 > 0 && IFUtil.isPAIdentity(nArray2 = nArray[n2 - 1])) {
                    --n2;
                }
                if (n2 == 0) {
                    nArray = null;
                } else if (n2 < n4) {
                    nArray = IFUtil.copyDP(nArray, 0, n2);
                }
            }
            return nArray;
        }
    }
}

