/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import org.apache.avalon.framework.configuration.Configuration;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.bitmap.BitmapRendererConfigurator;
import org.apache.fop.render.bitmap.BitmapRenderingSettings;
import org.apache.fop.render.bitmap.TIFFDocumentHandler;
import org.apache.fop.render.bitmap.TIFFRenderer;
import org.apache.fop.render.intermediate.IFDocumentHandler;

public class TIFFRendererConfigurator
extends BitmapRendererConfigurator {
    public TIFFRendererConfigurator(FOUserAgent fOUserAgent) {
        super(fOUserAgent);
    }

    public void configure(Renderer renderer) throws FOPException {
        Configuration configuration = super.getRendererConfig(renderer);
        if (configuration != null) {
            TIFFRenderer tIFFRenderer = (TIFFRenderer)renderer;
            String string = configuration.getChild("compression").getValue("PackBits");
            tIFFRenderer.setBufferedImageType(this.getBufferedImageTypeFor(string));
            if (!"NONE".equalsIgnoreCase(string)) {
                tIFFRenderer.getWriterParams().setCompressionMethod(string);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("TIFF compression set to " + string));
            }
        }
        super.configure(renderer);
    }

    private int getBufferedImageTypeFor(String string) {
        if (string.equalsIgnoreCase("CCITT T.6")) {
            return 12;
        }
        if (string.equalsIgnoreCase("CCITT T.4")) {
            return 12;
        }
        return 2;
    }

    public void configure(IFDocumentHandler iFDocumentHandler) throws FOPException {
        super.configure(iFDocumentHandler);
        Configuration configuration = super.getRendererConfig(iFDocumentHandler.getMimeType());
        if (configuration != null) {
            TIFFDocumentHandler tIFFDocumentHandler = (TIFFDocumentHandler)iFDocumentHandler;
            BitmapRenderingSettings bitmapRenderingSettings = tIFFDocumentHandler.getSettings();
            String string = configuration.getChild("compression").getValue("PackBits");
            bitmapRenderingSettings.setBufferedImageType(this.getBufferedImageTypeFor(string));
            if (!"NONE".equalsIgnoreCase(string)) {
                bitmapRenderingSettings.getWriterParams().setCompressionMethod(string);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("TIFF compression set to " + string));
            }
        }
    }
}

